package com.zbkj.service.service.bcx;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxFapiaoApply;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyCreateRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyRejectRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyRequest;
import com.zbkj.common.request.bcx.BcxWriteFapiaoRequest;
import com.zbkj.common.response.bcx.BcxFapiaoApplyDetailResponse;
import com.zbkj.common.response.bcx.BcxFapiaoApplyResponse;
import com.zbkj.common.response.bcx.BcxFapiaoLastSendToResponse;
import com.zbkj.common.response.bcx.BcxSummaryInfo;

/**
 * 发票申请单 服务接口
 */
public interface BcxFapiaoApplyService extends IService<BcxFapiaoApply> {

    BcxFapiaoApplyResponse queryById(Integer id);

    PageInfo<BcxFapiaoApplyResponse> queryWriterPagedList(BcxFapiaoApplyRequest request, PageParamRequest pageParamRequest);

    BcxFapiaoApply create(BcxFapiaoApplyCreateRequest request);

    boolean writeFapiao(BcxWriteFapiaoRequest record);

    BcxFapiaoApplyDetailResponse queryByApplyNo(String applyNo);

    boolean rejectById(BcxFapiaoApplyRejectRequest request);

    BcxSummaryInfo getWriterSummaryInfo(BcxFapiaoApplyRequest request);

    BcxSummaryInfo getReceiverSummaryInfo(BcxFapiaoApplyRequest request);

    BcxFapiaoLastSendToResponse lastSendTo();

    PageInfo<BcxFapiaoApplyResponse> queryReceiverPagedList(BcxFapiaoApplyRequest request, PageParamRequest pageParamRequest);
}
