package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.huifu.bspay.sdk.opps.client.BasePayClient;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.config.MerConfig;
import com.huifu.bspay.sdk.opps.core.request.BaseRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Map;

/***
 * @Description 功能描述：公共的参数封装DEMO
 * @Date 2021/4/19 15:41
 */
public class BaseCommon {

    private static final Logger logger = LoggerFactory.getLogger(BaseCommon.class);

    /***
     * @Description: 初始化设置商户公共参数（全局只需设置一次）
     * @param merConfig
     * @throws Exception
     * @date: 2021年7月5日17:59:33
     */
    public static void doInit(MerConfig merConfig) throws Exception {
        BasePay.initWithMerConfig(merConfig);
    }

    /***
     * @Description: 添加配置（全局只需设置一次）
     * @param merConfig
     * @param merchantKey 设置配置的key
     * @throws Exception
     * @date: 2021年7月5日17:59:33
     */
    public static void addMerConfig(MerConfig merConfig,String merchantKey) throws Exception {
        BasePay.addMerConfig(merConfig,merchantKey);
    }

    /***
     * @Description: 执行API调用
     * @param request
     * @throws Exception  Map<String,Object>
     * @date: 2021年7月5日17:59:37
     */
    public static Map<String, Object> doExecute(BaseRequest request) throws Exception {
        logger.info("=====> BaseCommon:Star.");
        logger.info("=====> request:"+ JSON.toJSONString(request));
        Map<String, Object> res = BasePayClient.request(request, false);
        logger.info("=====> response:"+ JSON.toJSONString(res));
        return res;
    }

    /***
     * @Description: 执行API调用
     * @param request
     * @param merchantKey 引用配置：放空 读默认配置，有key 读初始化key设置的配置
     * @throws Exception  Map<String,Object>
     * @date: 2021年7月5日17:59:37
     */
    public static Map<String, Object> doExecute(BaseRequest request,String merchantKey) throws Exception {
        logger.info("=====> BaseCommon:Star.");
        logger.info("=====> request:"+ JSON.toJSONString(request));
        Map<String, Object> res = null;
        if(StringUtils.isEmpty(merchantKey)){
            res = BasePayClient.request(request, false);
        }else{
            res = BasePayClient.request(request, request.getFunctionCode().getCode(), merchantKey, false);
        }
        logger.info("=====> response:"+ JSON.toJSONString(res));
        return res;
    }

    /***
     * @Description: 执行API调用
     * @param request 请求参数
     * @param isPage 是否是页面版本
     * @throws Exception  Map<String,Object>
     * @date: 2021年11月12日15:13:56
     */
    public static Map<String, Object> doExecute(BaseRequest request, boolean isPage) throws Exception {
        return BasePayClient.request(request, isPage);
    }

    /**
     * 执行API调用
     *
     * @param request 请求参数
     * @param file    待上传文件
     * @return
     * @throws Exception
     */
    public static Map<String, Object> doExecute(BaseRequest request, File file) throws Exception {
        return BasePayClient.upload(request, file);
    }

}
