package com.zbkj.service.huifu.v2;

import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradeAcctpaymentPayRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.service.huifu.constants.HFProfileConstants;
import com.zbkj.service.huifu.core.Identify;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 余额支付 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeAcctpaymentPayRequest.class)
public class V2TradeAcctpaymentPay {

    public static V2TradeAcctpaymentPayRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeAcctpaymentPayRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeAcctpaymentPayRequest.class);
//        V2TradeAcctpaymentPayRequest request = new V2TradeAcctpaymentPayRequest();
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 出款方商户号
//        request.setOutHuifuId("6666000018344461");
        // 支付金额
//        request.setOrdAmt("0.01");
        // 分账对象
        request.setAcctSplitBunch(getAcctSplitBunch(map));
        // 安全信息
        request.setRiskCheckData(getRiskCheckData());

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // ~~发起方商户号~~
        // extendInfoMap.put("~~huifu_id~~", "");
        // 商品描述
         extendInfoMap.put("good_desc", map.get("goodDesc"));
        // 备注
         extendInfoMap.put("remark", map.get("comment"));
        // 是否延迟交易
        // extendInfoMap.put("delay_acct_flag", "");
        // 设备信息
        extendInfoMap.put("terminal_device_data", getTerminalDeviceData());
        // 出款方账户号
        // extendInfoMap.put("out_acct_id", "");
        return extendInfoMap;
    }

    private static String getTerminalDeviceData() {
        //客户IP获取
        String clientIP = "127.0.0.1";
        try{
            HttpServletRequest request = RequestUtil.getRequest();
            clientIP = ServletUtil.getClientIP(request, null);
        }catch (Exception e){}

        JSONObject dto = new JSONObject();
        // 设备类型
        dto.put("device_type", "4");
        // 交易设备IP
        dto.put("device_ip", clientIP);
        // 交易设备MAC
        // dto.put("device_mac", "");
        // 交易设备GPS
        // dto.put("device_gps", "");
        // 交易设备IMEI
        // dto.put("device_imei", "");
        // 交易设备IMSI
        // dto.put("device_imsi", "");
        // 交易设备ICCID
        // dto.put("device_icc_id", "");
        // 交易设备WIFIMAC
        // dto.put("device_wifi_mac", "");

        return dto.toJSONString();
    }

    private static JSON getAcctInfos(Map<String, Object> map) {
        JSONArray dtoList = new JSONArray();
        JSONObject dto1 = new JSONObject();
        // 分账金额
        dto1.put("div_amt", map.get("inAmount"));
        // 被分账方ID
        dto1.put("huifu_id", map.get("inWalletAccountNo"));
        // 被分账方账户号
        // dto1.put("acct_id", "");
        dtoList.add(dto1);
        /*//平台分账
        if("1".equals(map.get("isPlatAcct"))){
            JSONObject dto2 = new JSONObject();
            // 分账金额
            dto2.put("div_amt", map.get("platAmount"));
            // 被分账方ID
            dto2.put("huifu_id", HFProfileConstants.HUIFU_ID);
            // 被分账方账户号
            // dto2.put("acct_id", "");
            dtoList.add(dto2);
        }*/
        return dtoList;
    }

    private static String getAcctSplitBunch(Map<String, Object> map) {
        JSONObject dto = new JSONObject();
        // 分账明细
        dto.put("acct_infos", getAcctInfos(map));

        return dto.toJSONString();
    }

    private static String getRiskCheckData() {
        JSONObject dto = new JSONObject();
        // 转账原因
        dto.put("transfer_type", "03");
        // 产品子类
//        dto.put("sub_product", "1");
        // 纬度
        // dto.put("latitude", "");
        // 经度
        // dto.put("longitude", "");
        // 基站地址
        // dto.put("base_station", "");
        // IP地址
        // dto.put("ip_addr", "");

        return dto.toJSONString();
    }

}
