/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.express.ShippingTemplatesRegion;
import com.zbkj.common.request.ShippingTemplatesRegionRequest;
import com.zbkj.common.response.ShippingTemplatesRegionResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.ShippingTemplatesRegionDao;
import com.zbkj.service.service.ShippingTemplatesRegionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;

@Service
public class ShippingTemplatesRegionServiceImpl
extends ServiceImpl<ShippingTemplatesRegionDao, ShippingTemplatesRegion>
implements ShippingTemplatesRegionService {
    @Resource
    private ShippingTemplatesRegionDao dao;

    public List<ShippingTemplatesRegion> listByIds(Collection<? extends Serializable> idList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.in(ShippingTemplatesRegion::getTempId, idList);
        lqw.orderByAsc(ShippingTemplatesRegion::getCityId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean saveAll(List<ShippingTemplatesRegionRequest> shippingTemplatesRegionRequestList, Integer type, Integer tempId) {
        ArrayList<ShippingTemplatesRegion> shippingTemplatesRegionList = new ArrayList<ShippingTemplatesRegion>();
        for (ShippingTemplatesRegionRequest shippingTemplatesRegionRequest : shippingTemplatesRegionRequestList) {
            String uniqueKey = DigestUtils.md5Hex((String)shippingTemplatesRegionRequest.toString());
            List titleArray = JSONArray.parseArray((String)shippingTemplatesRegionRequest.getTitle(), String.class);
            if (shippingTemplatesRegionRequest.getCityId().equals("all") || shippingTemplatesRegionRequest.getCityId().equals("0")) {
                ShippingTemplatesRegion shippingTemplatesRegion = new ShippingTemplatesRegion();
                shippingTemplatesRegion.setCityId(Integer.valueOf(0));
                shippingTemplatesRegion.setTitle((String)titleArray.get(0));
                shippingTemplatesRegion.setUniqid(uniqueKey);
                shippingTemplatesRegion.setRenewal(shippingTemplatesRegionRequest.getRenewal());
                shippingTemplatesRegion.setRenewalPrice(shippingTemplatesRegionRequest.getRenewalPrice());
                shippingTemplatesRegion.setFirst(shippingTemplatesRegionRequest.getFirst());
                shippingTemplatesRegion.setFirstPrice(shippingTemplatesRegionRequest.getFirstPrice());
                shippingTemplatesRegion.setTempId(tempId);
                shippingTemplatesRegion.setType(type);
                shippingTemplatesRegionList.add(shippingTemplatesRegion);
                continue;
            }
            List cityIdList = CrmebUtil.stringToArray((String)shippingTemplatesRegionRequest.getCityId());
            HashMap cityMap = new HashMap();
            titleArray.forEach(e -> {
                JSONArray parseArray = JSONArray.parseArray((String)e);
                Integer cityId = parseArray.getInteger(2);
                cityMap.put(cityId, e);
            });
            for (Integer cityId : cityIdList) {
                ShippingTemplatesRegion shippingTemplatesRegion = new ShippingTemplatesRegion();
                shippingTemplatesRegion.setCityId(cityId);
                shippingTemplatesRegion.setTitle((String)cityMap.get(cityId));
                shippingTemplatesRegion.setUniqid(uniqueKey);
                shippingTemplatesRegion.setRenewal(shippingTemplatesRegionRequest.getRenewal());
                shippingTemplatesRegion.setRenewalPrice(shippingTemplatesRegionRequest.getRenewalPrice());
                shippingTemplatesRegion.setFirst(shippingTemplatesRegionRequest.getFirst());
                shippingTemplatesRegion.setFirstPrice(shippingTemplatesRegionRequest.getFirstPrice());
                shippingTemplatesRegion.setTempId(tempId);
                shippingTemplatesRegion.setType(type);
                shippingTemplatesRegionList.add(shippingTemplatesRegion);
            }
        }
        return this.saveBatch(shippingTemplatesRegionList);
    }

    @Override
    public Boolean deleteByTempId(Integer tempId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(ShippingTemplatesRegion::getTempId, (Object)tempId);
        return this.dao.delete((Wrapper)wrapper) > 0;
    }

    @Override
    public ShippingTemplatesRegion getByTempIdAndCityId(Integer tempId, Integer cityId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ShippingTemplatesRegion::getTempId, (Object)tempId);
        lambdaQueryWrapper.eq(ShippingTemplatesRegion::getCityId, (Object)cityId);
        lambdaQueryWrapper.orderByDesc(ShippingTemplatesRegion::getId);
        lambdaQueryWrapper.last(" limit 1");
        return (ShippingTemplatesRegion)this.dao.selectOne((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean existCityId(Integer regionId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{ShippingTemplatesRegion::getId});
        lqw.eq(ShippingTemplatesRegion::getCityId, (Object)regionId);
        lqw.last(" limit 1");
        ShippingTemplatesRegion shippingTemplatesRegion = (ShippingTemplatesRegion)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)shippingTemplatesRegion);
    }

    @Override
    public List<ShippingTemplatesRegionResponse> getListGroup(Integer tempId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ShippingTemplatesRegion::getTitle, ShippingTemplatesRegion::getFirst, ShippingTemplatesRegion::getFirstPrice, ShippingTemplatesRegion::getRenewal, ShippingTemplatesRegion::getRenewalPrice, ShippingTemplatesRegion::getUniqid});
        lqw.eq(ShippingTemplatesRegion::getTempId, (Object)tempId);
        List list = this.dao.selectList((Wrapper)lqw);
        ArrayList responseList = CollUtil.newArrayList((Object[])new ShippingTemplatesRegionResponse[0]);
        if (CollUtil.isEmpty((Collection)list)) {
            return responseList;
        }
        Map<String, List<ShippingTemplatesRegion>> listMap = list.stream().collect(Collectors.groupingBy(ShippingTemplatesRegion::getUniqid));
        Set<Map.Entry<String, List<ShippingTemplatesRegion>>> entrySet = listMap.entrySet();
        for (Map.Entry<String, List<ShippingTemplatesRegion>> entry : entrySet) {
            String uniqid = entry.getKey();
            String title = entry.getValue().stream().map(ShippingTemplatesRegion::getTitle).collect(Collectors.joining(","));
            ShippingTemplatesRegion region = entry.getValue().get(0);
            ShippingTemplatesRegionResponse response = new ShippingTemplatesRegionResponse();
            response.setTitle(title);
            response.setUniqid(uniqid);
            response.setFirst(region.getFirst());
            response.setFirstPrice(region.getFirstPrice());
            response.setRenewal(region.getRenewal());
            response.setRenewalPrice(region.getRenewalPrice());
            responseList.add(response);
        }
        return responseList;
    }
}

