package com.zbkj.front.controller.bcx;

import com.zbkj.common.model.bcx.BcxUserOrgAuth;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxUserOrgAuthRequest;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.bcx.BcxUserOrgAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 用户企业认证表 控制层
 */
@Slf4j
@Api(tags = "用户企业认证 控制器")
@RestController
@RequestMapping("/api/front/bcxUserOrgAuth")
public class BcxUserOrgAuthController {

    @Autowired
    private BcxUserOrgAuthService bcxUserOrgAuthService;


    @ApiOperation("查询用户企业认证")
    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public CommonResult<BcxUserOrgAuth> queryUserOrg() {
        return CommonResult.success(bcxUserOrgAuthService.queryUserOrg());
    }

//    @ApiOperation("查询分页用户企业认证")
//    @RequestMapping(value = "/list", method = RequestMethod.GET)
//    public CommonResult<CommonPage<BcxUserOrgAuth>> queryPagedList(@Validated BcxUserOrgAuth request,
//                                                                   @Validated PageParamRequest pageParamRequest) {
//        return CommonResult.success(CommonPage.restPage(bcxUserOrgAuthService.queryPagedList(request, pageParamRequest)));
//    }

    @ApiOperation("新增用户企业认证表")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<BcxUserOrgAuth> create(@RequestBody @Validated BcxUserOrgAuthRequest request) {
        if (bcxUserOrgAuthService.create(request)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

//    @ApiOperation("修改用户企业认证表")
//    @RequestMapping(value = "/update", method = RequestMethod.POST)
//    public CommonResult<BcxUserOrgAuth> update(@RequestBody @Validated BcxUserOrgAuth bcxUserOrgAuth) {
//        if (bcxUserOrgAuthService.update(bcxUserOrgAuth)) {
//            return CommonResult.success();
//        }
//        return CommonResult.failed();
//    }
//
//    @ApiOperation("删除用户企业认证表")
//    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST)
//    public CommonResult<String> delete(@PathVariable Integer id) {
//        if (bcxUserOrgAuthService.delete(id)) {
//            return CommonResult.success();
//        }
//        return CommonResult.failed();
//    }
}
