package com.zbkj.front.controller.bcx;

import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoSourceRequest;
import com.zbkj.common.response.bcx.BcxFapiaoSourceResponse;
import com.zbkj.common.response.bcx.BcxSummaryInfo;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.bcx.BcxFapiaoSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 发票源单据 控制层
 */
@Slf4j
@Api(tags = "发票源单据控制器")
@RestController
@RequestMapping("/api/front/fapiao/source")
public class BcxFapiaoSourceController {

    @Autowired
    private BcxFapiaoSourceService bcxFapiaoSourceService;

    @ApiOperation("查询分页发票源单据")
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public CommonResult<CommonPage<BcxFapiaoSourceResponse>> queryPagedList(@RequestBody @Validated BcxFapiaoSourceRequest request,
                                                                            @Validated PageParamRequest pageParamRequest){
        return CommonResult.success(CommonPage.restPage(bcxFapiaoSourceService.queryPagedList(request, pageParamRequest)));
    }

    @ApiOperation(value = "获取列表统计数据")
    @RequestMapping(value = "/summary", method = RequestMethod.POST)
    public CommonResult<BcxSummaryInfo> getOrderSummary(@RequestBody @Validated BcxFapiaoSourceRequest request) {
        return CommonResult.success(bcxFapiaoSourceService.getSummaryInfo(request));
    }
}
