package com.zbkj.admin.controller.platform;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxSettleAttachments;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxDoSettleRequest;
import com.zbkj.common.request.BcxSettleSearchRequest;
import com.zbkj.common.request.BcxSettleUploadAttachmentsRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxSettleDetailResponse;
import com.zbkj.common.response.BcxSettleInfoResponse;
import com.zbkj.common.response.BcxSettleResponse;
import com.zbkj.common.response.BcxSettleStatisticsResponse;
import com.zbkj.common.response.excel.*;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.utils.ExportUtil;
import com.zbkj.service.service.BcxSettleAttachmentsService;
import com.zbkj.service.service.BcxSettleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description: 结算表 控制层
 * author : linchunpeng
 * date : 2023/9/1
 */
@Slf4j
@Api(tags = "分销系统-结算表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/settle")
public class BcxSettleController {
    
    @Autowired
    private BcxSettleService bcxSettleService;
    @Autowired
    private BcxSettleAttachmentsService bcxSettleAttachmentsService;

    @ApiOperation(value = "结算单统计 ")
    @RequestMapping(value = "/statistics", method = RequestMethod.GET)
    public CommonResult<BcxSettleStatisticsResponse> statistics(@Validated BcxSettleSearchRequest searchRequest) throws ParseException {
        return CommonResult.success(bcxSettleService.statistics(searchRequest));
    }

    @ApiOperation(value = "渠道结算单")
    @RequestMapping(value = "/channel/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getChannelList(@Validated BcxSettleSearchRequest searchRequest,
                                                                          @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(1);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "部门结算单")
    @RequestMapping(value = "/department/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getDepartmentList(@Validated BcxSettleSearchRequest searchRequest,
                                                                             @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(2);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "部门成员结算单")
    @RequestMapping(value = "/department/member/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getDepartmentMemberList(@Validated BcxSettleSearchRequest searchRequest,
                                                                               @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(3);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "分销商结算单")
    @RequestMapping(value = "/fxs/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getFxsList(@Validated BcxSettleSearchRequest searchRequest,
                                                                      @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(4);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "分销员结算单")
    @RequestMapping(value = "/fxy/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getFxyList(@Validated BcxSettleSearchRequest searchRequest,
                                                                      @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(5);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "获取生成结算单数据")
    @RequestMapping(value = "/get/settle/info", method = RequestMethod.POST)
    public CommonResult<BcxSettleInfoResponse> getSettleInfo(@RequestBody @Validated BcxDoSettleRequest request) {
        return CommonResult.success(bcxSettleService.getSettleInfo(request));
    }

    @ApiOperation(value = "结算")
    @RequestMapping(value = "/do/settle", method = RequestMethod.POST)
    public CommonResult<Object> doSettle(@RequestBody @Validated BcxDoSettleRequest request) {
        return CommonResult.success(bcxSettleService.doSettle(request));
    }

    @ApiOperation(value = "撤销")
    @RequestMapping(value = "/cancel/{id}", method = RequestMethod.POST)
    public CommonResult<Object> cancel(@PathVariable(name = "id") Long id) {
        return CommonResult.success(bcxSettleService.cancel(id));
    }

    @ApiOperation(value = "结算单详情")
    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public CommonResult<BcxSettleDetailResponse> detail(@PathVariable(name = "id") Long id)  {
        return CommonResult.success(bcxSettleService.findId(id));
    }

    @ApiOperation(value = "渠道结算单-导出excel")
    @RequestMapping(value = "/channel/list/excel", method = {RequestMethod.GET})
    public void channelListExcel(@Validated BcxSettleSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleChannelExcelDto> resultList = Collections.singletonList(new BcxSettleChannelExcelDto());
        searchRequest.setSearchType(1);
        List<BcxSettleResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleChannelExcelDto excelVo = new BcxSettleChannelExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleChannelExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("渠道结算单", resultList, response);
    }

    @ApiOperation(value = "部门结算单-导出excel")
    @RequestMapping(value = "/department/list/excel", method = {RequestMethod.GET})
    public void departmentListExcel(@Validated BcxSettleSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleDepartmentExcelDto> resultList = Collections.singletonList(new BcxSettleDepartmentExcelDto());
        searchRequest.setSearchType(2);
        List<BcxSettleResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleDepartmentExcelDto excelVo = new BcxSettleDepartmentExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleDepartmentExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("部门结算单", resultList, response);
    }

    @ApiOperation(value = "部门成员结算单-导出excel")
    @RequestMapping(value = "/department/member/list/excel", method = {RequestMethod.GET})
    public void departmentMemberListExcel(@Validated BcxSettleSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleDepartmentMemberExcelDto> resultList = Collections.singletonList(new BcxSettleDepartmentMemberExcelDto());
        searchRequest.setSearchType(3);
        List<BcxSettleResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleDepartmentMemberExcelDto excelVo = new BcxSettleDepartmentMemberExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleDepartmentMemberExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("部门成员结算单", resultList, response);
    }

    @ApiOperation(value = "分销商结算单-导出excel")
    @RequestMapping(value = "/fxs/list/excel", method = {RequestMethod.GET})
    public void fxsListExcel(@Validated BcxSettleSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleFxsExcelDto> resultList = Collections.singletonList(new BcxSettleFxsExcelDto());
        searchRequest.setSearchType(4);
        List<BcxSettleResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleFxsExcelDto excelVo = new BcxSettleFxsExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleFxsExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("分销商结算单", resultList, response);
    }

    @ApiOperation(value = "分销员结算单-导出excel")
    @RequestMapping(value = "/fxy/list/excel", method = {RequestMethod.GET})
    public void fxyListExcel(@Validated BcxSettleSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleFxyExcelDto> resultList = Collections.singletonList(new BcxSettleFxyExcelDto());
        searchRequest.setSearchType(5);
        List<BcxSettleResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleFxyExcelDto excelVo = new BcxSettleFxyExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleFxyExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("分销员结算单", resultList, response);
    }

    /**
     * description：获取列表
     * author：linchunpeng
     * date：2023/8/29
     */
    private List<BcxSettleResponse> getList(BcxSettleSearchRequest searchRequest) {
        try {
            PageParamRequest pageParamRequest = new PageParamRequest();
            pageParamRequest.setLimit(10000);
            PageInfo<BcxSettleResponse> page = bcxSettleService.getPage(searchRequest, pageParamRequest);
            return page.getList();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value = "上传附件")
    @RequestMapping(value = "/upload/attachments", method = RequestMethod.POST)
    public CommonResult<Object> uploadAttachments(@RequestBody @Validated BcxSettleUploadAttachmentsRequest request) {
        return CommonResult.success(bcxSettleAttachmentsService.uploadAttachments(request));
    }

    @ApiOperation(value = "获取附件列表")
    @RequestMapping(value = "/get/attachments{id}", method = RequestMethod.GET)
    public CommonResult<List<BcxSettleAttachments>> getAttachments(@PathVariable(name = "id") Long id) {
        return CommonResult.success(bcxSettleAttachmentsService.findBySettleId(id));
    }
}