package com.zbkj.admin.controller.platform;

import com.zbkj.common.response.BcxRegionResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxRegionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * description: v5区域表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-v5区域表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/region")
public class BcxRegionController {
    
    @Autowired
    private BcxRegionService bcxRegionService;


//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "获取区域tree列表")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    public CommonResult<List<BcxRegionResponse>> findAllTree() {
        return CommonResult.success(bcxRegionService.findAllTree());
    }


}