package com.zbkj.admin.controller.platform;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxPerformanceReportSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxPerformanceReportResponse;
import com.zbkj.common.response.BcxPerformanceReportStatisticsResponse;
import com.zbkj.common.response.excel.BcxPerformanceReportChannelExcelDto;
import com.zbkj.common.response.excel.BcxPerformanceReportDepartmentExcelDto;
import com.zbkj.common.response.excel.BcxPerformanceReportDepartmentMemberExcelDto;
import com.zbkj.common.response.excel.BcxPerformanceReportFxUserExcelDto;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.utils.ExportUtil;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BcxSettleBillService;
import com.zbkj.service.service.BcxSettleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description: 业绩报表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-业绩报表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/performance/report")
public class BcxPerformanceReportController {

    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;
    @Autowired
    private BcxSettleBillService bcxSettleBillService;
    @Autowired
    private BcxSettleService bcxSettleService;

    @ApiOperation(value = "业绩报表统计 ")
    @RequestMapping(value = "/statistics", method = RequestMethod.GET)
    public CommonResult<BcxPerformanceReportStatisticsResponse> statistics(@Validated BcxPerformanceReportSearchRequest searchRequest) {
        return CommonResult.success(bcxPerformanceReportService.statistics(searchRequest));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:performance:report:channel')")
    @ApiOperation(value = "渠道佣金列表")
    @RequestMapping(value = "/channel/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getChannelList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) {
        searchRequest.setSearchType(1);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:performance:report:department')")
    @ApiOperation(value = "部门佣金列表")
    @RequestMapping(value = "/department/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getDepartmentList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) {
        searchRequest.setSearchType(2);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:performance:report:department:member')")
    @ApiOperation(value = "部门成员佣金列表")
    @RequestMapping(value = "/department/member/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getDepartmentMemberList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) {
        searchRequest.setSearchType(3);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:performance:report:fxs')")
    @ApiOperation(value = "分销商佣金列表")
    @RequestMapping(value = "/fxs/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getFxsList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) {
        searchRequest.setSearchType(4);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:performance:report:fxy')")
    @ApiOperation(value = "分销员佣金列表")
    @RequestMapping(value = "/fxy/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getFxyList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) {
        searchRequest.setSearchType(5);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "账单佣金列表")
    @RequestMapping(value = "/settle/bill/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getSettleBillList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                             @Validated PageParamRequest pageParamRequest) {
        BcxSettleBill settleBill = bcxSettleBillService.getById(searchRequest.getSettleBillId());
        searchRequest.setSearchType(settleBill.getBelongType());
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "结算单佣金列表")
    @RequestMapping(value = "/settle/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getSettleList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                    @Validated PageParamRequest pageParamRequest) {
        BcxSettle settle = bcxSettleService.getById(searchRequest.getSettleId());
        searchRequest.setSearchType(settle.getBelongType());
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "渠道佣金列表-导出excel")
    @RequestMapping(value = "/channel/list/excel", method = {RequestMethod.GET})
    public void channelListExcel(@Validated BcxPerformanceReportSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxPerformanceReportChannelExcelDto> resultList = Collections.singletonList(new BcxPerformanceReportChannelExcelDto());
        searchRequest.setSearchType(1);
        List<BcxPerformanceReportResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxPerformanceReportChannelExcelDto excelVo = new BcxPerformanceReportChannelExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxPerformanceReportChannelExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("渠道佣金列表", resultList, response);
    }

    @ApiOperation(value = "部门佣金列表-导出excel")
    @RequestMapping(value = "/department/list/excel", method = {RequestMethod.GET})
    public void departmentListExcel(@Validated BcxPerformanceReportSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxPerformanceReportDepartmentExcelDto> resultList = Collections.singletonList(new BcxPerformanceReportDepartmentExcelDto());
        searchRequest.setSearchType(2);
        List<BcxPerformanceReportResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxPerformanceReportDepartmentExcelDto excelVo = new BcxPerformanceReportDepartmentExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxPerformanceReportDepartmentExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("部门佣金列表", resultList, response);
    }

    @ApiOperation(value = "部门成员佣金列表-导出excel")
    @RequestMapping(value = "/department/member/list/excel", method = {RequestMethod.GET})
    public void departmentMemberListExcel(@Validated BcxPerformanceReportSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxPerformanceReportDepartmentMemberExcelDto> resultList = Collections.singletonList(new BcxPerformanceReportDepartmentMemberExcelDto());
        searchRequest.setSearchType(3);
        List<BcxPerformanceReportResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxPerformanceReportDepartmentMemberExcelDto excelVo = new BcxPerformanceReportDepartmentMemberExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxPerformanceReportDepartmentMemberExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("部门成员佣金列表", resultList, response);
    }

    @ApiOperation(value = "分销商佣金列表-导出excel")
    @RequestMapping(value = "/fxs/list/excel", method = {RequestMethod.GET})
    public void fxsListExcel(@Validated BcxPerformanceReportSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxPerformanceReportFxUserExcelDto> resultList = Collections.singletonList(new BcxPerformanceReportFxUserExcelDto());
        searchRequest.setSearchType(4);
        List<BcxPerformanceReportResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxPerformanceReportFxUserExcelDto excelVo = new BcxPerformanceReportFxUserExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxPerformanceReportFxUserExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("分销商佣金列表", resultList, response);
    }

    @ApiOperation(value = "分销员佣金列表-导出excel")
    @RequestMapping(value = "/fxy/list/excel", method = {RequestMethod.GET})
    public void fxyListExcel(@Validated BcxPerformanceReportSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxPerformanceReportFxUserExcelDto> resultList = Collections.singletonList(new BcxPerformanceReportFxUserExcelDto());
        searchRequest.setSearchType(5);
        List<BcxPerformanceReportResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxPerformanceReportFxUserExcelDto excelVo = new BcxPerformanceReportFxUserExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxPerformanceReportFxUserExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("分销员佣金列表", resultList, response);
    }


    /**
     * description：获取列表
     * author：linchunpeng
     * date：2023/8/29
     */
    private List<BcxPerformanceReportResponse> getList(BcxPerformanceReportSearchRequest searchRequest) {
        PageParamRequest pageParamRequest = new PageParamRequest();
        pageParamRequest.setLimit(10000);
        PageInfo<BcxPerformanceReportResponse> page = bcxPerformanceReportService.getPage(searchRequest, pageParamRequest);
        return page.getList();
    }

}