package com.zbkj.admin.controller.platform;

import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxDepartmentMemberSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxDepartmentMemberResponse;
import com.zbkj.common.response.BcxDepartmentResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxDepartmentMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * description: 部门成员表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-部门成员表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/department/member")
public class BcxDepartmentMemberController {
    
    @Autowired
    private BcxDepartmentMemberService bcxDepartmentMemberService;


//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "获取部门成员tree列表")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    public CommonResult<List<BcxDepartmentResponse>> findAllTree() {
        return CommonResult.success(bcxDepartmentMemberService.findAllTree());
    }



    //    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "获取部门成员列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxDepartmentMemberResponse>> list(@Validated BcxDepartmentMemberSearchRequest searchRequest,
                                                                      @Validated PageParamRequest pageParamRequest) {
        return CommonResult.success(CommonPage.restPage(bcxDepartmentMemberService.getPage(searchRequest, pageParamRequest)));
    }
}