/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.extra.servlet.ServletUtil;
import com.zbkj.common.utils.CrmebUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil
extends HttpServlet {
    public static HttpServletRequest getRequest() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            return ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        }
        return null;
    }

    public static HashMap<String, Object> getRequestParamAndHeader() {
        try {
            HttpServletRequest request = RequestUtil.getRequest();
            if (request == null) {
                return null;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            HashMap<String, String> requestParams = new HashMap<String, String>();
            Enumeration paraNames = request.getParameterNames();
            if (paraNames != null) {
                Enumeration enumeration = paraNames;
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    requestParams.put(key, request.getParameter(key));
                }
            }
            HashMap<String, Object> requestFilter = new HashMap<String, Object>();
            Enumeration attributeNames = request.getAttributeNames();
            if (attributeNames != null) {
                Enumeration attributeNames1 = attributeNames;
                while (attributeNames1.hasMoreElements()) {
                    String key = (String)attributeNames1.nextElement();
                    if (!key.contains("request_")) continue;
                    requestFilter.put(key, request.getAttribute(key));
                }
            }
            data.put("url", request.getRequestURL());
            data.put("uri", request.getRequestURI());
            data.put("method", request.getMethod());
            data.put("request", requestParams);
            data.put("request_filter", requestFilter);
            Enumeration headerNames = request.getHeaderNames();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (headerNames != null) {
                Enumeration enumeration = headerNames;
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = request.getHeader(key);
                    headerParams.put(key, value);
                }
            }
            data.put("header", headerParams);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDomain() {
        HttpServletRequest request = RequestUtil.getRequest();
        if (request == null) {
            return null;
        }
        return request.getServerName() + ":" + request.getServerPort();
    }

    public static String getUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        List<String> list = CrmebUtil.stringToArrayStrRegex(uri, "/");
        list.removeIf(StringUtils::isNumeric);
        list.removeIf(c -> c.contains(","));
        return StringUtils.join(list, (String)"/");
    }

    public static String getClientIp() {
        return ServletUtil.getClientIP((HttpServletRequest)RequestUtil.getRequest(), null);
    }
}

