package com.zbkj.service.wangshang.api.domain.model.notify;


import com.zbkj.service.wangshang.api.domain.ResponseBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 提现结果通知接口（异步接口）<ant.mybank.bkcloudfunds.withdraw.notify>
 * <p>
 * 提现到绑定清算卡的提现结果将通过此异步接口进行通知。线下联系联调人员单独配置此接口的通知地址。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsWithdrawNotifyModel extends ResponseBody {

    private static final long serialVersionUID = 1175633499979785765L;
    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 提现商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 外部订单分账请求流水号
     * <P>
     * 由合作方生成，同笔交易，交易状态未明需要重试时，使用同一个交易号。
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 网商提现订单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 提现总金额（单位：分）
     */
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 币种
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 平台设置提现手续费用（银行控制盖帽比率），用户实收资金= TotalAmount - PlatformFee
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PlatformFee")
    private String platformFee;

    /**
     * 币种
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "FeeCurrency")
    private String feeCurrency;

    /**
     * 状态，状态(SUCCESS,DEALING ，FAIL)
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 绑定银行卡号
     */
    @XmlElement(name = "BankCardNo")
    private String bankCardNo;

    /**
     * 绑卡卡号户名
     */
    @XmlElement(name = "BankCertName")
    private String bankCertName;

    /**
     * 提现时间
     */
    @XmlElement(name = "WithdrawApplyDate")
    private String withdrawApplyDate;

    /**
     * 提现完成时间
     */
    @XmlElement(name = "WithdrawFinishDate")
    private String withdrawFinishDate;

    /**
     * 提现失败错误描述
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPlatformFee() {
        return platformFee;
    }

    public void setPlatformFee(String platformFee) {
        this.platformFee = platformFee;
    }

    public String getFeeCurrency() {
        return feeCurrency;
    }

    public void setFeeCurrency(String feeCurrency) {
        this.feeCurrency = feeCurrency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBankCardNo() {
        return bankCardNo;
    }

    public void setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
    }

    public String getBankCertName() {
        return bankCertName;
    }

    public void setBankCertName(String bankCertName) {
        this.bankCertName = bankCertName;
    }

    public String getWithdrawApplyDate() {
        return withdrawApplyDate;
    }

    public void setWithdrawApplyDate(String withdrawApplyDate) {
        this.withdrawApplyDate = withdrawApplyDate;
    }

    public String getWithdrawFinishDate() {
        return withdrawFinishDate;
    }

    public void setWithdrawFinishDate(String withdrawFinishDate) {
        this.withdrawFinishDate = withdrawFinishDate;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }
}