package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 商户余额查询接口< ant.mybank.bkcloudfunds.balance.query>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsBalanceQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = 1337810436208114046L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 商户号
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 余额列表 JSON数组&Base64编码
     * <p>
     * 列表中字段含 金额类型accountType［FREEZE,BALANCE］
     * FREEZE-表示当前处于冻结（未分账）的余额。
     * BALANCE-标识当前可用于提现或余额支付的余额。

     * 金额totalAmount单位为分
     * 币种currency（默认为CNY-人民币）。
     * 暂只有FREEZE-冻结余额和BALANCE-可用余额两种类型，不排除后续迭代增加其他余额类型。
     * accountExternalNo为对应类型账户的账户外标
     *
     * 例:
     * W3sidG90YWxBbW91bnQiOjIzNjUxLCJhY2NvdW50VHlwZSI6IkJBTEFOQ0UiLCJhY2NvdW50RXh0ZXJuYWxObyI6Ijk5MDMwOTkwNDc1MDAwNjk2MDAwIiwiY3VycmVuY3kiOiJDTlkifSx7InRvdGFsQW1vdW50IjozOTk0LCJhY2NvdW50VHlwZSI6IkZSRUVaRSIsImFjY291bnRFeHRlcm5hbE5vIjoiOTkwMzE5OTA5NTgwMDAwNTAwMDMiLCJjdXJyZW5jeSI6IkNOWSJ9XQ==
     * [{"totalAmount":23651,"accountType":"BALANCE","accountExternalNo":"99030990475000696000","currency":"CNY"},{"totalAmount":3994,"accountType":"FREEZE","accountExternalNo":"99031990958000050003","currency":"CNY"}]
     */
    @XmlElement(name = "BalanceList")
    private String balanceList;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getBalanceList() {
        return balanceList;
    }

    public void setBalanceList(String balanceList) {
        this.balanceList = balanceList;
    }
}