package com.zbkj.service.huifu.v2;

import java.util.*;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.huifu.bspay.sdk.opps.core.request.V2MerchantBusiBillConfigRequest;
import com.zbkj.service.huifu.constants.HFProfileConstants;
import com.zbkj.service.huifu.core.Identify;

/**
 * 交易结算对账文件配置 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2MerchantBusiBillConfigRequest.class)
public class V2MerchantBusiBillConfig {

    public static V2MerchantBusiBillConfigRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2MerchantBusiBillConfigRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2MerchantBusiBillConfigRequest.class);
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 请求流水号
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 汇付机构编号
        request.setHuifuId(HFProfileConstants.HUIFU_ID);
        // 对账文件生成开关
        request.setReconSendFlag("Y");
        // 对账单类型
        request.setFileType("1,2");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos() {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // SFTP地址
        // extendInfoMap.put("ftp_addr", "");
        // SFTP用户名
        // extendInfoMap.put("ftp_user", "");
        // SFTP密码
        // extendInfoMap.put("ftp_pwd", "");
        // 包含数据范围
         extendInfoMap.put("include_data_range", "U1");
        return extendInfoMap;
    }

}
