/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.WxUtil;
import com.zbkj.common.vo.wxvedioshop.ShopAftersaleAddVo;
import com.zbkj.common.vo.wxvedioshop.ShopAftersaleUpdateVo;
import com.zbkj.common.vo.wxvedioshop.ShopAftersaleVo;
import com.zbkj.common.vo.wxvedioshop.ShopOrderCommonVo;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatVideoAftersaleService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatVideoAftersaleServiceImpl
implements WechatVideoAftersaleService {
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public Boolean shopAftersaleAdd(ShopAftersaleAddVo shopAftersaleAddVo) {
        Map<String, Object> afterAddMap = this.assembleAfterSaleAddMap(shopAftersaleAddVo);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AFTERSALE_ADD_URL, (Object[])new Object[]{miniAccessToken});
        String stringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(afterAddMap));
        JSONObject jsonObject = JSONObject.parseObject((String)stringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }

    private Map<String, Object> assembleAfterSaleAddMap(ShopAftersaleAddVo shopAftersaleAddVo) {
        HashMap map = CollUtil.newHashMap();
        map.put("out_order_id", shopAftersaleAddVo.getOutOrderId());
        map.put("out_aftersale_id", shopAftersaleAddVo.getOutAftersaleId());
        map.put("openid", shopAftersaleAddVo.getOpenid());
        map.put("type", shopAftersaleAddVo.getType());
        map.put("create_time", shopAftersaleAddVo.getCreateTime());
        map.put("status", shopAftersaleAddVo.getStatus());
        map.put("finish_all_aftersale", shopAftersaleAddVo.getFinishAllAftersale());
        map.put("path", shopAftersaleAddVo.getPath());
        List productInfos = shopAftersaleAddVo.getProductInfos();
        List proMap = productInfos.stream().map(e -> {
            HashMap proInfoMap = CollUtil.newHashMap();
            proInfoMap.put("out_product_id", e.getOutProductId());
            proInfoMap.put("out_sku_id", e.getOutSkuId());
            proInfoMap.put("product_cnt", e.getProductCnt());
            return proInfoMap;
        }).collect(Collectors.toList());
        map.put("product_infos", proMap);
        return map;
    }

    @Override
    public ShopAftersaleVo shopAftersaleGet(ShopOrderCommonVo shopOrderCommonVo) {
        if (ObjectUtil.isNull((Object)shopOrderCommonVo.getOrderId()) && StrUtil.isBlank((CharSequence)shopOrderCommonVo.getOutOrderId())) {
            throw new CrmebException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AFTERSALE_GET_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopOrderCommonVo.getOrderId())) {
            map.put("order_id", shopOrderCommonVo.getOrderId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopOrderCommonVo.getOutOrderId())) {
            map.put("out_order_id", shopOrderCommonVo.getOutOrderId());
        }
        map.put("openid", shopOrderCommonVo.getOpenid());
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopAftersaleVo shopAftersaleVo = (ShopAftersaleVo)JSONObject.parseObject((String)jsonObject.getJSONObject("aftersale_infos").toJSONString(), ShopAftersaleVo.class);
        return shopAftersaleVo;
    }

    @Override
    public Boolean shopAftersaleUpdate(ShopAftersaleUpdateVo shopAftersaleUpdateVo) {
        Map<String, Object> afterUpdateMap = this.assembleAfterSaleUpdateMap(shopAftersaleUpdateVo);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AFTERSALE_UPDATE_URL, (Object[])new Object[]{miniAccessToken});
        String stringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(afterUpdateMap));
        JSONObject jsonObject = JSONObject.parseObject((String)stringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return Boolean.TRUE;
    }

    private Map<String, Object> assembleAfterSaleUpdateMap(ShopAftersaleUpdateVo shopAftersaleUpdateVo) {
        HashMap map = CollUtil.newHashMap();
        map.put("out_order_id", shopAftersaleUpdateVo.getOutOrderId());
        map.put("openid", shopAftersaleUpdateVo.getOpenid());
        map.put("out_aftersale_id", shopAftersaleUpdateVo.getOutAftersaleId());
        map.put("status", shopAftersaleUpdateVo.getStatus());
        map.put("finish_all_aftersale", shopAftersaleUpdateVo.getFinishAllAftersale());
        return map;
    }
}

