/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.vo.CloudVo;
import com.zbkj.service.service.OssService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OssServiceImpl
implements OssService {
    private static final Logger logger = LoggerFactory.getLogger(OssServiceImpl.class);

    @Override
    public void upload(CloudVo cloudVo, String webPth, String localFile, File file) {
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb\uff1a" + localFile);
        OSS ossClient = new OSSClientBuilder().build(cloudVo.getRegion(), cloudVo.getAccessKey(), cloudVo.getSecretKey());
        try {
            if (!ossClient.doesBucketExist(cloudVo.getBucketName())) {
                ossClient.createBucket(cloudVo.getBucketName());
            }
            if (!file.exists()) {
                logger.info("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
                return;
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(cloudVo.getBucketName(), webPth, file);
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            logger.info("\u4e0a\u4f20\u6587\u4ef6 -- \u7ed3\u675f\uff1a" + putObjectResult.getETag());
        }
        catch (Exception e) {
            throw new CrmebException(e.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
    }
}

