/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.NotifyConstants;
import com.zbkj.common.constants.SmsConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.sms.SmsTemplate;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SmsApplyTempRequest;
import com.zbkj.common.request.SmsModifySignRequest;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.OnePassLoginVo;
import com.zbkj.common.vo.OnePassSmsTempsListVo;
import com.zbkj.common.vo.OnePassUserInfoVo;
import com.zbkj.common.vo.OnePassUserSmsVo;
import com.zbkj.common.vo.SendSmsVo;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.OnePassSmsService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SmsTemplateService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.util.OnePassUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class OnePassSmsServiceImpl
implements OnePassSmsService,
SmsService {
    private static final Logger logger = LoggerFactory.getLogger(OnePassSmsServiceImpl.class);
    @Autowired
    private OnePassUtil onePassUtil;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private SystemNotificationService systemNotificationService;

    @Override
    public Boolean modifySign(SmsModifySignRequest request) {
        String token = this.getOnePassToken();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"sign", (Object)request.getSign());
        map.add((Object)"phone", (Object)request.getPhone());
        map.add((Object)"verify_code", (Object)request.getCode());
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/sms_v2/modify", (MultiValueMap<String, Object>)map, header);
        return Boolean.TRUE;
    }

    @Override
    public OnePassSmsTempsListVo temps(PageParamRequest pageParamRequest) {
        String token = this.getOnePassToken();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"page", (Object)pageParamRequest.getPage());
        param.add((Object)"limit", (Object)pageParamRequest.getLimit());
        param.add((Object)"temp_type", (Object)0);
        JSONObject post = this.onePassUtil.postFrom("https://sms.crmeb.net/api/sms_v2/temps", (MultiValueMap<String, Object>)param, header);
        JSONObject jsonObject = post.getJSONObject("data");
        logger.warn("\u77ed\u4fe1\u6a21\u677f\u54cd\u5e94JsonObject = {}", (Object)jsonObject);
        return (OnePassSmsTempsListVo)post.getObject("data", OnePassSmsTempsListVo.class);
    }

    @Override
    public Boolean applyTempMessage(SmsApplyTempRequest request) {
        String token = this.getOnePassToken();
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"title", (Object)request.getTitle());
        param.add((Object)"content", (Object)request.getContent());
        param.add((Object)"type", (Object)request.getType());
        this.onePassUtil.postFrom("https://sms.crmeb.net/api/sms_v2/apply", (MultiValueMap<String, Object>)param, header);
        return Boolean.TRUE;
    }

    private void beforeSendMessage() {
        OnePassUserInfoVo userInfoVo = this.onePassService.info();
        OnePassUserSmsVo userSmsVo = userInfoVo.getSms();
        Integer open = userSmsVo.getOpen();
        if (!open.equals(1)) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u8bf7\u5148\u5f00\u901a\u4e00\u53f7\u901a\u8d26\u53f7\u670d\u52a1");
            throw new CrmebException("\u53d1\u9001\u77ed\u4fe1\u8bf7\u5148\u5f00\u901a\u4e00\u53f7\u901a\u8d26\u53f7\u670d\u52a1");
        }
        if (userSmsVo.getNum() <= 0) {
            logger.error("\u4e00\u53f7\u901a\u8d26\u53f7\u670d\u52a1\u4f59\u91cf\u4e0d\u8db3");
            throw new CrmebException("\u4e00\u53f7\u901a\u8d26\u53f7\u670d\u52a1\u4f59\u91cf\u4e0d\u8db3");
        }
    }

    @Override
    public Boolean sendCommonCode(String phone) {
        ValidateFormUtil.isPhone((String)phone, (String)"\u624b\u673a\u53f7\u7801\u9519\u8bef");
        this.beforeSendMessage();
        DateTime dateTime = DateUtil.date();
        String clientIp = RequestUtil.getClientIp();
        this.beforeSendCommonCodeCheck(phone, clientIp, dateTime);
        String codeExpireStr = this.systemConfigService.getValueByKey("sms_code_expire");
        if (StrUtil.isBlank((CharSequence)codeExpireStr) || Integer.parseInt(codeExpireStr) == 0) {
            codeExpireStr = "5";
        }
        Integer code = CrmebUtil.randomCount((Integer)111111, (Integer)999999);
        HashMap<String, Object> justPram = new HashMap<String, Object>();
        justPram.put("code", code);
        justPram.put("time", codeExpireStr);
        Boolean aBoolean = this.push(phone, SmsConstants.SMS_CONFIG_VERIFICATION_CODE_TEMP_ID, justPram);
        if (!aBoolean.booleanValue()) {
            throw new CrmebException("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
        }
        this.redisUtil.set("sms:validate:code:" + phone, (Object)code, Long.valueOf(codeExpireStr), TimeUnit.MINUTES);
        this.redisUtil.set("sms:validate:phone:" + phone, (Object)1, Long.valueOf(60L));
        return aBoolean;
    }

    private void beforeSendCommonCodeCheck(String phone, String clientIp, DateTime dateTime) {
        if (this.redisUtil.exists("sms:validate:phone:" + phone).booleanValue()) {
            throw new CrmebException("\u60a8\u7684\u77ed\u4fe1\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @Override
    public Boolean sendPaySuccess(String phone, String orderNo, BigDecimal payPrice) {
        Integer tempId;
        try {
            this.beforeSendMessage();
            tempId = this.getSmsTempId("paySuccess");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("pay_price", payPrice);
        map.put("order_id", orderNo);
        return this.push(phone, tempId, map);
    }

    @Override
    public Boolean sendMessage(String phone, String message) {
        Integer tempId;
        try {
            this.beforeSendMessage();
            tempId = this.getSmsTempId("message_template_id");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("message", message);
        return this.push(phone, tempId, map);
    }

    @Override
    public Boolean sendOrderDeliverNotice(String phone, String nickName, String storeName, String orderNo) {
        Integer tempId;
        try {
            this.beforeSendMessage();
            tempId = this.getSmsTempId("deliverGoods");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("nickname", nickName);
        map.put("store_name", storeName);
        map.put("order_id", orderNo);
        return this.push(phone, tempId, map);
    }

    @Override
    public Boolean sendMerchantAuditSuccessNotice(String phone, String date, String merName, String merPhone, String pwd, String siteName) {
        Integer tempId;
        try {
            this.beforeSendMessage();
            tempId = this.getSmsTempId("auditSuccess");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("date", date);
        map.put("mer", merName);
        map.put("phone", merPhone);
        map.put("pwd", pwd);
        map.put("site_name", siteName);
        return this.push(phone, tempId, map);
    }

    @Override
    public Boolean sendMerchantFileSuccessNotice(String phone, String date, String merName, String siteName) {
        Integer tempId;
        try {
            this.beforeSendMessage();
            tempId = this.getSmsTempId("auditFail");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("date", date);
        map.put("mer", merName);
        map.put("site", siteName);
        return this.push(phone, tempId, map);
    }

    @Override
    public Boolean sendBirthdayPresent(String phone, String name) {
        Integer tempId;
        try {
            this.beforeSendMessage();
            tempId = this.getSmsTempId("birthdayPresent");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return false;
        }
        HashMap map = CollUtil.newHashMap();
        map.put("name", name);
        return this.push(phone, tempId, map);
    }

    private String getOnePassToken() {
        OnePassLoginVo loginVo = this.onePassService.getLoginVo();
        return this.onePassUtil.getToken(loginVo);
    }

    private Integer getSmsTempId(String mark) {
        SystemNotification notification = this.systemNotificationService.getByMark(mark);
        if (ObjectUtil.isNull((Object)notification)) {
            throw new CrmebException("\u672a\u627e\u5230\u6d88\u606f\u901a\u77e5\u914d\u7f6e");
        }
        if (!notification.getIsSms().equals(NotifyConstants.SWITCH_OPEN)) {
            throw new CrmebException(notification.getDescription() + "\u672a\u914d\u7f6e\u77ed\u4fe1\u76f8\u5173\u6216\u5df2\u5173\u95ed");
        }
        SmsTemplate smsTemplate = this.smsTemplateService.getDetail(notification.getSmsId());
        return Integer.valueOf(smsTemplate.getTempId());
    }

    private Boolean push(String phone, Integer msgTempId, HashMap<String, Object> mapPram) {
        if (StrUtil.isBlank((CharSequence)phone) || msgTempId <= 0) {
            return false;
        }
        OnePassLoginVo loginVo = this.onePassService.getLoginVo();
        SendSmsVo smsVo = new SendSmsVo();
        smsVo.setUid(loginVo.getAccount());
        smsVo.setToken(loginVo.getSecret());
        smsVo.setMobile(phone);
        smsVo.setTemplate(msgTempId);
        smsVo.setParam(JSONObject.toJSONString(mapPram));
        return this.sendMessage(smsVo);
    }

    private Boolean sendMessage(SendSmsVo sendSmsVo) {
        try {
            String token = this.getOnePassToken();
            HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
            JSONObject map = JSONObject.parseObject((String)sendSmsVo.getParam());
            LinkedMultiValueMap param = new LinkedMultiValueMap();
            param.add((Object)"phone", (Object)sendSmsVo.getMobile());
            param.add((Object)"temp_id", (Object)sendSmsVo.getTemplate());
            map.forEach((arg_0, arg_1) -> OnePassSmsServiceImpl.lambda$sendMessage$0((MultiValueMap)param, arg_0, arg_1));
            String result = this.restTemplateUtil.postFromUrlencoded("https://sms.crmeb.net/api/sms_v2/send", (MultiValueMap)param, header);
            this.checkResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25,{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private JSONObject checkResult(String result) {
        JSONObject jsonObject;
        if (StrUtil.isBlank((CharSequence)result)) {
            throw new CrmebException("\u77ed\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        try {
            jsonObject = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            throw new CrmebException("\u77ed\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        if (SmsConstants.SMS_ERROR_CODE.equals(jsonObject.getInteger("status"))) {
            throw new CrmebException("\u77ed\u4fe1\u5e73\u53f0\u63a5\u53e3" + jsonObject.getString("msg"));
        }
        return jsonObject;
    }

    private static /* synthetic */ void lambda$sendMessage$0(MultiValueMap param, String key, Object value) {
        param.add((Object)StrUtil.format((CharSequence)"param[{}]", (Object[])new Object[]{key}), value);
    }
}

