/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.dto.BrokerageConfigSnapshotDto;
import com.zbkj.common.enums.BcxBrokerageConfigBelongTypeEnum;
import com.zbkj.common.enums.BcxPerformanceReportBelongTypeEnum;
import com.zbkj.common.enums.BcxReportSettleStatusEnum;
import com.zbkj.common.enums.BrokerageConfigTypeEnum;
import com.zbkj.common.enums.BrokerageOrderTypeEnum;
import com.zbkj.common.enums.ChangeTypeEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxDepartment;
import com.zbkj.common.model.bcx.BcxDepartmentMember;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.model.bcx.BcxProductBenefits;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.order.RefundOrderInfo;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxBrokerageConfigSearchRequest;
import com.zbkj.common.request.BcxPerformanceReportSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxBrokerageConfigResponse;
import com.zbkj.common.response.BcxBrokerageStatisticsResponse;
import com.zbkj.common.response.BcxPerformanceReportResponse;
import com.zbkj.common.response.BcxPerformanceReportStatisticsResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.IdGeneratorSnowflake;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.BcxPerformanceReportDao;
import com.zbkj.service.service.BcxBrokerageConfigService;
import com.zbkj.service.service.BcxDepartmentMemberServeService;
import com.zbkj.service.service.BcxDepartmentMemberService;
import com.zbkj.service.service.BcxDepartmentService;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BcxProductBenefitsService;
import com.zbkj.service.service.BcxSettleService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RefundOrderInfoService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxPayOfflineService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxPerformanceReportServiceImpl
extends ServiceImpl<BcxPerformanceReportDao, BcxPerformanceReport>
implements BcxPerformanceReportService {
    private static final Logger log = LoggerFactory.getLogger(BcxPerformanceReportServiceImpl.class);
    @Resource
    private BcxPerformanceReportDao dao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private RefundOrderInfoService refundOrderInfoService;
    @Autowired
    private ProductService productService;
    @Autowired
    private UserService userService;
    @Autowired
    private BcxBrokerageConfigService bcxBrokerageConfigService;
    @Autowired
    private BcxDepartmentService bcxDepartmentService;
    @Autowired
    private BcxDepartmentMemberService bcxDepartmentMemberService;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private BcxDepartmentMemberServeService bcxDepartmentMemberServeService;
    @Autowired
    private BcxProductBenefitsService bcxProductBenefitsService;
    @Autowired
    private BcxSettleService bcxSettleService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Resource
    private BcxPayOfflineService bcxPayOfflineService;

    @Override
    @Async
    @Transactional
    public void frozenByOrder(String orderNo) {
        log.info("==================\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u51bb\u7ed3\u4e2d==================");
        log.info("\u53c2\u6570orderNo\uff1a{}", (Object)orderNo);
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            String lockKey = "FROZEN_BY_ORDER_" + orderNo;
            log.info("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u51bb\u7ed3\u4e2d\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
            RLock lock = this.redissonClient.getLock(lockKey);
            lock.lock(30L, TimeUnit.SECONDS);
            log.info("\u53d6\u5230\u9501");
            try {
                LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
                lqw.eq(BcxPerformanceReport::getOrderNo, (Object)orderNo);
                List reportList = this.dao.selectList((Wrapper)lqw);
                if (CollectionUtil.isNotEmpty((Collection)reportList)) {
                    ArrayList<BcxPerformanceReport> updateList = new ArrayList<BcxPerformanceReport>();
                    Date now = new Date();
                    Date unFreezeTime = this.getUnFreezeTime(now);
                    for (BcxPerformanceReport report : reportList) {
                        if (report.getSettleStatus().intValue() == BcxReportSettleStatusEnum.WAIT_EFFECTIVE.getValue().intValue()) {
                            if (report.getSeparateAccountStatus() != null && report.getSeparateAccountStatus() == 1) {
                                report.setSettleStatus(BcxReportSettleStatusEnum.WAIT_SETTLED.getValue());
                                report.setUnFreezeTime(now);
                                this.bcxSettleService.unFrozenReportWithPurse(report);
                            } else {
                                report.setSettleStatus(BcxReportSettleStatusEnum.FROZEN.getValue());
                                report.setUnFreezeTime(unFreezeTime);
                            }
                            report.setUpdateTime(now);
                            updateList.add(report);
                        }
                        if (report.getBelongType().intValue() != BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue().intValue() && report.getBelongType().intValue() != BcxPerformanceReportBelongTypeEnum.USER_FXY.getValue().intValue()) continue;
                        this.userBrokerageRecordService.updateStatusByOrderNo(report.getBelongId().intValue(), report.getOrderNo(), BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_FROZEN);
                    }
                    if (CollectionUtil.isNotEmpty(updateList)) {
                        this.updateBatchById(updateList);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u51bb\u7ed3\u4e2d\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u51bb\u7ed3\u4e2d\u5f02\u5e38:" + e.getMessage()));
            }
            finally {
                if (lock.isLocked()) {
                    lock.unlock();
                }
                log.info("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u51bb\u7ed3\u4e2d\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
            }
        }
        log.info("==================\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u51bb\u7ed3\u4e2d\u5b8c\u6210==================");
    }

    @Override
    @Transactional
    public void waitSettledByFrozen() {
        log.info("==================\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u5f85\u7ed3\u7b97==================");
        String lockKey = "WAIT_SETTLED_BY_FROZEN";
        log.info("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u5f85\u7ed3\u7b97\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(30L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            Date now = new Date();
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(BcxPerformanceReport::getSettleStatus, (Object)BcxReportSettleStatusEnum.FROZEN.getValue());
            lqw.le(BcxPerformanceReport::getUnFreezeTime, (Object)now);
            List reportList = this.dao.selectList((Wrapper)lqw);
            if (CollectionUtil.isNotEmpty((Collection)reportList)) {
                ArrayList<BcxPerformanceReport> updateList = new ArrayList<BcxPerformanceReport>();
                for (BcxPerformanceReport report : reportList) {
                    report.setSettleStatus(BcxReportSettleStatusEnum.WAIT_SETTLED.getValue());
                    report.setUpdateTime(now);
                    updateList.add(report);
                    if (report.getBelongType().intValue() != BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue().intValue() && report.getBelongType().intValue() != BcxPerformanceReportBelongTypeEnum.USER_FXY.getValue().intValue()) continue;
                    this.userBrokerageRecordService.updateStatusByOrderNo(report.getBelongId().intValue(), report.getOrderNo(), BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
                }
                if (CollectionUtil.isNotEmpty(updateList)) {
                    this.updateBatchById(updateList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u5f85\u7ed3\u7b97\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u5f85\u7ed3\u7b97\u5f02\u5e38:" + e.getMessage()));
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u5f85\u7ed3\u7b97\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
        log.info("==================\u4e1a\u7ee9\u62a5\u8868\u6539\u4e3a\u5f85\u7ed3\u7b97\u5b8c\u6210==================");
    }

    @Override
    @Transactional
    public void generateReport(String orderNo) {
        block52: {
            log.info("==================\u751f\u6210\u4e1a\u7ee9\u62a5\u8868==================");
            log.info("\u53c2\u6570orderNo\uff1a{}", (Object)orderNo);
            String lockKey = "GENERATE_REPORT_" + orderNo;
            log.info("\u751f\u6210\u4e1a\u7ee9\u62a5\u8868\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
            RLock lock = this.redissonClient.getLock(lockKey);
            lock.lock(30L, TimeUnit.SECONDS);
            log.info("\u53d6\u5230\u9501");
            try {
                String regionCode;
                List<OrderDetail> orderDetailList;
                Order order = this.orderService.getByOrderNo(orderNo);
                if (order == null || !CollectionUtil.isNotEmpty(orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo()))) break block52;
                log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u8ba2\u5355\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)orderNo, (Object)orderDetailList.size());
                Date now = new Date();
                Date unFreezeTime = null;
                if (order.getStatus().intValue() == OrderConstants.ORDER_STATUS_COMPLETE.intValue()) {
                    unFreezeTime = this.getUnFreezeTime(now);
                }
                if (StringUtils.isNotBlank((CharSequence)(regionCode = order.getRegionCode()))) {
                    log.info("\u8ba2\u5355\u53f7\u533a\u57df\uff1a{}", (Object)regionCode);
                    ArrayList<BcxPerformanceReport> reportList = new ArrayList<BcxPerformanceReport>();
                    for (OrderDetail orderDetail : orderDetailList) {
                        List<ProductAttrValue> skuList;
                        Integer productId = orderDetail.getProductId();
                        Product product = (Product)this.productService.getById(productId);
                        if (product.getIsBrokerage() != 1 || orderDetail.getBrokerageStatus() != 0) continue;
                        Integer fxyRatio = Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_first_ratio"));
                        Integer fxsRatio = Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_second_ratio"));
                        if (product.getIsSub().booleanValue() && CollectionUtil.isNotEmpty(skuList = this.productAttrValueService.getListByProductIdAndType(productId, 0))) {
                            fxyRatio = skuList.get(0).getBrokerage();
                            fxsRatio = skuList.get(0).getBrokerageTwo();
                        }
                        log.info("\u5546\u54c1id\uff1a{}\uff0c\u5546\u54c1\u540d\u79f0\uff1a{}\u6709\u5f00\u542f\u5206\u9500\uff0c\u662f\u5426\u5355\u72ec\u8ba1\u7b97\u5206\u4f63\uff1a{}\uff0c\u4e00\u7ea7\u6bd4\u4f8b\uff1a{}\uff0c \u4e8c\u7ea7\u6bd4\u4f8b\uff1a{}", new Object[]{product.getId(), product.getName(), product.getIsSub() != false ? "\u662f" : "\u5426", fxyRatio, fxsRatio});
                        Integer brokerageTotal = fxyRatio + fxsRatio;
                        User first = null;
                        User second = null;
                        User buyer = (User)this.userService.getById(orderDetail.getUid());
                        if (orderDetail.getUid() != null && orderDetail.getUid() != 0 && buyer.getSpreadUid() != null && buyer.getSpreadUid() != 0 && (first = (User)this.userService.getById(buyer.getSpreadUid())).getSpreadUid() != null && first.getSpreadUid() != 0) {
                            second = (User)this.userService.getById(first.getSpreadUid());
                        }
                        String companyId = null;
                        if (first != null && first.getUserType() == 1) {
                            log.info("\u4e00\u7ea7\u5206\u9500\u5458\u662f\u4f01\u4e1a\u8d26\u53f7\uff0ccompanyId\u5c31\u662f\u672c\u8eab");
                            companyId = first.getAccount();
                        } else if (second != null && second.getUserType() == 1) {
                            log.info("\u4e8c\u7ea7\u5206\u9500\u5458\u662f\u4f01\u4e1a\u8d26\u53f7\uff0ccompanyId\u5c31\u662f\u4e0a\u7ea7");
                            companyId = second.getAccount();
                        }
                        boolean isCalcBrokerage = false;
                        if (StringUtils.isNotBlank(companyId)) {
                            List<BcxProductBenefits> productBenefitsList = this.bcxProductBenefitsService.findListByCompanyId(companyId);
                            if (CollectionUtil.isNotEmpty(productBenefitsList)) {
                                for (BcxProductBenefits bcxProductBenefits : productBenefitsList) {
                                    log.info("\u516c\u53f8id\uff1a{}\uff0c\u6388\u6743\u5546\u54c1id\uff1a{}\uff0c\u6388\u6743\u5546\u54c1id\uff1a{}", new Object[]{companyId, bcxProductBenefits.getProductId(), bcxProductBenefits.getProductName()});
                                    if (bcxProductBenefits.getProductId().intValue() != product.getId().intValue()) continue;
                                    isCalcBrokerage = true;
                                    if (bcxProductBenefits.getIsEnableConfig() == 1) {
                                        fxyRatio = bcxProductBenefits.getBrokerage();
                                        fxsRatio = brokerageTotal - fxyRatio;
                                    }
                                    break;
                                }
                            } else {
                                log.info("\u516c\u53f8id\uff1a{}\uff0c\u6ca1\u6709\u6388\u6743\u5206\u9500\u5546\u54c1", (Object)companyId);
                            }
                            log.info("\u662f\u5426\u53ef\u4ee5\u8ba1\u7b97\u4e00\u7ea7\u4e8c\u7ea7\u5206\u9500\uff1a{}", (Object)isCalcBrokerage);
                        } else {
                            log.info("\u5206\u9500\u5458\u6240\u5c5e\u516c\u53f8id\u4e3a\u7a7a\uff0c\u4e0d\u8ba1\u7b97\u4e00\u7ea7\u4e8c\u7ea7\u4f63\u91d1");
                        }
                        BigDecimal maxBrokeragePrice = product.getMaxBrokerage() == null ? orderDetail.getCanBrokeragePrice() : orderDetail.getCanBrokeragePrice().multiply(product.getMaxBrokerage()).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
                        log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5546\u54c1\uff1a{}\uff0c\u6700\u591a\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", new Object[]{orderNo, product.getName(), maxBrokeragePrice.toPlainString()});
                        log.info("\u8d2d\u4e70\u8005id\uff1a{}\uff0c\u4e00\u7ea7\u5206\u9500\u5458\uff1a{}\uff0c\u4e8c\u7ea7\u5206\u9500\u5458\uff1a{}", new Object[]{orderDetail.getUid(), first == null ? "" : first.getRealName(), second == null ? "" : second.getRealName()});
                        Integer searchProductId = product.getIsSub() != false ? productId : null;
                        List<BcxBrokerageConfigResponse> channelConfigList = this.bcxBrokerageConfigService.getList(new BcxBrokerageConfigSearchRequest(searchProductId, BcxBrokerageConfigBelongTypeEnum.CHANNEL.getValue(), regionCode));
                        List<BcxBrokerageConfigResponse> businessChannelConfigList = channelConfigList.stream().filter(config -> config.getChannelType() != null && config.getChannelType().intValue() == ChangeTypeEnum.BUSINESS.getValue().intValue()).collect(Collectors.toList());
                        List<BcxBrokerageConfigResponse> regionChannelConfigList = channelConfigList.stream().filter(config -> config.getChannelType() != null && config.getChannelType().intValue() == ChangeTypeEnum.REGION.getValue().intValue()).collect(Collectors.toList());
                        List<BcxBrokerageConfigResponse> departmentConfigList = this.bcxBrokerageConfigService.getList(new BcxBrokerageConfigSearchRequest(searchProductId, BcxBrokerageConfigBelongTypeEnum.DEPARTMENT.getValue(), regionCode));
                        List<BcxBrokerageConfigResponse> departmentMemberConfigList = this.bcxBrokerageConfigService.getList(new BcxBrokerageConfigSearchRequest(searchProductId, BcxBrokerageConfigBelongTypeEnum.DEPARTMENT_MEMBER.getValue(), regionCode));
                        int brokerageOrderType = this.getBrokerageOrderType(first, second, businessChannelConfigList, regionChannelConfigList, departmentMemberConfigList);
                        if (brokerageOrderType == BrokerageOrderTypeEnum.NOTHING.getValue()) {
                            log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5206\u9500\u8ba2\u5355\u7c7b\u578b\u4e3a\uff1a\u65e0\u5206\u9500\uff1a\u533a\u57df\u6e20\u9053\uff08\u6ee1\u7684\uff09\u3001\u90e8\u95e8\uff0c\u5206\u4f63", (Object)orderNo);
                        } else if (brokerageOrderType == BrokerageOrderTypeEnum.NORMAL.getValue()) {
                            log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5206\u9500\u8ba2\u5355\u7c7b\u578b\u4e3a\uff1a\u666e\u901a\u5206\u9500\uff0c\u5206\u9500\u5546\uff08\u4e00\u7ea7\u3001\u4e8c\u7ea7\uff09\u3001\u533a\u57df\u6e20\u9053\uff08\u6253\u6298\uff09\u3001\u90e8\u95e8\uff0c\u5206\u4f63", (Object)orderNo);
                        } else if (brokerageOrderType == BrokerageOrderTypeEnum.BUSINESS_CHANNEL.getValue()) {
                            log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5206\u9500\u8ba2\u5355\u7c7b\u578b\u4e3a\uff1a\u4e1a\u52a1\u6e20\u9053\u5206\u9500\uff0c\u4e1a\u52a1\u6e20\u9053\u3001\u533a\u57df\u6e20\u9053\uff08\u6253\u6298\uff09\u3001\u90e8\u95e8\uff0c\u5206\u4f63", (Object)orderNo);
                        } else if (brokerageOrderType == BrokerageOrderTypeEnum.REGION_CHANNEL.getValue()) {
                            log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5206\u9500\u8ba2\u5355\u7c7b\u578b\u4e3a\uff1a\u533a\u57df\u6e20\u9053\u5206\u9500\uff0c\u533a\u57df\u6e20\u9053\uff08\u6ee1\u7684\uff09\u3001\u90e8\u95e8\uff0c\u5206\u4f63", (Object)orderNo);
                        } else if (brokerageOrderType == BrokerageOrderTypeEnum.DEPARTMENT_MEMBER.getValue()) {
                            log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5206\u9500\u8ba2\u5355\u7c7b\u578b\u4e3a\uff1a\u90e8\u95e8\u6210\u5458\u5206\u9500\uff0c\u533a\u57df\u6e20\u9053\uff08\u6ee1\u7684\uff09\u3001\u90e8\u95e8\u3001\u90e8\u95e8\u6210\u5458\uff0c\u5206\u4f63", (Object)orderNo);
                        }
                        BigDecimal brokeragePriceTotal = new BigDecimal(0);
                        BrokerageConfigSnapshotDto brokerageConfigSnapshotDto = new BrokerageConfigSnapshotDto(order, orderDetail, product);
                        if (isCalcBrokerage && brokerageOrderType == BrokerageOrderTypeEnum.NORMAL.getValue() && maxBrokeragePrice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal fxyRatioBigDecimal = new BigDecimal(fxyRatio);
                            BigDecimal firstBrokerageFee = orderDetail.getCanBrokeragePrice().multiply(fxyRatioBigDecimal).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
                            brokeragePriceTotal = brokeragePriceTotal.add(firstBrokerageFee);
                            log.info("\u4e00\u7ea7\u5206\u9500\u5458\u5206\u4f63\uff1a{}", (Object)firstBrokerageFee.toPlainString());
                            if (firstBrokerageFee.compareTo(BigDecimal.ZERO) > 0) {
                                BcxPerformanceReport bcxPerformanceReport = this.createReport(first.getId().longValue(), BcxPerformanceReportBelongTypeEnum.USER_FXY, order, orderDetail, product.getIsSub(), JSONObject.toJSONString((Object)brokerageConfigSnapshotDto), BrokerageConfigTypeEnum.RATIO.getValue(), fxyRatioBigDecimal, new BigDecimal(100), firstBrokerageFee, now, unFreezeTime, false);
                                maxBrokeragePrice = maxBrokeragePrice.subtract(bcxPerformanceReport.getBrokeragePrice());
                                log.info("\u8ba1\u7b97\u51fa\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)bcxPerformanceReport.getBrokeragePrice().toPlainString());
                                log.info("\u5f53\u524d\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)maxBrokeragePrice.toPlainString());
                                if (maxBrokeragePrice.compareTo(BigDecimal.ZERO) < 0) {
                                    bcxPerformanceReport.setBrokeragePrice(maxBrokeragePrice.add(bcxPerformanceReport.getBrokeragePrice()));
                                    log.info("\u8ba1\u7b97\u51fa\u53ef\u5206\u4f63\u91d1\u989d > \u5f53\u524d\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff0c\u91cd\u7f6e\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)bcxPerformanceReport.getBrokeragePrice().toPlainString());
                                }
                                reportList.add(bcxPerformanceReport);
                                log.info("\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)maxBrokeragePrice.toPlainString());
                            }
                        }
                        if (isCalcBrokerage && brokerageOrderType == BrokerageOrderTypeEnum.NORMAL.getValue() && second != null && maxBrokeragePrice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal fxsRatioBigDecimal = new BigDecimal(fxsRatio);
                            BigDecimal secondBrokerageFee = orderDetail.getCanBrokeragePrice().multiply(fxsRatioBigDecimal).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
                            brokeragePriceTotal = brokeragePriceTotal.add(secondBrokerageFee);
                            log.info("\u4e8c\u7ea7\u5206\u9500\u5458\u5206\u4f63\uff1a{}", (Object)secondBrokerageFee.toPlainString());
                            if (secondBrokerageFee.compareTo(BigDecimal.ZERO) > 0) {
                                BcxPerformanceReport bcxPerformanceReport = this.createReport(second.getId().longValue(), BcxPerformanceReportBelongTypeEnum.USER_FXS, order, orderDetail, product.getIsSub(), JSONObject.toJSONString((Object)brokerageConfigSnapshotDto), BrokerageConfigTypeEnum.RATIO.getValue(), fxsRatioBigDecimal, new BigDecimal(100), secondBrokerageFee, now, unFreezeTime, false);
                                bcxPerformanceReport.setBrokeragePriceTotal(brokeragePriceTotal);
                                maxBrokeragePrice = maxBrokeragePrice.subtract(bcxPerformanceReport.getBrokeragePrice());
                                log.info("\u8ba1\u7b97\u51fa\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)bcxPerformanceReport.getBrokeragePrice().toPlainString());
                                log.info("\u5f53\u524d\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)maxBrokeragePrice.toPlainString());
                                if (maxBrokeragePrice.compareTo(BigDecimal.ZERO) < 0) {
                                    bcxPerformanceReport.setBrokeragePrice(maxBrokeragePrice.add(bcxPerformanceReport.getBrokeragePrice()));
                                    log.info("\u8ba1\u7b97\u51fa\u53ef\u5206\u4f63\u91d1\u989d > \u5f53\u524d\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff0c\u91cd\u7f6e\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)bcxPerformanceReport.getBrokeragePrice().toPlainString());
                                }
                                reportList.add(bcxPerformanceReport);
                                log.info("\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)maxBrokeragePrice.toPlainString());
                            }
                        }
                        brokerageConfigSnapshotDto.setMaxBrokeragePrice(maxBrokeragePrice);
                        if (brokerageOrderType == BrokerageOrderTypeEnum.BUSINESS_CHANNEL.getValue() && CollectionUtil.isNotEmpty(businessChannelConfigList)) {
                            BcxBrokerageConfigResponse configResponse = null;
                            for (BcxBrokerageConfigResponse bcxBrokerageConfigResponse : businessChannelConfigList) {
                                if (first != null && bcxBrokerageConfigResponse.getBelongId().longValue() == first.getId().longValue()) {
                                    configResponse = bcxBrokerageConfigResponse;
                                    break;
                                }
                                if (second == null || bcxBrokerageConfigResponse.getBelongId().longValue() != second.getId().longValue()) continue;
                                configResponse = bcxBrokerageConfigResponse;
                                break;
                            }
                            if (configResponse != null) {
                                reportList.addAll(this.createReport(Collections.singletonList(configResponse), BcxPerformanceReportBelongTypeEnum.CHANNEL, order, orderDetail, product.getIsSub(), false, brokerageConfigSnapshotDto, now, unFreezeTime, false));
                            }
                        }
                        if (CollectionUtil.isNotEmpty(regionChannelConfigList)) {
                            boolean isDiscount = brokerageOrderType == BrokerageOrderTypeEnum.NORMAL.getValue() || brokerageOrderType == BrokerageOrderTypeEnum.BUSINESS_CHANNEL.getValue();
                            List<BcxPerformanceReport> changeReportList = this.createReport(regionChannelConfigList, BcxPerformanceReportBelongTypeEnum.CHANNEL, order, orderDetail, product.getIsSub(), isDiscount, brokerageConfigSnapshotDto, now, unFreezeTime, false);
                            if (CollectionUtil.isNotEmpty((Collection)changeReportList) && order.getBizType().intValue() == ProductConstants.BIZ_TYPE_RISK.intValue()) {
                                for (BcxPerformanceReport report2 : changeReportList) {
                                    BcxPayOffline offline = this.bcxPayOfflineService.queryByOrderNo(order.getOrderNo());
                                    if (offline.getStatus() != 3 || !this.bcxSettleService.settleReportWithPurse(report2)) continue;
                                    report2.setSeparateAccountStatus(Integer.valueOf(1));
                                }
                            }
                            reportList.addAll(changeReportList);
                        }
                        if (CollectionUtil.isNotEmpty(departmentConfigList)) {
                            reportList.addAll(this.createReport(departmentConfigList, BcxPerformanceReportBelongTypeEnum.DEPARTMENT, order, orderDetail, product.getIsSub(), false, brokerageConfigSnapshotDto, now, unFreezeTime, false));
                        }
                        if (CollectionUtil.isNotEmpty(departmentMemberConfigList)) {
                            ArrayList<String> orgIdList = new ArrayList<String>();
                            if (buyer != null && buyer.getAccount().startsWith("org_")) {
                                orgIdList.add(buyer.getAccount().substring(4));
                            }
                            if (first != null && first.getAccount().startsWith("org_")) {
                                orgIdList.add(first.getAccount().substring(4));
                            }
                            if (second != null && second.getAccount().startsWith("org_")) {
                                orgIdList.add(second.getAccount().substring(4));
                            }
                            for (BcxBrokerageConfigResponse bcxBrokerageConfigResponse : departmentMemberConfigList) {
                                if (!this.bcxDepartmentMemberServeService.isDepartmentMemberServe(bcxBrokerageConfigResponse.getBcxId(), orgIdList) || bcxBrokerageConfigResponse.getServiceRatio() == null || bcxBrokerageConfigResponse.getServiceRatio().compareTo(BigDecimal.ZERO) <= 0) continue;
                                reportList.addAll(this.createReport(Collections.singletonList(bcxBrokerageConfigResponse), BcxPerformanceReportBelongTypeEnum.DEPARTMENT_MEMBER, order, orderDetail, product.getIsSub(), false, brokerageConfigSnapshotDto, now, unFreezeTime, true));
                            }
                        }
                        if (brokerageOrderType == BrokerageOrderTypeEnum.DEPARTMENT_MEMBER.getValue() && CollectionUtil.isNotEmpty(departmentMemberConfigList)) {
                            BcxPerformanceReport report2;
                            Long memberId = -1L;
                            List departmentMemberIdList = departmentMemberConfigList.stream().map(BcxBrokerageConfigResponse::getBelongId).collect(Collectors.toList());
                            List list = this.bcxDepartmentMemberService.listByIds(departmentMemberIdList);
                            report2 = list.iterator();
                            while (report2.hasNext()) {
                                BcxDepartmentMember departmentMember = (BcxDepartmentMember)report2.next();
                                String account = "emp_" + departmentMember.getBcxId();
                                if (first == null || !account.equals(first.getAccount())) continue;
                                memberId = departmentMember.getId();
                                break;
                            }
                            Long finalMemberId = memberId;
                            Optional<BcxBrokerageConfigResponse> configResponseOptional = departmentMemberConfigList.stream().filter(config -> config.getBelongId().longValue() == finalMemberId.longValue()).findFirst();
                            if (configResponseOptional.isPresent()) {
                                reportList.addAll(this.createReport(Collections.singletonList(configResponseOptional.get()), BcxPerformanceReportBelongTypeEnum.DEPARTMENT_MEMBER, order, orderDetail, product.getIsSub(), false, brokerageConfigSnapshotDto, now, unFreezeTime, false));
                            }
                        }
                        orderDetail.setBrokerageStatus(Integer.valueOf(1));
                        this.orderDetailService.updateById(orderDetail);
                    }
                    log.info("\u4fdd\u5b58\u5165\u5e93");
                    if (CollectionUtil.isNotEmpty(reportList)) {
                        log.info("\u4fdd\u5b58\u5165\u5e93\u6570\u91cf\uff1a{}", (Object)reportList.size());
                        this.saveBatch(reportList);
                    }
                    break block52;
                }
                log.info("\u8ba2\u5355\u53f7\uff1a{}\uff0c\u533a\u57df\u4e3a\u7a7a\uff0c\u4e0d\u7eb3\u5165\u8ba1\u7b97\u5206\u9500", (Object)orderNo);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u751f\u6210\u4e1a\u7ee9\u62a5\u8868\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u751f\u6210\u4e1a\u7ee9\u62a5\u8868\u5f02\u5e38:" + e.getMessage()));
            }
            finally {
                if (lock.isLocked()) {
                    lock.unlock();
                }
                log.info("\u751f\u6210\u4e1a\u7ee9\u62a5\u8868\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
            }
        }
        log.info("==================\u751f\u6210\u4e1a\u7ee9\u62a5\u8868\u5b8c\u6210==================");
    }

    private int getBrokerageOrderType(User first, User second, List<BcxBrokerageConfigResponse> businessChannelConfigList, List<BcxBrokerageConfigResponse> regionChannelConfigList, List<BcxBrokerageConfigResponse> departmentMemberConfigList) {
        List<Long> businessChannelIdList = CollectionUtil.isEmpty(businessChannelConfigList) ? Collections.singletonList(-1L) : businessChannelConfigList.stream().map(BcxBrokerageConfigResponse::getBelongId).collect(Collectors.toList());
        List<Long> regionChannelIdList = CollectionUtil.isEmpty(regionChannelConfigList) ? Collections.singletonList(-1L) : regionChannelConfigList.stream().map(BcxBrokerageConfigResponse::getBelongId).collect(Collectors.toList());
        List<Long> departmentMemberIdList = CollectionUtil.isEmpty(departmentMemberConfigList) ? Collections.singletonList(-1L) : departmentMemberConfigList.stream().map(BcxBrokerageConfigResponse::getBelongId).collect(Collectors.toList());
        List departmentMemberList = this.bcxDepartmentMemberService.listByIds(departmentMemberIdList);
        List<String> departmentMemberBcxIdList = CollectionUtil.isEmpty((Collection)departmentMemberList) ? Collections.singletonList("-1") : departmentMemberList.stream().map(member -> "emp_" + member.getBcxId()).collect(Collectors.toList());
        log.info("\u4e1a\u52a1\u6e20\u9053id\u5217\u8868\uff1a{}", businessChannelIdList);
        log.info("\u533a\u57df\u6e20\u9053id\u5217\u8868\uff1a{}", regionChannelIdList);
        log.info("\u90e8\u95e8\u6210\u5458account\u5217\u8868\uff0cbrokerageOrderType\uff1a{}", departmentMemberBcxIdList);
        int brokerageOrderType = BrokerageOrderTypeEnum.NOTHING.getValue();
        if (!(first == null && second == null || first != null && (businessChannelIdList.contains(first.getId().longValue()) || regionChannelIdList.contains(first.getId().longValue()) || departmentMemberBcxIdList.contains(first.getAccount())) || second != null && (businessChannelIdList.contains(second.getId().longValue()) || regionChannelIdList.contains(second.getId().longValue()) || departmentMemberBcxIdList.contains(second.getAccount())))) {
            log.info("\u4e00\u7ea7\u3001\u4e8c\u7ea7\uff0c\u90fd\u4e0d\u5728\uff1a\u4e1a\u52a1\u6e20\u9053\u3001\u533a\u57df\u6e20\u9053\u3001\u90e8\u95e8\u6210\u5458  \u91cc\u9762\uff0c\u5219\u662f\uff1a\u666e\u901a\u5206\u9500\uff0cbrokerageOrderType\uff1a{}", (Object)brokerageOrderType);
            brokerageOrderType = BrokerageOrderTypeEnum.NORMAL.getValue();
        } else {
            if (first != null) {
                if (businessChannelIdList.contains(first.getId().longValue())) {
                    log.info("\u4e00\u7ea7\uff0c\u5728\uff1a\u4e1a\u52a1\u6e20\u9053  \u91cc\u9762\uff0c\u5219\u662f\uff1a\u4e1a\u52a1\u6e20\u9053\u5206\u9500\uff0cbrokerageOrderType\uff1a{}", (Object)brokerageOrderType);
                    brokerageOrderType = BrokerageOrderTypeEnum.BUSINESS_CHANNEL.getValue();
                } else if (regionChannelIdList.contains(first.getId().longValue())) {
                    log.info("\u4e00\u7ea7\uff0c\u5728\uff1a\u533a\u57df\u6e20\u9053  \u91cc\u9762\uff0c\u5219\u662f\uff1a\u533a\u57df\u6e20\u9053\u5206\u9500\uff0cbrokerageOrderType\uff1a{}", (Object)brokerageOrderType);
                    brokerageOrderType = BrokerageOrderTypeEnum.REGION_CHANNEL.getValue();
                } else if (departmentMemberBcxIdList.contains(first.getAccount())) {
                    log.info("\u4e00\u7ea7\uff0c\u5728\uff1a\u90e8\u95e8\u6210\u5458  \u91cc\u9762\uff0c\u5219\u662f\uff1a\u90e8\u95e8\u6210\u5458\u5206\u9500\uff0cbrokerageOrderType\uff1a{}", (Object)brokerageOrderType);
                    brokerageOrderType = BrokerageOrderTypeEnum.DEPARTMENT_MEMBER.getValue();
                }
            }
            if (second != null && brokerageOrderType == 0) {
                if (businessChannelIdList.contains(second.getId().longValue())) {
                    log.info("\u4e8c\u7ea7\uff0c\u5728\uff1a\u4e1a\u52a1\u6e20\u9053  \u91cc\u9762\uff0c\u5219\u662f\uff1a\u4e1a\u52a1\u6e20\u9053\u5206\u9500\uff0cbrokerageOrderType\uff1a{}", (Object)brokerageOrderType);
                    brokerageOrderType = BrokerageOrderTypeEnum.BUSINESS_CHANNEL.getValue();
                } else if (regionChannelIdList.contains(second.getId().longValue())) {
                    log.info("\u4e8c\u7ea7\uff0c\u5728\uff1a\u533a\u57df\u6e20\u9053  \u91cc\u9762\uff0c\u5219\u662f\uff1a\u533a\u57df\u6e20\u9053\u5206\u9500\uff0cbrokerageOrderType\uff1a{}", (Object)brokerageOrderType);
                    brokerageOrderType = BrokerageOrderTypeEnum.REGION_CHANNEL.getValue();
                }
            }
        }
        return brokerageOrderType;
    }

    private List<BcxPerformanceReport> createReport(List<BcxBrokerageConfigResponse> configList, BcxPerformanceReportBelongTypeEnum belongTypeEnum, Order order, OrderDetail orderDetail, boolean isSub, boolean isDiscount, BrokerageConfigSnapshotDto brokerageConfigSnapshotDto, Date now, Date unFreezeTime, boolean isServe) {
        ArrayList<BcxPerformanceReport> list = new ArrayList<BcxPerformanceReport>();
        BigDecimal maxBrokeragePrice = brokerageConfigSnapshotDto.getMaxBrokeragePrice();
        for (BcxBrokerageConfigResponse configResponse : configList) {
            BigDecimal price;
            if (maxBrokeragePrice.compareTo(BigDecimal.ZERO) <= 0) continue;
            brokerageConfigSnapshotDto.setBcxBrokerageConfig(configResponse);
            BigDecimal brokeragePrice = BigDecimal.ZERO;
            BigDecimal ratio = isServe ? configResponse.getServiceRatio() : configResponse.getRatio();
            BigDecimal payNum = new BigDecimal(orderDetail.getPayNum());
            if (configResponse.getType().intValue() == BrokerageConfigTypeEnum.RATIO.getValue().intValue()) {
                brokeragePrice = orderDetail.getCanBrokeragePrice().multiply(ratio).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
            } else if (configResponse.getType().intValue() == BrokerageConfigTypeEnum.FIXATION.getValue().intValue()) {
                brokeragePrice = ratio.multiply(payNum);
            } else if (configResponse.getType().intValue() == BrokerageConfigTypeEnum.RETENTION.getValue().intValue() && ratio.compareTo(price = orderDetail.getCanBrokeragePrice().divide(payNum, 2, RoundingMode.DOWN)) < 0) {
                brokeragePrice = price.subtract(ratio).multiply(payNum);
            }
            BigDecimal brokerageCalculateRatio = new BigDecimal("100");
            if (isDiscount) {
                log.info("\u6709\u4ea7\u751f\u5206\u4f63\u51b2\u7a81\uff0c\u6253\u6298\uff0c\u6309\u7167\u8ba1\u7b97\u7cfb\u6570\u8fdb\u884c\u8ba1\u7b97");
                brokerageCalculateRatio = configResponse.getCalculateRatio();
                brokeragePrice = brokeragePrice.multiply(brokerageCalculateRatio).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
            }
            log.info("\u8ba1\u7b97\u51fa\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)brokeragePrice.toPlainString());
            log.info("\u5f53\u524d\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)maxBrokeragePrice.toPlainString());
            maxBrokeragePrice = maxBrokeragePrice.subtract(brokeragePrice);
            if (maxBrokeragePrice.compareTo(BigDecimal.ZERO) < 0) {
                brokeragePrice = maxBrokeragePrice.add(brokeragePrice);
                log.info("\u8ba1\u7b97\u51fa\u53ef\u5206\u4f63\u91d1\u989d > \u5f53\u524d\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff0c\u91cd\u7f6e\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)brokeragePrice.toPlainString());
            }
            log.info("\u5206\u9500\u7c7b\u578b\uff1a{}\uff0c\u540d\u79f0\uff1a{}\uff0c\u4f63\u91d1\u7c7b\u578b\uff1a{}, \u8ba1\u7b97\u7cfb\u6570\uff1a{}, \u5206\u4f63\u91d1\u989d\uff1a{}", new Object[]{belongTypeEnum.getName(), configResponse.getName(), BrokerageConfigTypeEnum.getInstance((int)configResponse.getType()).getValue(), configResponse.getCalculateRatio().toPlainString(), brokeragePrice.toPlainString()});
            if (brokeragePrice.compareTo(BigDecimal.ZERO) > 0) {
                list.add(this.createReport(configResponse.getBelongId(), belongTypeEnum, order, orderDetail, isSub, JSONObject.toJSONString((Object)brokerageConfigSnapshotDto), configResponse.getType(), ratio, brokerageCalculateRatio, brokeragePrice, now, unFreezeTime, isServe));
            }
            log.info("\u5269\u4f59\u53ef\u5206\u4f63\u91d1\u989d\uff1a{}", (Object)maxBrokeragePrice.toPlainString());
        }
        brokerageConfigSnapshotDto.setMaxBrokeragePrice(maxBrokeragePrice);
        return list;
    }

    private BcxPerformanceReport createReport(Long belongId, BcxPerformanceReportBelongTypeEnum belongType, Order order, OrderDetail orderDetail, boolean isSub, String brokerageConfigSnapshot, Integer brokerageType, BigDecimal brokerageRatio, BigDecimal brokerageCalculateRatio, BigDecimal brokeragePrice, Date now, Date unFreezeTime, boolean isServe) {
        BcxPerformanceReport report = new BcxPerformanceReport();
        report.setId(Long.valueOf(this.snowflake.snowflakeId()));
        report.setBelongId(belongId);
        report.setBelongType(belongType.getValue());
        report.setOrderId(order.getId());
        report.setOrderNo(order.getOrderNo());
        report.setOrderUserId(orderDetail.getUid());
        report.setOrderTime(orderDetail.getCreateTime());
        report.setOrderDetailId(orderDetail.getId());
        report.setProductId(orderDetail.getProductId());
        report.setProductName(orderDetail.getProductName());
        report.setAttrValueId(orderDetail.getAttrValueId());
        report.setSku(orderDetail.getSku());
        report.setPayPrice(orderDetail.getCanBrokeragePrice());
        if (brokerageCalculateRatio.compareTo(new BigDecimal(100)) == 0) {
            report.setPayPriceCalculate(orderDetail.getCanBrokeragePrice());
        } else {
            report.setPayPriceCalculate(orderDetail.getCanBrokeragePrice().multiply(brokerageCalculateRatio).divide(new BigDecimal("100"), 2, RoundingMode.DOWN));
        }
        report.setBrokerageConfigType(Integer.valueOf(isSub ? 2 : 1));
        report.setBrokerageConfigSnapshot(brokerageConfigSnapshot);
        report.setIsServe(Integer.valueOf(isServe ? 1 : 0));
        report.setBrokerageType(brokerageType);
        report.setBrokerageRatio(brokerageRatio);
        report.setBrokerageCalculateRatio(brokerageCalculateRatio);
        report.setBrokeragePrice(brokeragePrice);
        report.setCanRefundPrice(brokeragePrice);
        if (order.getStatus().intValue() == OrderConstants.ORDER_STATUS_COMPLETE.intValue()) {
            report.setSettleStatus(BcxReportSettleStatusEnum.FROZEN.getValue());
            report.setUnFreezeTime(unFreezeTime == null ? now : unFreezeTime);
        } else {
            report.setSettleStatus(BcxReportSettleStatusEnum.WAIT_EFFECTIVE.getValue());
        }
        report.setSeparateAccountStatus(Integer.valueOf(0));
        report.setCreateTime(now);
        report.setUpdateTime(now);
        return report;
    }

    @Override
    @Async
    @Transactional
    public void generateRefundReport(String refundOrderNo) {
        log.info("==================\u751f\u6210\u9000\u6b3e\u5355\u4e1a\u7ee9\u62a5\u8868==================");
        log.info("\u53c2\u6570refundOrderNo\uff1a{}", (Object)refundOrderNo);
        String lockKey = "GENERATE_REFUND_REPORT_" + refundOrderNo;
        log.info("\u751f\u6210\u9000\u6b3e\u5355\u4e1a\u7ee9\u62a5\u8868\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(30L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            List<RefundOrderInfo> refundOrderInfoList;
            RefundOrder refundOrder = this.refundOrderService.getByRefundOrderNo(refundOrderNo);
            if (refundOrder != null && CollectionUtil.isNotEmpty(refundOrderInfoList = this.refundOrderInfoService.getListByRefundOrderNo(refundOrderNo))) {
                log.info("\u9000\u6b3e\u8ba2\u5355\u53f7\uff1a{}\uff0c\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)refundOrderNo, (Object)refundOrderInfoList.size());
                ArrayList<BcxPerformanceReport> reportList = new ArrayList<BcxPerformanceReport>();
                for (RefundOrderInfo refundOrderInfo : refundOrderInfoList) {
                    if (refundOrderInfo.getBrokerageStatus() != 0) {
                        log.info("\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6id\uff1a{}\uff0c\u5df2\u751f\u6210\u9000\u6b3e\u8ba2\u5355\u4e1a\u7ee9\u62a5\u8868\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210", (Object)refundOrderInfo.getId());
                        continue;
                    }
                    List<BcxPerformanceReport> originalReportList = this.listByOrderDetailId(refundOrderInfo.getOrderDetailId());
                    if (CollectionUtil.isEmpty(originalReportList)) {
                        log.info("\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6id\uff1a{}\uff0c\u65e0\u5df2\u4ea7\u751f\u7684\u4e1a\u7ee9\u62a5\u8868\uff0c\u4e0d\u9700\u8981\u751f\u6210\u9000\u6b3e\u8ba2\u5355\u4e1a\u7ee9\u62a5\u8868", (Object)refundOrderInfo.getId());
                        continue;
                    }
                    log.info("\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6id\uff1a{}\uff0c\u5df2\u4ea7\u751f\u7684\u4e1a\u7ee9\u62a5\u8868\u6570\u91cf\uff1a{}", (Object)refundOrderInfo.getId(), (Object)originalReportList.size());
                    Date now = new Date();
                    Date unFreezeTime = this.getUnFreezeTime(now);
                    reportList.addAll(this.createRefundReport(originalReportList, refundOrder, refundOrderInfo, now, unFreezeTime));
                    refundOrderInfo.setBrokerageStatus(Integer.valueOf(1));
                    this.refundOrderInfoService.updateById(refundOrderInfo);
                }
                log.info("\u4fdd\u5b58\u5165\u5e93");
                if (CollectionUtil.isNotEmpty(reportList)) {
                    log.info("\u4fdd\u5b58\u5165\u5e93\u6570\u91cf\uff1a{}", (Object)reportList.size());
                    this.saveBatch(reportList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u751f\u6210\u9000\u6b3e\u5355\u4e1a\u7ee9\u62a5\u8868\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u751f\u6210\u9000\u6b3e\u5355\u4e1a\u7ee9\u62a5\u8868\u5f02\u5e38:" + e.getMessage()));
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u751f\u6210\u9000\u6b3e\u5355\u4e1a\u7ee9\u62a5\u8868\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
        log.info("==================\u751f\u6210\u9000\u6b3e\u5355\u4e1a\u7ee9\u62a5\u8868\u5b8c\u6210==================");
    }

    private List<BcxPerformanceReport> createRefundReport(List<BcxPerformanceReport> performanceReportList, RefundOrder refundOrder, RefundOrderInfo refundOrderInfo, Date now, Date unFreezeTime) {
        ArrayList<BcxPerformanceReport> list = new ArrayList<BcxPerformanceReport>();
        for (BcxPerformanceReport originalReport : performanceReportList) {
            if (originalReport.getSettleStatus().intValue() == BcxReportSettleStatusEnum.WAIT_EFFECTIVE.getValue().intValue()) {
                originalReport.setSettleStatus(BcxReportSettleStatusEnum.FROZEN.getValue());
                originalReport.setUnFreezeTime(unFreezeTime);
                originalReport.setUpdateTime(now);
            }
            BigDecimal brokeragePrice = refundOrderInfo.getRefundPrice().negate();
            BigDecimal canRefundPrice = originalReport.getCanRefundPrice().add(brokeragePrice);
            if (canRefundPrice.compareTo(BigDecimal.ZERO) < 0) {
                log.info("\u5206\u9500belongType\uff1a{}\uff0cbelongId\uff1a{}\uff0c\u80fd\u9000\u6b3e\u7684\u4f63\u91d1\u4f59\u989d\u4e0d\u8db3\uff0c\u4e0d\u80fd\u4ea7\u751f\u9000\u6b3e\u4e1a\u7ee9\u62a5\u8868", (Object)originalReport.getBelongType(), (Object)originalReport.getBelongId());
                continue;
            }
            originalReport.setCanRefundPrice(canRefundPrice);
            this.updateById(originalReport);
            log.info("\u5206\u9500belongType\uff1a{}\uff0cbelongId\uff1a{}\uff0c\u9000\u6b3e\u4f63\u91d1\uff1a{}", new Object[]{originalReport.getBelongType(), originalReport.getBelongId(), brokeragePrice.toPlainString()});
            list.add(this.createRefundReport(originalReport, refundOrder, refundOrderInfo, brokeragePrice, now, unFreezeTime));
        }
        return list;
    }

    private BcxPerformanceReport createRefundReport(BcxPerformanceReport originalReport, RefundOrder refundOrder, RefundOrderInfo refundOrderInfo, BigDecimal brokeragePrice, Date now, Date unFreezeTime) {
        BcxPerformanceReport report = new BcxPerformanceReport();
        report.setId(Long.valueOf(this.snowflake.snowflakeId()));
        report.setBelongId(originalReport.getBelongId());
        report.setBelongType(originalReport.getBelongType());
        report.setOrderId(originalReport.getOrderId());
        report.setOrderNo(originalReport.getOrderNo());
        report.setOrderUserId(originalReport.getOrderUserId());
        report.setOrderTime(originalReport.getOrderTime());
        report.setOrderDetailId(originalReport.getOrderDetailId());
        report.setProductId(originalReport.getProductId());
        report.setProductName(originalReport.getProductName());
        report.setAttrValueId(originalReport.getAttrValueId());
        report.setSku(originalReport.getSku());
        report.setRefundOrderId(refundOrder.getId());
        report.setRefundOrderNo(refundOrder.getRefundOrderNo());
        report.setRefundOrderInfoId(refundOrderInfo.getId());
        report.setPayPrice(originalReport.getPayPrice());
        report.setBrokerageConfigType(originalReport.getBrokerageConfigType());
        report.setBrokerageConfigSnapshot(originalReport.getBrokerageConfigSnapshot());
        report.setIsServe(originalReport.getIsServe());
        report.setBrokerageType(originalReport.getBrokerageType());
        report.setBrokerageRatio(originalReport.getBrokerageRatio());
        report.setBrokerageCalculateRatio(originalReport.getBrokerageCalculateRatio());
        report.setBrokeragePrice(brokeragePrice);
        report.setCanRefundPrice(BigDecimal.ZERO);
        report.setSettleStatus(BcxReportSettleStatusEnum.FROZEN.getValue());
        report.setUnFreezeTime(unFreezeTime == null ? now : unFreezeTime);
        report.setSeparateAccountStatus(Integer.valueOf(0));
        report.setCreateTime(now);
        report.setUpdateTime(now);
        if (report.getBelongType().intValue() == BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue().intValue() || report.getBelongType().intValue() == BcxPerformanceReportBelongTypeEnum.USER_FXY.getValue().intValue()) {
            this.userBrokerageRecordService.createRefundBrokerageRecord(report.getBelongId().intValue(), report.getOrderNo(), report.getBrokeragePrice());
        }
        return report;
    }

    private Date getUnFreezeTime(Date now) {
        int frozenDay = Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time"));
        Calendar unFreezeTimeCalendar = Calendar.getInstance();
        unFreezeTimeCalendar.setTime(now);
        unFreezeTimeCalendar.add(6, frozenDay);
        return unFreezeTimeCalendar.getTime();
    }

    @Override
    public PageInfo<BcxPerformanceReportResponse> getPage(BcxPerformanceReportSearchRequest request, PageParamRequest pageParamRequest) {
        List<Object> list = new ArrayList();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        if (request.getSearchType() != null) {
            HashMap<String, Object> map = this.getSearchParamMap(request);
            if (request.getSearchType() == 1) {
                list = this.dao.selectChannelList(map);
            } else if (request.getSearchType() == 2) {
                list = this.dao.selectDepartmentList(map);
            } else if (request.getSearchType() == 3) {
                list = this.dao.selectDepartmentMemberList(map);
            } else if (request.getSearchType() == 4) {
                list = this.dao.selectFxsList(map);
            } else if (request.getSearchType() == 5) {
                list = this.dao.selectFxyList(map);
            } else if (request.getSearchType() == 6) {
                list = this.dao.selectUserList(map);
            }
        }
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public List<BcxPerformanceReport> listWaitSettledByEndTime(Date endTime) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.le((Object)"un_freeze_time", (Object)endTime);
        queryWrapper.eq((Object)"settle_status", (Object)BcxReportSettleStatusEnum.WAIT_SETTLED.getValue());
        queryWrapper.isNull((Object)"settle_bill_id");
        return this.list((Wrapper)queryWrapper);
    }

    private List<BcxPerformanceReport> listByOrderDetailId(Integer orderDetailId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"order_detail_id", (Object)orderDetailId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public BcxBrokerageStatisticsResponse brokerageStatistics() {
        BcxBrokerageStatisticsResponse response = new BcxBrokerageStatisticsResponse();
        Integer userId = this.userService.getUserId();
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"belong_id", (Object)userId);
        queryWrapper.in((Object)"settle_status", Arrays.asList(BcxReportSettleStatusEnum.FROZEN.getValue(), BcxReportSettleStatusEnum.WAIT_SETTLED.getValue(), BcxReportSettleStatusEnum.SETTLED.getValue()));
        queryWrapper.in((Object)"belong_type", Arrays.asList(BcxPerformanceReportBelongTypeEnum.CHANNEL.getValue(), BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue(), BcxPerformanceReportBelongTypeEnum.USER_FXY.getValue()));
        List performanceReportList = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)performanceReportList)) {
            for (BcxPerformanceReport report : performanceReportList) {
                if (report.getSettleStatus().intValue() == BcxReportSettleStatusEnum.FROZEN.getValue().intValue()) {
                    response.setFrozenBrokeragePrice(response.getFrozenBrokeragePrice().add(report.getBrokeragePrice()));
                } else if (report.getSettleStatus().intValue() == BcxReportSettleStatusEnum.WAIT_SETTLED.getValue().intValue()) {
                    response.setWaitSettledBrokeragePrice(response.getWaitSettledBrokeragePrice().add(report.getBrokeragePrice()));
                } else if (report.getSettleStatus().intValue() == BcxReportSettleStatusEnum.SETTLED.getValue().intValue()) {
                    response.setSettledBrokeragePrice(response.getSettledBrokeragePrice().add(report.getBrokeragePrice()));
                }
                response.setTotalBrokeragePrice(response.getTotalBrokeragePrice().add(report.getBrokeragePrice()));
                response.setTotalCount(Integer.valueOf(response.getTotalCount() + 1));
            }
        }
        return response;
    }

    @Override
    public BcxPerformanceReportStatisticsResponse statistics(BcxPerformanceReportSearchRequest request) {
        BcxPerformanceReportStatisticsResponse response = new BcxPerformanceReportStatisticsResponse();
        if (request.getSearchType() != null) {
            HashMap<String, Object> map = this.getSearchParamMap(request);
            if (request.getSearchType() == 1) {
                response = this.dao.selectChannelCount(map);
            } else if (request.getSearchType() == 2) {
                response = this.dao.selectDepartmentCount(map);
            } else if (request.getSearchType() == 3) {
                response = this.dao.selectDepartmentMemberCount(map);
            } else if (request.getSearchType() == 4) {
                response = this.dao.selectFxsCount(map);
            } else if (request.getSearchType() == 5) {
                response = this.dao.selectFxyCount(map);
            } else if (request.getSearchType() == 6) {
                response = this.dao.selectUserCount(map);
            }
        }
        return response;
    }

    private HashMap<String, Object> getSearchParamMap(BcxPerformanceReportSearchRequest request) {
        BcxDepartment department;
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            map.put("orderStartTime", dateLimitUtilVo.getStartTime());
            map.put("orderEndTime", dateLimitUtilVo.getEndTime());
        }
        if (ObjectUtil.isNotNull((Object)request.getUserId())) {
            map.put("userId", request.getUserId());
        }
        if (ObjectUtil.isNotNull((Object)request.getSpreadUid())) {
            map.put("spreadUid", request.getSpreadUid());
        }
        if (request.getSettleBillId() != null) {
            map.put("settleBillId", request.getSettleBillId());
        }
        if (request.getSettleId() != null) {
            map.put("settleId", request.getSettleId());
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getSettleBillIdList())) {
            map.put("settleBillIdList", request.getSettleBillIdList());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSettleStatus())) {
            List settleStatusList = Arrays.stream(request.getSettleStatus().split(",")).collect(Collectors.toList());
            map.put("settleStatusList", settleStatusList);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", request.getName());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getBrokerageUserPhone())) {
            map.put("brokerageUserPhone", request.getBrokerageUserPhone());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", request.getOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderRegionCode())) {
            map.put("orderRegionCode", request.getOrderRegionCode().substring(0, 2));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderUserName())) {
            map.put("orderUserName", request.getOrderUserName());
        }
        if (request.getSearchType() == 2) {
            if (StringUtils.isNotBlank((CharSequence)request.getBcxId())) {
                department = this.bcxDepartmentService.findByBcxId(request.getBcxId());
                if (department != null) {
                    map.put("departmentId", department.getId());
                } else {
                    map.put("departmentId", -1);
                }
            }
        } else if (request.getSearchType() == 3 && StringUtils.isNotBlank((CharSequence)request.getBcxId())) {
            department = this.bcxDepartmentService.findByBcxId(request.getBcxId());
            if (department != null) {
                map.put("departmentId", department.getId());
            } else {
                BcxDepartmentMember departmentMember = this.bcxDepartmentMemberService.findByBcxId(request.getBcxId());
                if (departmentMember != null) {
                    map.put("departmentMemberId", departmentMember.getId());
                } else {
                    map.put("departmentMemberId", -1);
                }
            }
        }
        return map;
    }
}

