/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.captcha.util;

import com.zbkj.common.captcha.util.RandomUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AESUtil {
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static String getKey() {
        return RandomUtils.getRandomString(16);
    }

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        Base64.Decoder decoder = Base64.getDecoder();
        return StringUtils.isEmpty((CharSequence)base64Code) ? null : decoder.decode(base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        if (StringUtils.isBlank((CharSequence)encryptKey)) {
            return content;
        }
        return AESUtil.base64Encode(AESUtil.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        if (StringUtils.isBlank((CharSequence)decryptKey)) {
            return encryptStr;
        }
        return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AESUtil.aesDecryptByBytes(AESUtil.base64Decode(encryptStr), decryptKey);
    }

    public static void main(String[] args) throws Exception {
        String randomString = RandomUtils.getRandomString(16);
        String content = "hahhahaahhahni";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        System.out.println("\u52a0\u5bc6\u5bc6\u94a5\u548c\u89e3\u5bc6\u5bc6\u94a5\uff1a" + randomString);
        String encrypt = AESUtil.aesEncrypt(content, randomString);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encrypt);
        String decrypt = AESUtil.aesDecrypt(encrypt, randomString);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + decrypt);
    }
}

