/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.bcx.BcxRegion;
import com.zbkj.common.response.BcxRegionResponse;
import com.zbkj.service.dao.BcxRegionDao;
import com.zbkj.service.service.BcxRegionService;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BcxRegionServiceImpl
extends ServiceImpl<BcxRegionDao, BcxRegion>
implements BcxRegionService {
    @Resource
    private BcxRegionDao dao;

    @Override
    public BcxRegion findByCode(String code) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxRegion::getRegionCode, (Object)code);
        return (BcxRegion)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<BcxRegionResponse> findAllTree() {
        List allList = this.list();
        List responseList = allList.stream().map(this::getBcxRegionResponse).collect(Collectors.toList());
        Map responseMap = responseList.stream().collect(Collectors.toMap(BcxRegionResponse::getRegionCode, Function.identity()));
        for (BcxRegionResponse response : responseList) {
            BcxRegionResponse parent = (BcxRegionResponse)responseMap.get(response.getParentCode());
            if (parent == null) continue;
            parent.addChildren(response);
        }
        List<BcxRegionResponse> rootList = responseList.stream().filter(region -> region.getParentCode().equals("100000")).collect(Collectors.toList());
        return rootList;
    }

    private BcxRegionResponse getBcxRegionResponse(BcxRegion region) {
        BcxRegionResponse regionResponse = new BcxRegionResponse();
        regionResponse.setRegionCode(region.getRegionCode());
        regionResponse.setParentCode(region.getParentCode());
        regionResponse.setRegionName(region.getRegionName());
        return regionResponse;
    }
}

