/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.api.internal.util;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankApiExceptionEnum;
import com.zbkj.service.wangshang.api.internal.util.SignatureUtils;
import com.zbkj.service.wangshang.api.internal.util.StringUtils;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class MybankSignature {
    public static String rsa256SignContent(String content, String privateKey, String signType, String charset) throws MybankApiException {
        if (!"RSA".equals(signType)) {
            throw new MybankApiException(MybankApiExceptionEnum.ILLEGAL_SIGN_TYPE);
        }
        try {
            PrivateKey priKey = SignatureUtils.getPrivateKey(privateKey, signType);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_ENCRYPT_ERROR, (Throwable)e);
        }
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String signType, String charset) throws MybankApiException {
        if (!"RSA".equals(signType)) {
            throw new MybankApiException(MybankApiExceptionEnum.ILLEGAL_SIGN_TYPE);
        }
        try {
            PublicKey pubKey = SignatureUtils.getPublicKey(publicKey, signType);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_VERIFY_ERROR, (Throwable)e);
        }
    }

    public static String sign(String xmlContent, String privateKey, String charset, String signType, String elementTagName) throws MybankApiException {
        if ("RSA".equals(signType)) {
            return MybankSignature.rsaSign(xmlContent, privateKey, charset, signType, elementTagName);
        }
        throw new MybankApiException(MybankApiExceptionEnum.ILLEGAL_SIGN_TYPE);
    }

    private static String rsaSign(String xmlContent, String privateKey, String charset, String signType, String elementTagName) throws MybankApiException {
        try {
            PrivateKey priKey = SignatureUtils.getPrivateKey(privateKey, signType);
            Document xmlDoc = MybankSignature.parseDocumentByString(xmlContent);
            return SignatureUtils.signXmlElement(priKey, xmlDoc, elementTagName, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", 2);
        }
        catch (InvalidKeySpecException e) {
            throw new MybankApiException(MybankApiExceptionEnum.ILLEGAL_RSA_PRIVATE_KEY, (Throwable)e);
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_ENCRYPT_ERROR, (Throwable)e);
        }
    }

    public static boolean check(String xmlContent, String publicKey, String charset, String signType) throws MybankApiException {
        if ("RSA".equals(signType)) {
            return MybankSignature.rsaCheckContent(xmlContent, publicKey, charset, signType);
        }
        throw new MybankApiException(MybankApiExceptionEnum.ILLEGAL_SIGN_TYPE);
    }

    private static boolean rsaCheckContent(String xmlContent, String publicKey, String charset, String signType) throws MybankApiException {
        try {
            PublicKey pubKey = SignatureUtils.getPublicKey(publicKey, signType);
            Document xmlDoc = MybankSignature.parseDocumentByString(xmlContent);
            return SignatureUtils.verifyXmlElement(pubKey, xmlDoc);
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_VERIFY_ERROR, (Throwable)e);
        }
    }

    public static Document parseDocumentByString(String xmlContent) throws MybankApiException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlContent)));
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.XML_PARSE_ERROR, (Throwable)e);
        }
    }
}

