/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.IntegralPageSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.IntegralRecordPageResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.UserIntegralRecordDao;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class UserIntegralRecordServiceImpl
extends ServiceImpl<UserIntegralRecordDao, UserIntegralRecord>
implements UserIntegralRecordService {
    private static final Logger logger = LoggerFactory.getLogger(UserIntegralRecordServiceImpl.class);
    @Resource
    private UserIntegralRecordDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<UserIntegralRecord> findListByOrderNoAndUid(String orderNo, Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserIntegralRecord::getUid, (Object)uid);
        lqw.eq(UserIntegralRecord::getLinkId, (Object)orderNo);
        lqw.in(UserIntegralRecord::getStatus, new Object[]{IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE, IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN, IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE});
        List recordList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)recordList)) {
            return recordList;
        }
        int i = 0;
        while (i < recordList.size()) {
            UserIntegralRecord record = (UserIntegralRecord)recordList.get(i);
            if (record.getType().equals(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD) && record.getStatus().equals(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE)) {
                recordList.remove(i);
                continue;
            }
            ++i;
        }
        return recordList;
    }

    @Override
    public void integralThaw() {
        List<UserIntegralRecord> thawList = this.findThawList();
        if (CollUtil.isEmpty(thawList)) {
            return;
        }
        for (UserIntegralRecord record : thawList) {
            User user = (User)this.userService.getById(record.getUid());
            if (ObjectUtil.isNull((Object)user)) continue;
            record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
            Integer balance = user.getIntegral() + record.getIntegral();
            record.setBalance(balance);
            record.setUpdateTime((Date)DateUtil.date());
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(record);
                this.userService.updateIntegral(record.getUid(), record.getIntegral(), "add");
                return Boolean.TRUE;
            });
            if (execute.booleanValue()) continue;
            logger.error(StrUtil.format((CharSequence)"\u79ef\u5206\u89e3\u51bb\u5904\u7406\u2014\u89e3\u51bb\u51fa\u9519\uff0c\u8bb0\u5f55id = {}", (Object[])new Object[]{record.getId()}));
        }
    }

    @Override
    public PageInfo<UserIntegralRecord> findUserIntegralRecordList(Integer uid, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserIntegralRecord::getId, UserIntegralRecord::getTitle, UserIntegralRecord::getType, UserIntegralRecord::getIntegral, UserIntegralRecord::getUpdateTime});
        lqw.eq(UserIntegralRecord::getUid, (Object)uid);
        lqw.eq(UserIntegralRecord::getStatus, (Object)IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        lqw.orderByDesc(UserIntegralRecord::getUpdateTime);
        List integralRecordList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)integralRecordList);
    }

    private List<UserIntegralRecord> findThawList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.le(UserIntegralRecord::getThawTime, (Object)System.currentTimeMillis());
        lqw.eq(UserIntegralRecord::getLinkType, (Object)"order");
        lqw.eq(UserIntegralRecord::getType, (Object)IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        lqw.eq(UserIntegralRecord::getStatus, (Object)IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public UserIntegralRecord getByOrderNoAndType(String orderNo, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserIntegralRecord::getLinkId, (Object)orderNo);
        lqw.eq(UserIntegralRecord::getLinkType, (Object)"order");
        lqw.eq(UserIntegralRecord::getType, (Object)type);
        lqw.last(" limit 1");
        return (UserIntegralRecord)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Integer getSettledIntegralByUid(Integer uid) {
        QueryWrapper query = Wrappers.query();
        query.select(new String[]{"IFNULL(sum(integral), 0) as integral"});
        query.ne((Object)"link_type", (Object)"refund");
        query.eq((Object)"type", (Object)IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        query.eq((Object)"status", (Object)IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        query.eq((Object)"uid", (Object)uid);
        UserIntegralRecord userIntegralRecord = (UserIntegralRecord)this.dao.selectOne((Wrapper)query);
        return userIntegralRecord.getIntegral();
    }

    @Override
    public Integer getFreezeIntegralByUid(Integer uid) {
        QueryWrapper query = Wrappers.query();
        query.select(new String[]{"IFNULL(sum(integral), 0) as integral"});
        query.eq((Object)"type", (Object)IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        query.in((Object)"status", new Object[]{IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE, IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN});
        query.eq((Object)"uid", (Object)uid);
        UserIntegralRecord userIntegralRecord = (UserIntegralRecord)this.dao.selectOne((Wrapper)query);
        return userIntegralRecord.getIntegral();
    }

    @Override
    public PageInfo<IntegralRecordPageResponse> findRecordPageListByPlat(IntegralPageSearchRequest request, PageParamRequest pageRequest) {
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserIntegralRecord::getStatus, (Object)IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.eq(UserIntegralRecord::getLinkId, (Object)keywords);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            lqw.between(UserIntegralRecord::getUpdateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.orderByDesc(UserIntegralRecord::getUpdateTime);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new IntegralRecordPageResponse[0]));
        }
        List<Integer> uidList = list.stream().map(UserIntegralRecord::getUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        List responseList = list.stream().map(i -> {
            IntegralRecordPageResponse response = new IntegralRecordPageResponse();
            BeanUtils.copyProperties((Object)i, (Object)response);
            response.setNickName(((User)userMap.get(i.getUid())).getNickname());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }
}

