package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class PolicyExcelVo implements Serializable {

	@ExcelVOAttribute(name = "保单号", column = "A", isExport = true, isRequest = true)
	private String external_reference;

	@ExcelVOAttribute(name = "投保公司名称", column = "B", isExport = true, isRequest = true)
	private String applicant_name;

	@ExcelVOAttribute(name = "保险公司", column = "C", isExport = true, isRequest = true)
	private String insurance_name;

	@ExcelVOAttribute(name = "在保人数", column = "D", isExport = true, isRequest = true)
	private String zb_num;

	@ExcelVOAttribute(name = "每人保费", column = "E", isExport = true, isRequest = true)
	private String premium;

	@ExcelVOAttribute(name = "保险到期日（年月日）", column = "F", isExport = true, isRequest = true)
	private String planned_date;

	@ExcelVOAttribute(name = "保险有效期", column = "G", isExport = true, isRequest = true)
	private String validityPeriod;

	@ExcelVOAttribute(name = "区域", column = "H", isExport = true, isRequest = true)
	private String areaName;

	/**
	 * 导入的错误信息
	 */
	private String errorMsg;

	public PolicyExcelVo(){}

	public PolicyExcelVo(String external_reference
			, String applicant_name
			, String insurance_name
			, String zb_num
			, String validityPeriod
			, String areaName
			, String planned_date
			, String premium){
		this.external_reference = external_reference;
		this.insurance_name = insurance_name;
		this.zb_num = zb_num;
		this.validityPeriod = validityPeriod;
		this.applicant_name = applicant_name;
		this.planned_date = planned_date;
		this.areaName = areaName;
		this.premium = premium;
	}

	public String getExternal_reference() {
		return external_reference;
	}

	public void setExternal_reference(String external_reference) {
		this.external_reference = external_reference;
	}

	public String getApplicant_name() {
		return applicant_name;
	}

	public void setApplicant_name(String applicant_name) {
		this.applicant_name = applicant_name;
	}

	public String getInsurance_name() {
		return insurance_name;
	}

	public void setInsurance_name(String insurance_name) {
		this.insurance_name = insurance_name;
	}

	public String getZb_num() {
		return zb_num;
	}

	public void setZb_num(String zb_num) {
		this.zb_num = zb_num;
	}

	public String getPremium() {
		return premium;
	}

	public void setPremium(String premium) {
		this.premium = premium;
	}

	public String getPlanned_date() {
		return planned_date;
	}

	public void setPlanned_date(String planned_date) {
		this.planned_date = planned_date;
	}

	public String getValidityPeriod() {
		return validityPeriod;
	}

	public void setValidityPeriod(String validityPeriod) {
		this.validityPeriod = validityPeriod;
	}

	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public String getErrorMsg() {
		if (StringUtils.isNotEmpty(errorMsg)) {
			return errorMsg;
		} else {
			return "";
		}
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
}
