package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import lombok.Data;

import java.io.Serializable;

/**
 * 保全缴费表
 */
@Data
public class InsPreservationPayChildExcelVo implements Serializable {

    /**
     * 保单号
     */
    @ExcelVOAttribute(name = "保单号", column = "A", isExport = true, isRequest = true)
    private String external_reference;
    /**
     * 保险公司名称
     */
    @ExcelVOAttribute(name = "保险公司", column = "B", isExport = true, isRequest = true)
    private String company_name;
    /**
     * 保险产品名称
     */
    @ExcelVOAttribute(name = "保险产品", column = "C", isExport = true, isRequest = true)
    private String insurance_name;
    /**
     * 投保人名称
     */
    @ExcelVOAttribute(name = "投保人", column = "D", isExport = true, isRequest = true)
    private String app_role_name;
    /**
     * 付款状态0.待处理；1.待支付；2.待审核；3.已支付；4.暂存
     */
    @ExcelVOAttribute(name = "账单状态", column = "E", isExport = true, isRequest = true)
    private String pay_status;

    /**
     * 保全单数
     */
    @ExcelVOAttribute(name = "批改单量", column = "F", isExport = true, isRequest = true)
    private String record_count;
    /**
     * 增员人数
     */
    @ExcelVOAttribute(name = "增员", column = "G", isExport = true, isRequest = true)
    private String add_count;

    /**
     * 减员人数
     */
    @ExcelVOAttribute(name = "减员", column = "H", isExport = true, isRequest = true)
    private String minus_count;

    /**
     * 替换人数
     */
    @ExcelVOAttribute(name = "替换", column = "I", isExport = true, isRequest = true)
    private String replace_count;

    /**
     * 预期总保费
     */
    @ExcelVOAttribute(name = "预缴金额", column = "J", isExport = true, isRequest = true)
    private String predict_total_amount;

    /**
     * 实际总保费
     */
    @ExcelVOAttribute(name = "实缴金额", column = "K", isExport = true, isRequest = false)
    private String fact_total_amount;

    /**
     * 结算开始时间
     */
    @ExcelVOAttribute(name = "结算开始时间", column = "L", isExport = true, isRequest = true)
    private String star_pay_time;

    /**
     * 结算终止时间
     */
    @ExcelVOAttribute(name = "结算终止时间", column = "M", isExport = true, isRequest = true)
    private String end_pay_time;

//    public InsPreservationPayChildExcelVo(){}

    public InsPreservationPayChildExcelVo(String external_reference, String company_name, String insurance_name, String app_role_name, String pay_status, String record_count, String add_count, String minus_count, String replace_count, String predict_total_amount, String fact_total_amount, String star_pay_time, String end_pay_time){
        this.external_reference = external_reference;
        this.company_name = company_name;
        this.insurance_name = insurance_name;
        this.app_role_name = app_role_name;
        this.pay_status = pay_status;
        this.record_count = record_count;
        this.add_count = add_count;
        this.minus_count = minus_count;
        this.replace_count = replace_count;
        this.predict_total_amount = predict_total_amount;
        this.fact_total_amount = fact_total_amount;
        this.star_pay_time = star_pay_time;
        this.end_pay_time = end_pay_time;
    }
}