package com.bcxin.ins.vo.excel;


import com.bcxin.ins.util.excel.ExcelVOAttribute;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * <b> 异常人员信息批量导入Excel </b>
 * @author ZXF
 * @create 2020/01/16 0016 11:24
 * @version
 * @注意事项 </b>
 */
public class InsPerExcelVo implements Serializable {

    private static final long serialVersionUID = -3531925993852171266L;

    @ExcelVOAttribute(name = "序号", column = "A", isExport = true, isRequest = true)
    private String number;

    @ExcelVOAttribute(name = "姓名", column = "B", isExport = true, isRequest = false)
    private String name;

    @ExcelVOAttribute(name = "证件类型", column = "C", isExport = true, isRequest = false)
    private String idCardType;

    @ExcelVOAttribute(name = "证件号码", column = "D", isExport = true, isRequest = false)
    private String idCardNo;

    @ExcelVOAttribute(name = "出生日期", column = "E", isExport = true, isRequest = false)
    private String birthday;

    @ExcelVOAttribute(name = "性别", column = "F", isExport = true, isRequest = false)
    private String sex;

    @ExcelVOAttribute(name = "手机号", column = "G", isExport = true, isRequest = false)
    private String mobilePhone;

    @ExcelVOAttribute(name = "职业", column = "H", isExport = true, isRequest = false)
    private String perType;

    @ExcelVOAttribute(name = "错误信息", column = "I", isExport = true, isRequest = true)
    private String errorMsg;

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdCardType() {
        return idCardType;
    }

    public void setIdCardType(String idCardType) {
        this.idCardType = idCardType;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getPerType() {
        return perType;
    }

    public void setPerType(String perType) {
        this.perType = perType;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        if (StringUtils.isNotEmpty(errorMsg)) {
            return errorMsg;
        } else {
            return "";
        }
    }
}