package com.bcxin.ins.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.util.StrUtil;

/**
 * <b> 短信内容模板 </b>
 * @author ZXF
 * @create 2020/02/24 0024 10:24
 * @version
 * @注意事项 </b>
 */
public class SmsModel {


	/** 华为短信发送相关常量 */
	public final static String P01 = "尊敬的客户，你的校验码为{}，工作人员不会索取此验证码，请勿泄露，如有疑问，请致电4006629696咨询";
	public final static String B7 = "尊敬的用户，您于{}在保险平台提交的保全申请单（{}[{}]，暂批单号：{}）已被退回。请及时处理，以免影响您的后续操作。";
	public final static String B9 = "尊敬的用户，您于{}至{}在保险平台的保全缴费单已生成。保全费用共：{}元。请及时处理，以免影响您的后续保障。";

	public static String getContent(String smsCode, String params){
		String content = "";
		switch (smsCode) {
			case "P01":
				content = P01;
				break;
			case "B7":
				content = B7;
				break;
			case "B9":
				content = B9;
				break;
			default:
				break;
		}
		if(StringUtils.isNotEmpty(content)){
			JSONArray array = JSON.parseArray(params);
			Object[] ps = array.toArray();
			content = StrUtil.format(content,ps);
		}
		return content;
	}
}
