package com.bcxin.ins.vo;

import com.bcxin.mybatisplus.annotations.TableField;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * 保全申请单表
 */
public class InsPreservationRecordVo extends BaseVo{

    /**
     * id
     */
    private String oid;

    /**
     * 保单id
     */

    private String ins_insurance_slip_id;


    /**
     * 批改流水号
     */
    private String revise_serial_number;

    /**
     * 批改单号
     */
    private String revise_serial_num_ins;

    /**
     * 批改类型
     */
    private String revise_type;

    /**
     * 批改状态
     */
    private String revise_status;

    /**
     * 保单号
     */
    private String external_reference;

    /**
     * 保全生效日期
     */
    private String inception_date;
    /**
     * 订单生效日期
     */
    private String planned_start_date;



    /**
     * 订单失效日期
     */
    private String planned_end_date;

    /**
     * 保险公司id
     */
    private String sys_ins_company_id;
    /**
     * 保险公司名称
     */
    private String company_name;
    /**
     * 投保人
     */
 private  String app_role_name;



    /**
     * 保全缴费表id
     */
    private String ins_preservation_pay_id;

    /**
     * 提交申请时间
     */
    private String start_time;

    /**
     * 修改时间
     */
    private String update_time;

    /**
     * 增员人数
     */
    private String add_count;

    /**
     * 减员人数
     */
    private String minus_count;

    /**
     * 替换人数
     */
    private String replace_count;

    /**
     * 批改单地址
     */
    private String revise_path;

    /**
     * 批改支付地址
     */
    private String revise_pay;

    private String e_invoice_url;//电子发票地址

    /**
     * 备注
     */
    private String remark;
    /**
     * 批改次数(长安批单报文需要，通过查询保单的批改次数，不需要存数据库)
     */
    private int serialNo = 0;

    /**
     * 版本发布时间
     */
    private String release_time;

    /**
     * 总保费
     */
    private String total_premium;
    /**
     * 累计保费
     */
    private String premium_change;
    /**
     * 总保额
     */
    private String total_amount;
    /**
     * 累计保额
     */
    private String amount_change;

    private List<InsPreservationDetailVo> insPreservationDetailVoList;//保全详情记录

    private List<InsPreservationResultSetVo> insPreservationResultSetVoList;//保全版本结果集

    /**
     * 线上保全结果
     * 请求保险公司做线上保全成功返回的报文数据
     */
    private Map recordRest;

    /**
     * saas企业id,当前用于完成业务给对方发站内通知
     */
    private String comId;

    private Map<String,String> bankMap;//太保退款银行信息

    public String getOid() {
        return oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getIns_insurance_slip_id() {
        return ins_insurance_slip_id;
    }

    public void setIns_insurance_slip_id(String ins_insurance_slip_id) { this.ins_insurance_slip_id = ins_insurance_slip_id; }

    public String getPlanned_end_date() {return planned_end_date; }

    public void setPlanned_end_date(String planned_end_date) { this.planned_end_date = planned_end_date; }

    public String getCompany_name() { return company_name; }

    public void setCompany_name(String company_name) { this.company_name = company_name; }

    public String getRevise_serial_number() {
        return revise_serial_number;
    }

    public void setRevise_serial_number(String revise_serial_number) {
        this.revise_serial_number = revise_serial_number;
    }

    public String getRevise_serial_num_ins() {
        return revise_serial_num_ins;
    }

    public void setRevise_serial_num_ins(String revise_serial_num_ins) {
        this.revise_serial_num_ins = revise_serial_num_ins;
    }
    public String getApp_role_name() {
        return app_role_name;
    }

    public void setApp_role_name(String app_role_name) {
        this.app_role_name = app_role_name;
    }
    public String getRevise_type() {
        return revise_type;
    }

    public void setRevise_type(String revise_type) {
        this.revise_type = revise_type;
    }

    public String getRevise_status() {
        return revise_status;
    }

    public void setRevise_status(String revise_status) {
        this.revise_status = revise_status;
    }

    public String getExternal_reference() {
        return external_reference;
    }

    public void setExternal_reference(String external_reference) {
        this.external_reference = external_reference;
    }

    public String getInception_date() {
        return inception_date;
    }

    public void setInception_date(String inception_date) {
        this.inception_date = inception_date;
    }

    public String getSys_ins_company_id() {
        return sys_ins_company_id;
    }

    public void setSys_ins_company_id(String sys_ins_company_id) {
        this.sys_ins_company_id = sys_ins_company_id;
    }

    public String getPlanned_start_date() { return planned_start_date; }

    public void setPlanned_start_date(String planned_start_date) { this.planned_start_date = planned_start_date; }
    public String getIns_preservation_pay_id() {
        return ins_preservation_pay_id;
    }

    public void setIns_preservation_pay_id(String ins_preservation_pay_id) {
        this.ins_preservation_pay_id = ins_preservation_pay_id;
    }

    public String getStart_time() {
        return start_time;
    }

    public void setStart_time(String start_time) {
        this.start_time = start_time;
    }

    public String getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(String update_time) {
        this.update_time = update_time;
    }

    public String getAdd_count() {
        return add_count;
    }

    public void setAdd_count(String add_count) {
        this.add_count = add_count;
    }

    public String getMinus_count() {
        return minus_count;
    }

    public void setMinus_count(String minus_count) {
        this.minus_count = minus_count;
    }

    public String getReplace_count() {
        return replace_count;
    }

    public void setReplace_count(String replace_count) {
        this.replace_count = replace_count;
    }

    public String getRevise_path() {
        return revise_path;
    }

    public void setRevise_path(String revise_path) {
        this.revise_path = revise_path;
    }

    public String getRevise_pay() {
        return revise_pay;
    }

    public void setRevise_pay(String revise_pay) {
        this.revise_pay = revise_pay;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRelease_time() {
        return release_time;
    }

    public void setRelease_time(String release_time) {
        this.release_time = release_time;
    }

    public String getTotal_premium() {
        return total_premium;
    }

    public void setTotal_premium(String total_premium) {
        this.total_premium = total_premium;
    }

    public List<InsPreservationDetailVo> getInsPreservationDetailVoList() {
        return insPreservationDetailVoList;
    }

    public void setInsPreservationDetailVoList(List<InsPreservationDetailVo> insPreservationDetailVoList) {
        this.insPreservationDetailVoList = insPreservationDetailVoList;
    }
    public void resetName() {
        this.insPreservationDetailVoList = InsPreservationRecordVo.unescapeHtmlByName(this.insPreservationDetailVoList);
    }

    public static List<InsPreservationDetailVo> unescapeHtmlByName(List<InsPreservationDetailVo> insPreservationDetailVoList) {
        for(InsPreservationDetailVo ipdVo : insPreservationDetailVoList){
            if(StringUtils.isNotEmpty(ipdVo.getName())){
//					如果接收到被转义的字符串，同个下面代码能将被转的还原为原来字符
                ipdVo.setName(StringEscapeUtils.unescapeHtml4(ipdVo.getName()));
            }
        }
        return insPreservationDetailVoList;
    }

    public List<InsPreservationResultSetVo> getInsPreservationResultSetVoList() {
        return insPreservationResultSetVoList;
    }

    public void setInsPreservationResultSetVoList(List<InsPreservationResultSetVo> insPreservationResultSetVoList) {
        this.insPreservationResultSetVoList = insPreservationResultSetVoList;
    }

    public int getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(int serialNo) {
        this.serialNo = serialNo;
    }

    public Map getRecordRest() {
        return recordRest;
    }

    public void setRecordRest(Map recordRest) {
        this.recordRest = recordRest;
    }

    public String getComId() {
        return comId;
    }

    public void setComId(String comId) {
        this.comId = comId;
    }

    public String getPremium_change() {
        return premium_change;
    }

    public void setPremium_change(String premium_change) {
        this.premium_change = premium_change;
    }

    public String getTotal_amount() {
        return total_amount;
    }

    public void setTotal_amount(String total_amount) {
        this.total_amount = total_amount;
    }

    public String getAmount_change() {
        return amount_change;
    }

    public void setAmount_change(String amount_change) {
        this.amount_change = amount_change;
    }

    public Map<String, String> getBankMap() {
        return bankMap;
    }

    public void setBankMap(Map<String, String> bankMap) {
        this.bankMap = bankMap;
    }

    public String getE_invoice_url() {
        return e_invoice_url;
    }

    public void setE_invoice_url(String e_invoice_url) {
        this.e_invoice_url = e_invoice_url;
    }
}