package com.bcxin.ins.vo;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单模块 对外对接订单模块
 * Created by playboy on 2017/3/27.
 */

@TableName("ins_order_form")
public class    InsOrderFormRest extends InsInsuranceSlip {

    @TableField(exist=false)
    private static final long serialVersionUID = 1L;
    /**
     * 所属行业
     */
    @TableField(value = "channel")
    private String channel;

    /**
     * 活动名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     *省
     */
    @TableField(value = "province")
    private String province;

    /**
     * 市区
     */
    @TableField(value = "city")
    private String city;

    /**
     * 区域
     */
    @TableField(value = "district")
    private String district;

    /**
     * 场地
     */
    @TableField(value = "venue")
    private String venue;

    /**
     * 活动类型
     */
    @TableField(value = "type")
    private String type;

    /**
     * 人数
     */
    @TableField(value = "number")
    private String number;

    /**
     * 风评公司
     */
    @TableField(value = "assessment_org")
    private String assessmentOrg;

    /**
     * 餐饮公司
     */
    @TableField(value = "catering_org")
    private String cateringOrg;

    /**
     * 防爆公司
     */
    @TableField(value = "explode_org")
    private String explodeOrg;

    /**
     * 票务公司
     */
    @TableField(value = "ticket_org")
    private String ticketOrg;

    /**
     * 保安公司
     */
    @TableField(value = "security_org")
    private String securityOrg;

    /**
     * 场租公司
     */
    @TableField(value = "site_org")
    private String siteOrg;

    /**
     * 临建公司
     */
    @TableField(value = "stage_org")
    private String stageOrg;

    /**
     * 安检门公司
     */
    @TableField(value = "safetycheck_org")
    private String safetycheckOrg;

    /**
     * 监理公司
     */
    @TableField(value = "supervisor_org")
    private String supervisorOrg;

    /**
     * 承办方
     */
    @TableField(value = "contractor")
    private String contractor;

    /**
     *  成交时间
     */
    @TableField(value = "deal_date")
    private Date dealDate;

    /**
     *  申请时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 购买人
     */
    @TableField(value = "purchaser")
    private String purchaser;

    /**
     * 是否购买保险
     */
    @TableField(value = "buy_policy")
    private String buyPolicy;

    /**
     * 支付方式
     */
    @TableField(value = "payment_type")
    private String paymentType;

    /**
     * 支付日期
     */
    @TableField(value = "payment_date")
    private String paymentDate;

    /**
     * 支付期数
     */
    @TableField(value = "payment_stage")
    private String paymentStage;

    /**
     * 额外费用(分销费用)
     */
    @TableField(value = "fcy")
    private BigDecimal fcy;

    /**
     * 产品名称
     */
    @TableField(exist=false)
    private String productNames;

    /**
     * 产品类型
     */
    @TableField(exist=false)
    private String productType;

    /**
     * 有效期开始时间
     */
    @TableField(value = "start_date")
    private Date startDate;

    /**
     * 有效期结束时间
     */
    @TableField(value = "end_date")
    private Date endDate;

    /**
     * pss 订单状态_有效
     */
    public final static String INS_STATUS_EFFECTIVE="17";

    public BigDecimal getFcy() {
        return fcy;
    }

    public void setFcy(BigDecimal fcy) {
        this.fcy = fcy;
    }

    public String getPurchaser() {
        return purchaser;
    }

    public String getBuyPolicy() {
        return buyPolicy;
    }

    public void setBuyPolicy(String buyPolicy) {
        this.buyPolicy = buyPolicy;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public String getPaymentStage() {
        return paymentStage;
    }

    public void setPaymentStage(String paymentStage) {
        this.paymentStage = paymentStage;
    }

    public void setPurchaser(String purchaser) {
        this.purchaser = purchaser;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getDealDate() {
        return dealDate;
    }

    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getContractor() {
        return contractor;
    }

    public void setContractor(String contractor) {
        this.contractor = contractor;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProductNames() {
        return productNames;
    }

    public void setProductNames(String productNames) {
        this.productNames = productNames;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getVenue() {
        return venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getAssessmentOrg() {
        return assessmentOrg;
    }

    public void setAssessmentOrg(String assessmentOrg) {
        this.assessmentOrg = assessmentOrg;
    }

    public String getCateringOrg() {
        return cateringOrg;
    }

    public void setCateringOrg(String cateringOrg) {
        this.cateringOrg = cateringOrg;
    }

    public String getExplodeOrg() {
        return explodeOrg;
    }

    public void setExplodeOrg(String explodeOrg) {
        this.explodeOrg = explodeOrg;
    }

    public String getTicketOrg() {
        return ticketOrg;
    }

    public void setTicketOrg(String ticketOrg) {
        this.ticketOrg = ticketOrg;
    }

    public String getSecurityOrg() {
        return securityOrg;
    }

    public void setSecurityOrg(String securityOrg) {
        this.securityOrg = securityOrg;
    }

    public String getSiteOrg() {
        return siteOrg;
    }

    public void setSiteOrg(String siteOrg) {
        this.siteOrg = siteOrg;
    }

    public String getStageOrg() {
        return stageOrg;
    }

    public void setStageOrg(String stageOrg) {
        this.stageOrg = stageOrg;
    }

    public String getSafetycheckOrg() {
        return safetycheckOrg;
    }

    public void setSafetycheckOrg(String safetycheckOrg) {
        this.safetycheckOrg = safetycheckOrg;
    }

    public String getSupervisorOrg() {
        return supervisorOrg;
    }

    public void setSupervisorOrg(String supervisorOrg) {
        this.supervisorOrg = supervisorOrg;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}
