package com.bcxin.ins.util.enums;

import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 营业性质联动/二级：外资企业下分——外商独资/中外合资/中外合作
 */
public enum NatureLinkage {
	/** 机关*/
	OFFICE {public String getValue(){return "0";} public String getName(){return "机关";} public String getProvince(){return "";}},
	/** 事业单位*/
	CAUSE {public String getValue(){return "1";} public String getName(){return "事业单位";} public String getProvince(){return "";}},
	/** 社会团体*/
	GROUP {public String getValue(){return "2";} public String getName(){return "社会团体";} public String getProvince(){return "";}},
	/** 国有企业*/
	PUBLICZNO {public String getValue(){return "3";} public String getName(){return "国有企业";} public String getProvince(){return "";}},
	/** 民营企业*/
	PRIVATE {public String getValue(){return "4";} public String getName(){return "民营企业";} public String getProvince(){return "";}},
	/** 外资企业*/
	FOREIGN {public String getValue(){return "5";} public String getName(){return "外资企业";} public String getProvince(){return "";}},
	/** 国有独资*/
	SOLEPROPRIETORSHIP {public String getValue(){return "6";} public String getName(){return "国有独资";} public String getProvince(){return "3";}},
	/** 国有控股*/
	HOLDING {public String getValue(){return "7";} public String getName(){return "国有控股";} public String getProvince(){return "3";}},
	/** 国有联营*/
	JOINTOPERATION {public String getValue(){return "8";} public String getName(){return "国有联营";} public String getProvince(){return "3";}},
	/** 私营企业*/
	RACINGSHOES {public String getValue(){return "9";} public String getName(){return "私营企业";} public String getProvince(){return "4";}},
	/** 乡镇企业*/
	RURALTOWNSHIP {public String getValue(){return "10";} public String getName(){return "乡镇企业";} public String getProvince(){return "4";}},
	/** 个体企业*/
	INDIVIDUAL {public String getValue(){return "11";} public String getName(){return "个体企业";} public String getProvince(){return "4";}},
	/** 外商独资*/
	FOREIGNMERCHANT {public String getValue(){return "12";} public String getName(){return "外商独资";} public String getProvince(){return "5";}},
	/** 中外合资*/
	JOINTVENTURE {public String getValue(){return "13";} public String getName(){return "中外合资";} public String getProvince(){return "5";}},
	/** 中外合作*/
	COLLABORATION {public String getValue(){return "14";} public String getName(){return "中外合作";} public String getProvince(){return "5";}},
	/** 其他*/
	OTHER {public String getValue(){return "15";} public String getName(){return "其他";} public String getProvince(){return "";}};

	
    public abstract String getValue();
    
    public abstract String getName();

    public abstract String getProvince();

    public static List<NatureLinkage> doList(){
    	List<NatureLinkage> list = new ArrayList<NatureLinkage>();
		list.add(OFFICE);
		list.add(CAUSE);
		list.add(GROUP);
		list.add(PUBLICZNO);
		list.add(PRIVATE);
		list.add(FOREIGN);
		list.add(SOLEPROPRIETORSHIP);
		list.add(HOLDING);
		list.add(JOINTOPERATION);
		list.add(RACINGSHOES);
		list.add(RURALTOWNSHIP);
		list.add(INDIVIDUAL);
		list.add(FOREIGNMERCHANT);
		list.add(JOINTVENTURE);
		list.add(COLLABORATION);
		list.add(OTHER);
    	return list;
    }
    
    public static List<NatureLinkage> getListByProvince(String value){
		List<NatureLinkage> list = doList();
		List<NatureLinkage> screenList = new ArrayList<NatureLinkage>();
		for(NatureLinkage nlg : list){
			if(StringUtils.isNotEmpty(value)){
				if(nlg.getProvince().equals(value)){
					screenList.add(nlg);
				}
			}else{
				if(StringUtils.isEmpty(nlg.getProvince())){
					screenList.add(nlg);
				}
			}
		}
    	return screenList;
	}

	public static Map<String, String> getMapByProvince(String value){
		List<NatureLinkage> list = doList();
		Map<String, String> screenMap = Maps.newHashMap();
		for(NatureLinkage nlg : list){
			if(StringUtils.isNotEmpty(value)){
				if(nlg.getProvince().equals(value)){
					screenMap.put(nlg.getValue(),nlg.getName());
				}
			}else{
				if(StringUtils.isEmpty(nlg.getProvince())){
					screenMap.put(nlg.getValue(),nlg.getName());
				}
			}
		}
		return screenMap;
	}

	public static NatureLinkage get(String value){
		if(OFFICE.getValue().equals(value)){
			return OFFICE;
		}else if(CAUSE.getValue().equals(value)){
			return CAUSE;
		}else if(GROUP.getValue().equals(value)){
			return GROUP;
		}else if(PUBLICZNO.getValue().equals(value)){
			return PUBLICZNO;
		}else if(PRIVATE.getValue().equals(value)){
			return PRIVATE;
		}else if(FOREIGN.getValue().equals(value)){
			return FOREIGN;
		}else if(SOLEPROPRIETORSHIP.getValue().equals(value)){
			return SOLEPROPRIETORSHIP;
		}else if(HOLDING.getValue().equals(value)){
			return HOLDING;
		}else if(JOINTOPERATION.getValue().equals(value)){
			return JOINTOPERATION;
		}else if(RACINGSHOES.getValue().equals(value)){
			return RACINGSHOES;
		}else if(RURALTOWNSHIP.getValue().equals(value)){
			return RURALTOWNSHIP;
		}else if(INDIVIDUAL.getValue().equals(value)){
			return INDIVIDUAL;
		}else if(FOREIGNMERCHANT.getValue().equals(value)){
			return FOREIGNMERCHANT;
		}else if(JOINTVENTURE.getValue().equals(value)){
			return JOINTVENTURE;
		}else if(COLLABORATION.getValue().equals(value)){
			return COLLABORATION;
		}else if(OTHER.getValue().equals(value)){
			return OTHER;
		}
		return null;
	}
}
