package com.bcxin.ins.util.email;


import com.bcxin.ins.util.toolbox.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.internet.MimeMessage.RecipientType;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.util.*;


public class SendEmailAndMsgUtil {


    private volatile static SendEmailAndMsgUtil sendEmailAndMsgUtil;

    /**
     * 单列模式
     * @return
     */
    public static SendEmailAndMsgUtil getSendEmailAndMsgUtil() {
        if (sendEmailAndMsgUtil == null) {
            synchronized (SendEmailAndMsgUtil.class) {
                if (sendEmailAndMsgUtil == null) {
                    sendEmailAndMsgUtil = new SendEmailAndMsgUtil();
                }
            }
        }
        return sendEmailAndMsgUtil;
    }

    private SendEmailAndMsgUtil(){

    }

    private final static String CHARSET = "utf-8";

    private static String host;// 发送方邮箱所在的smtp主机
    private static String from;// 发送方邮箱
    private static String bcc;// 密送方邮箱
    private static String emailPassword;// 密码
    private static String bcxHead;
    private static String bcxFooter;

    private static Session session;

    private static String msgAccount = "";// 账户
    private static String msgPassword = "";// 密码
    private static String serviceURL = ""; //短信调用地址
    private static String up_serviceURL = ""; //短信上行调用地址
    private static String gasPolicy_path = ""; //燃气保险电子保单存放地址

    private static String sender_username = "";
    private static Transport transport;

    private static MimeMessage message;

    public String typeName;

    final static Logger logger = LoggerFactory.getLogger(SendEmailAndMsgUtil.class);

    static {
        ResourceBundle rb = ResourceBundle.getBundle("properties/config");
        host = rb.getString("mail_host");
        from = rb.getString("mail_from");
        bcc = rb.getString("mail_bcc");
        emailPassword = rb.getString("mail_password");
        bcxHead = rb.getString("mail_bcxHead");
        bcxFooter = rb.getString("mail_bcxFooter");

        serviceURL = rb.getString("msgServiceUrl");
        up_serviceURL = rb.getString("msgUpServiceUrl");
        msgAccount = rb.getString("msg_account");
        msgPassword = rb.getString("msg_pwd");

        Properties props = new Properties();
        props.put("mail.smtp.host", host);// 设置smtp主机
        props.put("mail.smtp.auth", "true");// 使用smtp身份验证
        session = Session.getInstance(props, null);
        message = new MimeMessage(session);
        sender_username = from;


    }

    public static void sendEmail(EmailModel emailModel) {
        if (emailModel.getTo() == null || emailModel.getTo().size() < 1) {
            return;
        }
        System.out.println("进入发送邮件方法=============");
        try{
            String content = "";
            if(StrUtil.isNotBlank(emailModel.getEmailType())) {
                content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
            }else{
                content=emailModel.getContent();
            }
            //设置SSL连接、邮件环境
            Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
            final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Properties props = System.getProperties();
            //协议
            //props.setProperty("mail.transport.protocol", "smtp");

            props.setProperty("mail.smtp.host", host);//smtp服务器地址
            //props.setProperty("mail.smtp.port", "25");//非加密端口
            // 使用ssl加密方式，进行如下配置：
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.setProperty("mail.smtp.ssl.enable", "true");
            //props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");//若默认版本失败，可以尝试指定版本

            props.setProperty("mail.smtp.auth", "true");//表示SMTP发送邮件，需要进行身份验证
            props.setProperty("mail.smtp.from", from);//mailfrom 参数
            props.setProperty("mail.user",from);//发件人的账号
            props.setProperty("mail.password",emailPassword);// 发件人的账号的密码，如果开启三方客户端安全密码请使用新生产的密码
            //建立邮件会话
            Session session = Session.getDefaultInstance(props, new Authenticator() {
                //身份认证
                protected PasswordAuthentication getPasswordAuthentication() {
                    //发件人的账号、密码
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            });
            //建立邮件对象
            MimeMessage message = new MimeMessage(session);
            //设置邮件的发件人
            InternetAddress ia = new InternetAddress(from,"百联保"); //from 参数,可实现代发，注意：代发容易被收信方拒信或进入垃圾箱。
            message.setFrom(ia);

            //设置邮件的收件人
            List list = new ArrayList();//不能使用string类型的类型，这样只能发送一个收件人
            for(String recipient : emailModel.getTo()) {
                list.add(new InternetAddress(recipient));
            }
            InternetAddress[] sendTo =(InternetAddress[])list.toArray(new InternetAddress[list.size()]);

            //传入收件人
            message.setRecipients(Message.RecipientType.TO,sendTo);
            //设置邮件的主题
            message.setSubject(emailModel.getSubject());
            //设置邮件的文本
            message.setContent(content,"text/html;charset=UTF-8");
            //设置时间
            message.setSentDate(new Date());
            message.saveChanges();
            //发送邮件
            Transport.send(message);
            System.out.println("发送成功！");
        }catch(Exception e){
            System.out.println("异常："+e.toString());
        }

    }

    public  static void sendPDFEmail(EmailModel emailModel, String proContNo) {
        if (emailModel.getTo() == null || emailModel.getTo().size() < 1) {
            return;
        }

        try {
            String typeName = "";
            String content = "";
            if(StrUtil.isNotBlank(emailModel.getEmailType())) {
                typeName = "百川信";// 发送方名称
                content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
            }
            //设置SSL连接、邮件环境
            Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
            final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Properties props = System.getProperties();
            //协议
            //props.setProperty("mail.transport.protocol", "smtp");

            props.setProperty("mail.smtp.host", host);//smtp服务器地址
            //props.setProperty("mail.smtp.port", "25");//非加密端口
            // 使用ssl加密方式，进行如下配置：
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.setProperty("mail.smtp.ssl.enable", "true");
            //props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");//若默认版本失败，可以尝试指定版本

            props.setProperty("mail.smtp.auth", "true");//表示SMTP发送邮件，需要进行身份验证
            props.setProperty("mail.smtp.from", from);//mailfrom 参数
            props.setProperty("mail.user",from);//发件人的账号
            props.setProperty("mail.password",emailPassword);// 发件人的账号的密码，如果开启三方客户端安全密码请使用新生产的密码
            //建立邮件会话
            Session session = Session.getDefaultInstance(props, new Authenticator() {
                //身份认证
                protected PasswordAuthentication getPasswordAuthentication() {
                    //发件人的账号、密码
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            });

            // Define message
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from, typeName));
            message.setSubject(emailModel.getSubject());
            Multipart multipart = new MimeMultipart();
            BodyPart bodyPart = new MimeBodyPart();

            bodyPart.setContent(content, "text/html;charset=UTF-8");
            multipart.addBodyPart(bodyPart);

            //加入附件
            if (proContNo != null) {
                pushPart(proContNo, multipart);
            }

            for(String filePath : emailModel.getFilePath()) {
                FileDataSource fds = new FileDataSource(filePath);
                BodyPart attachBodyPart = new MimeBodyPart();
                attachBodyPart.setDataHandler(new DataHandler(fds));

                attachBodyPart.setFileName(MimeUtility.encodeWord(fds.getName()));
                multipart.addBodyPart(attachBodyPart);
            }

            for(String recipient : emailModel.getTo()) {
                message.addRecipient(Message.RecipientType.TO, new InternetAddress(recipient));
            }
            message.setRecipient(RecipientType.BCC, new InternetAddress(bcc, typeName));

            message.setContent(multipart);
            message.saveChanges();
            //发送邮件
            Transport.send(message);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 加入附件 </b>
     * @author ZXF
     * @create 2020/09/28 0028 14:22
     * @version
     * @注意事项 </b>
     */
    private static void pushPart(String proContNo, Multipart multipart) throws MessagingException, UnsupportedEncodingException {
        File file = new File(gasPolicy_path, proContNo+".pdf");
        if(file.exists()){
            BodyPart bodyPart = new MimeBodyPart();
            DataSource datasource = new FileDataSource(file);
            bodyPart.setDataHandler(new DataHandler(datasource));
            bodyPart.setFileName(MimeUtility.encodeWord(proContNo + ".pdf","utf-8", null));
            multipart.addBodyPart(bodyPart);
        }else{
            String err = "投保单号："+proContNo + ("路径："+file.getAbsolutePath());
            logger.error("文件不存在，" + err);
        }
    }

    public static void main(String[] args) {
        try{
            //设置SSL连接、邮件环境
            Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
            final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Properties props = System.getProperties();
            //协议
            //props.setProperty("mail.transport.protocol", "smtp");

            props.setProperty("mail.smtp.host", "smtp.qiye.aliyun.com");//smtp服务器地址
            //props.setProperty("mail.smtp.port", "25");//非加密端口
            // 使用ssl加密方式，进行如下配置：
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.setProperty("mail.smtp.ssl.enable", "true");
            //props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");//若默认版本失败，可以尝试指定版本

            props.setProperty("mail.smtp.auth", "true");//表示SMTP发送邮件，需要进行身份验证
            props.setProperty("mail.smtp.from", "blbinsure@baichuanxin.com");//mailfrom 参数
            props.setProperty("mail.user","blbinsure@baichuanxin.com");//发件人的账号
            props.setProperty("mail.password","Bcx@666666");// 发件人的账号的密码，如果开启三方客户端安全密码请使用新生产的密码
            //建立邮件会话
            Session session = Session.getDefaultInstance(props, new Authenticator() {
                //身份认证
                protected PasswordAuthentication getPasswordAuthentication() {
                    //发件人的账号、密码
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            });
            //建立邮件对象
            MimeMessage message = new MimeMessage(session);
            //设置邮件的发件人
            InternetAddress from = new InternetAddress("blbinsure@baichuanxin.com","百联保"); //from 参数,可实现代发，注意：代发容易被收信方拒信或进入垃圾箱。
            message.setFrom(from);
            //设置邮件的收件人
            String[] to = {"blbservice@baichuanxin.com"};//收件人列表
            InternetAddress[] sendTo = new InternetAddress[to.length];
            for (int i=0;i<to.length;i++){
                //System.out.println("发送到：" + to[i]);
                sendTo[i] = new InternetAddress(to[i]);
            }

            //传入收件人
            message.setRecipients(Message.RecipientType.TO,sendTo);
            //设置邮件的主题
            message.setSubject("邮件主题");
            //设置邮件的文本
            String content="邮件内容-测试用";
            message.setContent(content,"text/html;charset=UTF-8");
            //设置时间
            message.setSentDate(new Date());
            message.saveChanges();
            //发送邮件
            Transport.send(message);
            System.out.println("发送成功！");
        }catch(Exception e){
            System.out.println("异常："+e.toString());
        }
    }

    public String getTypeName() {
        if(StrUtil.isBlank(typeName)){
            typeName="百联宝";
        }
        return typeName;
    }

    /**
     * 发送邮件
     *
     * @param subject
     *            邮件主题
     * @param sendHtml
     *            邮件内容
     * @param attachment
     *            附件
     */
    public  void doSendHtmlEmail(String subject, String sendHtml, List<String> receiveUsers, File attachment, List<String> ccUserList, List<String> bccUserList) {
        try {
            // 发件人
            InternetAddress from = new InternetAddress(sender_username);
            message.setFrom(from);

            if ( receiveUsers == null || receiveUsers.size() < 1) {
                return;
            }

            // 收件人
            InternetAddress[] receive =new InternetAddress[receiveUsers.size()];
            for(int i=0;i<receiveUsers.size() ; i++){
                receive[i] = new InternetAddress( receiveUsers.get(i));
            }
            message.setRecipients(Message.RecipientType.TO,receive);

            //抄送人
            if(ccUserList !=null && ccUserList.size() > 0){
                InternetAddress[] cc =new InternetAddress[ccUserList.size()];
                for(int i=0;i<ccUserList.size() ; i++){
                    cc[i] = new InternetAddress( ccUserList.get(i));
                }
                message.setRecipients(Message.RecipientType.CC,cc);
            }

            //密送人
            if(bccUserList !=null && bccUserList.size() > 0){
                InternetAddress[] bcc =new InternetAddress[bccUserList.size()];
                for(int i=0;i<bccUserList.size() ; i++){
                    bcc[i] = new InternetAddress( bccUserList.get(i));
                }
                message.setRecipients(Message.RecipientType.BCC,bcc);
            }
            // 邮件主题
            message.setSubject(subject);

            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);

            // 添加附件的内容
            if (attachment != null) {
                BodyPart attachmentBodyPart = new MimeBodyPart();
                DataSource source = new FileDataSource(attachment);
                attachmentBodyPart.setDataHandler(new DataHandler(source));

                // 网上流传的解决文件名乱码的方法，其实用MimeUtility.encodeWord就可以很方便的搞定
                // 这里很重要，通过下面的Base64编码的转换可以保证你的中文附件标题名在发送时不会变成乱码
                //sun.misc.BASE64Encoder enc = new sun.misc.BASE64Encoder();
                //messageBodyPart.setFileName("=?GBK?B?" + enc.encode(attachment.getName().getBytes()) + "?=");

                //MimeUtility.encodeWord可以避免文件名乱码
                attachmentBodyPart.setFileName(MimeUtility.encodeWord(attachment.getName()));
                multipart.addBodyPart(attachmentBodyPart);
            }

            // 将multipart对象放到message中
            message.setContent(multipart);
            // 保存邮件
            message.saveChanges();

            transport = session.getTransport("smtp");
            // smtp验证，就是你用来发邮件的邮箱用户名密码
            transport.connect(host, sender_username, emailPassword);
            // 发送
            transport.sendMessage(message, message.getAllRecipients());

            System.out.println("send success!");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (transport != null) {
                try {
                    transport.close();
                } catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 发送邮件
     *
     * @param subject
     *            邮件主题
     * @param sendHtml
     *            邮件内容
     * @param receiveUser
     *            收件人地址
     */
    public void sendEmail(String subject, String sendHtml, String receiveUser) {
        try {
            // 发件人
            InternetAddress from = new InternetAddress(sender_username);
            message.setFrom(from);

            if ( StrUtil.isBlank(receiveUser) ) {
                return;
            }
            // 收件人
            InternetAddress to = new InternetAddress(receiveUser);
            message.setRecipient(Message.RecipientType.TO, to);
            // 邮件主题
            message.setSubject(subject);
            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);
            // 将multipart对象放到message中
            message.setContent(multipart);
            // 保存邮件
            message.saveChanges();

            transport = session.getTransport("smtp");
            // smtp验证，就是你用来发邮件的邮箱用户名密码
            transport.connect(host, sender_username, emailPassword);
            // 发送
            transport.sendMessage(message, message.getAllRecipients());

            System.out.println("send success!");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (transport != null) {
                try {
                    transport.close();
                } catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    /**
     * 发送邮件
     *
     * @param subject
     *            邮件主题
     * @param sendHtml
     *            邮件内容
     * @param receiveUser
     *            收件人地址
     * @param attachment
     *            附件
     */
    public void doSendHtmlEmail(String subject, String sendHtml, String receiveUser, File attachment, List<String> bccUserList) {
        try {
            // 发件人
            InternetAddress from = new InternetAddress(sender_username);
            message.setFrom(from);

            if (StrUtil.isBlank(receiveUser) ) {
                return;
            }
            // 收件人
            InternetAddress to = new InternetAddress(receiveUser);
//            if(bccUserList !=null && bccUserList.size() > 0){
//	            InternetAddress[] cc =new InternetAddress[bccUserList.size()];
//	            for(int i=0;i<bccUserList.size() ; i++){
//	            	cc[i] = new InternetAddress( bccUserList.get(i));
//	            }
//	            message.setRecipients(Message.RecipientType.CC,cc);
//            }
            message.setRecipient(Message.RecipientType.TO, to);

            /*InternetAddress bcc = new InternetAddress("linqinglin@bcxin.com.cn");
            message.setRecipient(Message.RecipientType.BCC, bcc);*/
            // 邮件主题
            message.setSubject(subject);

            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);

            // 添加附件的内容
            if (attachment != null) {
                BodyPart attachmentBodyPart = new MimeBodyPart();
                DataSource source = new FileDataSource(attachment);
                attachmentBodyPart.setDataHandler(new DataHandler(source));

                // 网上流传的解决文件名乱码的方法，其实用MimeUtility.encodeWord就可以很方便的搞定
                // 这里很重要，通过下面的Base64编码的转换可以保证你的中文附件标题名在发送时不会变成乱码
                //sun.misc.BASE64Encoder enc = new sun.misc.BASE64Encoder();
                //messageBodyPart.setFileName("=?GBK?B?" + enc.encode(attachment.getName().getBytes()) + "?=");

                //MimeUtility.encodeWord可以避免文件名乱码
                attachmentBodyPart.setFileName(MimeUtility.encodeWord(attachment.getName()));
                multipart.addBodyPart(attachmentBodyPart);
            }

            // 将multipart对象放到message中
            message.setContent(multipart);
            // 保存邮件
            message.saveChanges();

            transport = session.getTransport("smtp");
            // smtp验证，就是你用来发邮件的邮箱用户名密码
            transport.connect(host, sender_username, emailPassword);
            // 发送
            transport.sendMessage(message, message.getAllRecipients());

            System.out.println("send success!");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (transport != null) {
                try {
                    transport.close();
                } catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }



}
