package com.bcxin.ins.util;


import com.bcxin.ins.spring.security.Digests;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


public class Sha1Util {


	private static Logger log = LogManager.getLogger(Sha1Util.class);
	public static final String HASH_ALGORITHM = "SHA-1";
	public static final int HASH_INTERATIONS = 1024;
	public static final int SALT_SIZE = 8;

	/**
	 * 生成安全的密码，生成随机的16位salt并经过1024次 sha-1 hash
	 */

	public static String entryptPassword(String plainPassword) {
		String plain = Encodes.unescapeHtml(plainPassword);
		byte[] salt = Digests.generateSalt(SALT_SIZE);
		byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, HASH_INTERATIONS);
		return Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword);
	}

	/**
	 * 验证密码
	 *
	 * @param plainPassword
	 *            明文密码
	 * @param password
	 *            密文密码
	 * @return 验证成功返回true
	 */

	public static boolean validatePassword(String plainPassword, String password) {
		String plain = Encodes.unescapeHtml(plainPassword);
		byte[] salt = Encodes.decodeHex(password.substring(0, 16));
		byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, HASH_INTERATIONS);
		return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
	}




	public static void main(String[] args) {
		String password ="123456";
		System.out.printf(Sha1Util.entryptPassword(password));
		String  code="6257b4cd2da410a43b758e2054f18a04823fd01a33e2ea5089653778";
		System.out.printf("值是否相同"+Sha1Util.validatePassword(password,code));

	}

//    public static void main(String[] args) {
//        String str1 = "abcdefghijklmnabc";
//        // 从头开始查找是否存在指定的字符
//        log.info(str1.indexOf("a"));
//        // 从第四个字符位置开始往后继续查找
//        log.info(str1.indexOf("c", 3));
//        //若指定字符串中没有该字符则系统返回-1
//        log.info(str1.indexOf("x"));
//    }
}
