package com.bcxin.ins.util;


import com.bcxin.ins.obs.OBSUtil;
import com.bcxin.ins.oss.OSSServiceExecutor;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.google.common.io.Files;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import com.bcxin.ins.vo.ConstProp;
import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import static com.google.common.base.Preconditions.checkNotNull;

public class OSSFileUtil {
	private static MyAsyncExecutor myAsyncExecutor;

	private static Logger logger = LoggerFactory.getLogger(OSSFileUtil.class);

	/**
	 * 默认文件上传路径
	 */
	private final static String DEFAULT_UPLOAD_DIR = "upload";

	private final static String DEFAULT_UPLOAD_LINUX = "/data/upload/blb/";

	public void setMyAsyncExecutor(MyAsyncExecutor myAsyncExecutor) {
		OSSFileUtil.myAsyncExecutor = myAsyncExecutor;
	}
	
	/**
	 * @param materialFile
	 * @param directoryName
	 * @param radomFile
	 * @param customFileName  (abc)
	 * @return
	 */
	public static Map<String,String> ossFileUpload(MultipartFile materialFile, String directoryName, boolean radomFile, String customFileName){
		Map<String,String> map = new HashMap<String,String>();
		String materialFileName = materialFile.getOriginalFilename(); // a.jpg
		String fileType = StringUtils.substringAfterLast(materialFileName, ConstProp.DOT).toLowerCase(); // jpg
		String fileName = ConstProp.BLANK_CHAR;
		if ( radomFile ) {
			String radomNumber = DateUtil.generatorRadomNumber(); // 12345
			fileName = radomNumber + ConstProp.DOT + fileType; // 12345.jpg
		} else {
			fileName = customFileName;
		}
		String ossKey = directoryName + fileName;
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
		try {
			if ( !ossExecutor.isExitsDirectory(directoryName) ) {
				ossExecutor.createDirectory(directoryName);
			}
			myAsyncExecutor.execute(()->{ //异步上传处理
				try {
					ossExecutor.put(ossKey, materialFile.getInputStream(), true);
				} catch(Exception e) {

				}
			});

			String url = ossExecutor.getServer() + ossKey;
			map.put("url", url);
			map.put("key", ossKey);
		} catch ( Exception e) {
			
		} 
		return map;
	}
	
	
	/**
	 * @param materialFile
	 * @param directoryName
	 * @param radomFile
	 * @param customFileName  (abc)
	 * @return
	 */
	public static Map<String,String> ossFileUpload_sysc(MultipartFile materialFile, String directoryName, boolean radomFile, String customFileName){
		Map<String,String> map = new HashMap<String,String>();
		String materialFileName = materialFile.getOriginalFilename(); // a.jpg
		String fileType = StringUtils.substringAfterLast(materialFileName, ConstProp.DOT).toLowerCase(); // jpg
		String fileName = ConstProp.BLANK_CHAR;
		if ( radomFile ) {
			String radomNumber = DateUtil.generatorRadomNumber(); // 12345
			fileName = radomNumber + ConstProp.DOT + fileType; // 12345.jpg
		} else {
			fileName = customFileName;
		}
		String ossKey = directoryName + fileName;
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
		try {
			if ( !ossExecutor.isExitsDirectory(directoryName) ) {
				ossExecutor.createDirectory(directoryName);
			}
			try {
				ossExecutor.put(ossKey, materialFile.getInputStream(), true);
			} catch(Exception e) {
				
			}
			
			String url = ossExecutor.getServer() + ossKey;
			map.put("url", url);
			map.put("key", ossKey);
		} catch ( Exception e) {
			
		} 
		return map;
	}
	
	
	/**异步
	 * @param materialFile
	 * @param directoryName
	 * @param radomFile
	 * @param customFileName  (abc)
	 * @return
	 */
	public static Map<String,String> ossFileUpload(File materialFile,String directoryName,boolean radomFile,String customFileName){
		Map<String,String> map = new HashMap<String,String>();
		String materialFileName = materialFile.getName(); // a.jpg
		String fileType = StringUtils.substringAfterLast(materialFileName, ConstProp.DOT).toLowerCase(); // jpg
		String fileName = ConstProp.BLANK_CHAR;
		if ( radomFile ) {
			String radomNumber = DateUtil.generatorRadomNumber(); // 12345
			fileName = radomNumber + ConstProp.DOT + fileType; // 12345.jpg
		} else {
			fileName = customFileName;
		}
		String ossKey = directoryName + ConstProp.SLASH + fileName;
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
		try {
			if ( !ossExecutor.isExitsDirectory(directoryName) ) {
				ossExecutor.createDirectory(directoryName);
			}
			myAsyncExecutor.execute(()->{ //异步上传处理
				try {
					ossExecutor.put(ossKey, materialFile, true);
				} catch(Exception e) {
					
				}
			});
			
			String url = ossExecutor.getServer() + ossKey;
			map.put("url", url);
			map.put("key", ossKey);
		} catch ( Exception e) {
			
		} 
		return map;
	}
	
	/**同步
	 * @param materialFile
	 * @param directoryName
	 * @param radomFile
	 * @param customFileName  (abc)
	 * @return
	 */
	public static Map<String,String> ossFileUpload_sync(File materialFile,String directoryName,boolean radomFile,String customFileName){
		Map<String,String> map = new HashMap<String,String>();
		String materialFileName = materialFile.getName(); // a.jpg
		String fileType = StringUtils.substringAfterLast(materialFileName, ConstProp.DOT).toLowerCase(); // jpg
		String fileName = ConstProp.BLANK_CHAR;
		if ( radomFile ) {
			String radomNumber = DateUtil.generatorRadomNumber(); // 12345
			fileName = radomNumber + ConstProp.DOT + fileType; // 12345.jpg
		} else {
			fileName = customFileName;
		}
		String ossKey = directoryName + ConstProp.SLASH + fileName;
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
		try {
			if ( !ossExecutor.isExitsDirectory(directoryName) ) {
				ossExecutor.createDirectory(directoryName);
			}
			try {
				ossExecutor.put(ossKey, materialFile, true);
			} catch(Exception e) {
				
			}
			
			String url = ossExecutor.getServer() + ossKey;
			map.put("url", url);
			map.put("key", ossKey);
		} catch ( Exception e) {
			
		} 
		return map;
	}
	
	
	/**
	 * 
	 * @param base64Str
	 * @param directoryName
	 * @param customFileName (a.jpg)
	 * @return
	 */
	public static Map<String,String> ossFileUpload(String base64Str,String directoryName,String customFileName){
		Map<String,String> map = new HashMap<String,String>();
		String fileType = StringUtils.substringAfterLast(customFileName, ConstProp.DOT).toLowerCase(); // a.jpg
		String fileName = customFileName;
		String ossKey = directoryName + ConstProp.SLASH + fileName;
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
		try {
			if ( !ossExecutor.isExitsDirectory(directoryName) ) {
				ossExecutor.createDirectory(directoryName);
			}
			myAsyncExecutor.execute(()->{ //异步上传处理
				try {
					ossExecutor.put(ossKey, BaseToInputStream(base64Str), true);
				} catch(Exception e) {
					
				}
			});
			
			String url = ossExecutor.getServer() + ossKey;
			map.put("url", url);
			map.put("key", ossKey);
		} catch ( Exception e) {
			e.printStackTrace();
		} 
		return map;
	}

	/**
	 *
	 * @param base64Str
	 * @param directoryName
	 * @param customFileName (a.jpg)
	 * @return
	 */
	public static Map<String,String> ossFileUpload_sync(String base64Str,String directoryName,String customFileName){
		Map<String,String> map = new HashMap<String,String>();
		String fileType = StringUtils.substringAfterLast(customFileName, ConstProp.DOT).toLowerCase(); // a.jpg
		String fileName = customFileName;
		String ossKey = directoryName + ConstProp.SLASH + fileName;
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
		try {
			if ( !ossExecutor.isExitsDirectory(directoryName) ) {
				ossExecutor.createDirectory(directoryName);
			}
			ossExecutor.put(ossKey, BaseToInputStream(base64Str), true);
			String url = ossExecutor.getServer() + ossKey;
			map.put("url", url);
			map.put("key", ossKey);
		} catch ( Exception e) {
			e.printStackTrace();
		}
		return map;
	}

	public static void ossFileDownload(String key,String fileName,HttpServletResponse response){
	    try {
	    	OSSServiceExecutor ossExecutor = new OSSServiceExecutor(false);
			String filenameEncode= URLEncoder.encode(fileName.replace(com.bcxin.ins.vo.ConstProp.SLASH,"_"),"utf-8");
			File file = ossExecutor.get(key,fileName.replace(com.bcxin.ins.vo.ConstProp.SLASH,"_"));

	    	response.reset();
	    	response.setHeader("Content-Disposition", "attachment; filename="+filenameEncode);
	    	response.setContentType("application/octet-stream; charset=utf-8");  
	        response.setHeader("Content-Length", String.valueOf(file.length()));
	  		try(BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
				BufferedOutputStream bos = new BufferedOutputStream(response.getOutputStream());){
				byte[] buff = new byte[2048];
				int bytesRead;
				while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
					bos.write(buff, 0, bytesRead);
				}
			}catch (Exception e){
	  			e.printStackTrace();
			}
	    } catch (IOException e) {
			e.printStackTrace();
			logger.error("文件下载出现异常：",e);
		}
	}

	/**
	 *
	 * @param base64Str
	 * @param dir
	 * @param fileName (a.jpg)
	 * @return
	 */
	public static String huaweiOBSFileUpload_base64(String base64Str,String dir,String fileName){
		if(StringUtils.isNotEmpty(dir)){
			dir = dir.startsWith("/")?dir:"/"+dir;
			dir = dir.endsWith("/")?dir.substring(0,dir.length()-1):dir;
		}
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/";
		String ossKey = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
		OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try (InputStream inputStream = BaseToInputStream(base64Str)) {
			return obsUtil.put(directoryName, ossKey, inputStream);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("huaweiOBSFileUpload_base64:"+e.getMessage(), e);
		}
		return "";
	}

	/**
	 * 华为OBS文件上传存储（同步）
	 *
	 * @return
	 */
	public static String huaweiOBSFileUpload(MultipartFile xFile, String dir) {
		/* 获得文件后缀名 jpg*/
		String fileType = Files.getFileExtension(xFile.getOriginalFilename());
		/* 生成随机文件名 12345*/
		String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
		String fileName = randomNumber + ConstProp.DOT + fileType;
		if(StringUtils.isNotEmpty(dir)){
			dir = dir.startsWith("/")?dir:"/"+dir;
			dir = dir.endsWith("/")?dir.substring(0,dir.length()-1):dir;
		}
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/";
		String ossKey = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
		OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try (InputStream inputStream = xFile.getInputStream()) {
			return obsUtil.put(directoryName, ossKey, inputStream);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("huaweiOBSFileUpload:"+e.getMessage(), e);
		}
		return "";
	}

	/**
	 * <b> 华为OBS文件上传存储（base64） </b>
	 * @param base64Str 文件
	 * @param fileType 后缀
	 * @param dir 存放目录
	 * @param sign 文件名中标识
	 * @author ZXF
	 * @create 2024/05/23 0023 13:50
	 * @version
	 * @注意事项 </b>
	 */
	public static String huaweiOBSFileUpload_base64(String base64Str, String fileType, String dir, String sign){
		// 参数校验
		if (StringUtils.isEmpty(base64Str) || StringUtils.isEmpty(fileType)) {
			logger.warn("上传参数为空: base64Str={}, fileType={}", base64Str, fileType);
			return "";
		}
		/* 生成随机文件名 12345*/
		String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers(6)+sign;
		/* 组装成随机文件名称 12345.jpg */
		String fileName = randomNumber + ConstProp.DOT + fileType;
		if(StringUtils.isNotEmpty(dir)){
			dir = dir.startsWith("/")?dir:"/"+dir;
			dir = dir.endsWith("/")?dir.substring(0,dir.length()-1):dir;
		}
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/";
		String ossKey = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
		OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try (InputStream inputStream = BaseToInputStream(base64Str)) {
			return obsUtil.put(directoryName, ossKey, inputStream);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("huaweiOBSFileUpload_base64:"+e.getMessage(), e);
		}
		return "";
	}

	public static String huaweiOBSFileUpload(InputStream inputStream, String dir, String fileType) {
		/* 生成随机文件名 12345*/
		String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
		String fileName = randomNumber + ConstProp.DOT + fileType;
		if(StringUtils.isNotEmpty(dir)){
			dir = dir.startsWith("/")?dir:"/"+dir;
			dir = dir.endsWith("/")?dir.substring(0,dir.length()-1):dir;
		}
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/";
		String ossKey = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
		OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try {
			return obsUtil.put(directoryName, ossKey, inputStream);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("huaweiOBSFileUpload:"+e.getMessage(), e);
		}
		return "";
	}

	/**
	 * 华为OBS文件上传存储（同步）
	 *
	 * @return
	 */
	public static String huaweiOBSFileUpload(File file, String fileType, String dir) {

		/* 生成随机文件名 12345*/
		String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
		String fileName = randomNumber + ConstProp.DOT + fileType;
		if(StringUtils.isNotEmpty(dir)){
			dir = dir.startsWith("/")?dir:"/"+dir;
			dir = dir.endsWith("/")?dir.substring(0,dir.length()-1):dir;
		}
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/";
		String ossKey = DEFAULT_UPLOAD_DIR+ dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
		OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try (InputStream inputStream = FileUtil.getInputStream(file)) {
			return obsUtil.put(directoryName, ossKey, inputStream);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("huaweiOBSFileUpload(envi:"+GlobalResources.IS_TEST_ENVI+",fileType:"+fileType+",obsUtil:"+(obsUtil==null?"null":"not null")+"):"+e.getMessage(), e);
		}
		return "";
	}

	/**
	 * 华为OBS文件上传存储（本地文件上传到华为公共云）
	 *
	 * @return
	 */
	public static String huaweiLocalFileUpload(File file, String date, String dir) {
		if(StringUtils.isNotEmpty(dir)){
			dir = dir.startsWith("/")?dir:"/"+dir;
			dir = dir.endsWith("/")?dir.substring(0,dir.length()-1):dir;
		}
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR+ dir + "/" + date + "/";
		String ossKey = DEFAULT_UPLOAD_DIR+ dir + "/" + date + "/" + file.getName();
		OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try (InputStream inputStream = FileUtil.getInputStream(file)) {
			return obsUtil.put(directoryName, ossKey, inputStream);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("huaweiLocalFileUpload:"+e.getMessage(), e);
		}
		return "";
	}

	/**
	 * <b> 根据oss生成的url反解析获取IO流 </b>
	 * @author ZXF
	 * @create 2020/05/09 0009 16:29
	 * @version
	 * @注意事项 </b>
	 */
	public static InputStream getInputStreamByUrl(String url) throws FileNotFoundException {
		if(StringUtils.isNotEmpty(url)){
			try {
				String fileType = url.substring(url.length()-3,url.length());
				OSSServiceExecutor ossExecutor = new OSSServiceExecutor(ConstProp.IMAGE_FORM.contains(fileType));
				String key = url.replace(ossExecutor.getServer(),"");
				return getInputStreamByKey(key);
			} catch ( Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	public static InputStream getInputStreamByKey(String key) throws FileNotFoundException {
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(false);
		File file = ossExecutor.get(key,key.replace(com.bcxin.ins.vo.ConstProp.SLASH,"_"));
		return new BufferedInputStream(new FileInputStream(file));
	}

	public static boolean ossFileDelete(String key){
		OSSServiceExecutor ossExecutor = new OSSServiceExecutor(false);
		return ossExecutor.deleteFile(key);
	}

	public static void ossFileDelete_sync(String key){
		myAsyncExecutor.execute(()->{ //异步删除
			ossFileDelete(key);
		});
	}
	public static String downZip(List<String> filePaths, String zipBasePath, String zipName, HttpServletResponse response) {
		byte[] buffer = new byte[1024];
		String strZipPath = zipBasePath + com.bcxin.ins.vo.ConstProp.SLASH + zipName;
		try(ZipOutputStream out = new ZipOutputStream(new FileOutputStream(strZipPath));) {

			List<File> files = new ArrayList<File>();
			for (String filePath : filePaths) {
				File policyFile = new File(filePath);
				files.add(policyFile);
			}

			for (File file : files) {
				try(FileInputStream fis = new FileInputStream(file);) {
					out.putNextEntry(new ZipEntry(file.getName()));
					// 设置压缩文件内的字符编码，不然会变成乱码

					int len;
					// 读入需要下载的文件的内容，打包到zip文件
					while ((len = fis.read(buffer)) > 0) {
						out.write(buffer, 0, len);
					}
					out.closeEntry();
				}catch (Exception e){
					e.printStackTrace();
				}
			}
			downloadFile(strZipPath, zipName, response);
			
			for (File file : files) {
				if (file.isFile() && file.exists()) {
					try {
						java.nio.file.Files.delete(file.toPath());
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}

	public static void downloadFile(String fileName, String downloadName, HttpServletResponse response){
		response.setContentType("octets/stream");
		response.addHeader("Content-Type", "text/html; charset=utf-8");
		String downLoadName = "";
		try {
			downLoadName = new String(downloadName.getBytes("gbk"), "iso8859-1");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
		try(FileInputStream fileInputStream = new FileInputStream(fileName);
			OutputStream out = response.getOutputStream();) {
			int i = 0;
			while ((i = fileInputStream.read()) != -1) {
				out.write(i);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 上传文件
	 * 
	 * @param file
	 *            文件
	 * @param radomfileName
	 *            保存文件名
	 * @param materialFilePath
	 *            保存路径
	 * @return
	 */
	public static boolean fileUpload(MultipartFile file, String radomfileName,
                                     String materialFilePath) {
		boolean flag = true;
		File baseFile = new File(materialFilePath);
		File trainFile = new File(baseFile, radomfileName);
		if (!baseFile.exists()) {
			baseFile.mkdirs();
		}
		try {
			file.transferTo(trainFile);
		} catch (IllegalStateException e) {
			flag = false;
		} catch (IOException e) {
			flag = false;
		}// 保存文件
		return flag;
	}

	/**
	 * 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
	 * 
	 * @param imgFile
	 *            待处理的图片路径
	 * @return
	 * @throws Exception
	 */
	public static String getImageStr(String imgFile) throws Exception {
		byte[] data = null;
		// 读取图片字节数组
		try(InputStream in = new FileInputStream(imgFile);) {
			data = new byte[in.available()];
			in.read(data);
		} catch (IOException e) {
			e.printStackTrace();
		}
		// 对字节数组Base64编码
		String back = BASE64Util.encryptBASE64Byte(data);
		System.out.println(back);
		return back;// 返回Base64编码过的字节数组字符串
	}

	
	/**
	 * base64转inputStream
	 * @param base64string
	 * @return
	 */
	private static InputStream BaseToInputStream(String base64string){  
	    ByteArrayInputStream stream = null;
		try {
		    byte[] bytes1 = BASE64Util.decryptBASE64Byte(base64string);  
		    stream = new ByteArrayInputStream(bytes1);  
		} catch (Exception e) {
		// TODO: handle exception
		}
	        return stream;  
	    } 

	
	/**
	 * 对字节数组字符串进行Base64解码并生成图片
	 * 
	 * @param imgStr
	 *            字节数组字符串
	 * @param imgFile
	 *            输入文件路径
	 * @return
	 * @throws Exception
	 */
	public static boolean generateImage(String imgStr, String imgFile)
			throws Exception {
		if (StringUtils.isEmpty(imgStr)) {// 图像数据为空
			return false;
		}
		// Base64解码
		byte[] b = BASE64Util.decryptBASE64Byte(imgStr);
		for (int i = 0; i < b.length; ++i) {
			if (b[i] < 0) {// 调整异常数据
				b[i] += 256;
			}
		}
		// 生成jpeg图片
		String imgFilePath = imgFile;// 新生成的图片
		File file = new File(imgFilePath);
		file.getParentFile().mkdirs();
		try(OutputStream out = new FileOutputStream(imgFilePath);) {
			out.write(b);
			out.flush();
			return true;
		} catch (Exception e) {
			throw e;
		}
	}

	// 下载url文件
	public static void download(String urlString, String filename,
			String savePath) throws Exception {
		// 构造URL
		URL url = new URL(urlString);
		// 打开连接
		URLConnection con = url.openConnection();
		// 设置请求超时为5s
		con.setConnectTimeout(5 * 1000);

		// 1K的数据缓冲
		byte[] bs = new byte[1024];
		// 读取到的数据长度
		int len;
		// 输出的文件流
		File sf = new File(savePath);
		if (!sf.exists()) {
			sf.mkdirs();
		}
		try(InputStream is = con.getInputStream();
			OutputStream os = new FileOutputStream(sf.getPath() + com.bcxin.ins.vo.ConstProp.SLASH + filename);){
			// 开始读取
			while ((len = is.read(bs)) != -1) {
				os.write(bs, 0, len);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	/**
	 * 
	 * @param basePath
	 *            服务器地址
	 * @param resourcePath
	 *            文件读取的地址
	 * @param baseFile
	 *            base64
	 * @return
	 * @throws Exception
	 */
	public String mkdirsFile(String basePath, String resourcePath,
			String baseFile) throws Exception {
		String pathStr = "";
		if (StringUtils.isNotEmpty(baseFile)) {

			String str1 = baseFile.split(",")[0];
			String str1_1 = str1.split(";")[0];
			String imgType = str1_1.split(com.bcxin.ins.vo.ConstProp.SLASH)[1];
			String str2 = baseFile.split(",")[1];
			byte[] bytes = BASE64Util.decryptBASE64Byte(str2);
			BufferedOutputStream bos = null;
			FileOutputStream fos = null;
			File file = null;
			try {
				File dir = new File(basePath);
				if (!dir.exists()) {
					dir.mkdirs();
				}
				String fileName = DateUtil.generatorRadomNumber();
				String pathStrLI = basePath + fileName + "." + imgType;
				pathStr = resourcePath + fileName + "." + imgType;
				file = new File(pathStrLI);
				fos = new FileOutputStream(file);
				bos = new BufferedOutputStream(fos);
				bos.write(bytes);
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (bos != null) {
					try {
						bos.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
				if (fos != null) {
					try {
						fos.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}

		return pathStr;
	}

	/**
    * 演示向文件中写入字节流
    * 
    * @param fileName 要写入文件的文件名
    * @param contents 要写入的文件内容
    */
	public static void fileWrite(final String fileName, final String contents){
		checkNotNull(fileName, "文件不能为空");
		checkNotNull(contents, "Unable to write null contents.");
		final File newFile = new File(fileName);
		try {
			Files.write(contents.getBytes(), newFile);
		} catch (IOException fileIoEx) {
//			err.println("ERROR trying to write to file '" + fileName + "' - "+ fileIoEx.toString());
		}
//		System.out.println(s);
		System.out.println("running here");
	}
	
//	private 
	
	/*
	 * 复制单个文件
	 * 
	 * @param oldPath String 原文件路径 如：c:/fqf.txt
	 * 
	 * @param newPath String 复制后路径 如：f:/fqf.txt
	 * 
	 * @return boolean
	 */
	public static void copyFile(String oldPath, String newPath) {
		int bytesum = 0;
		int byteread = 0;
		File oldfile = new File(oldPath);
		// 文件存在时
		if (oldfile.exists()) {
			try(InputStream inStream = new FileInputStream(oldPath);
				FileOutputStream fs = new FileOutputStream(newPath);) {
				byte[] buffer = new byte[1444];
				while ((byteread = inStream.read(buffer)) != -1) {
					// 字节数 文件大小
					bytesum += byteread;
					fs.write(buffer, 0, byteread);
				}
			} catch (Exception e) {
				System.out.println("复制单个文件操作出错");
				e.printStackTrace();
			}
		}
	}
	
}
