package com.bcxin.ins.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
/**
 * 简单的方法
 * @author lyq
 *
 */
public class MathUtil {

    private static Logger log = LogManager.getLogger(MathUtil.class);

    public static String getRandomCode(){
        String n="";
        try {
            Random rd = new Random();
            int getNum;
            do {
                //产生数字0-9的随机数
                getNum = Math.abs(rd.nextInt())%10 + 48;
                //产生字母a-z的随机数
                //getNum = Math.abs(rd.nextInt())%26 + 97;
                char num1 = (char)getNum;
                String dn = Character.toString(num1);
                n += dn;
            } while (n.length()<6);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return n;
    }

    public static String getUserNum(int count){
        StringBuffer sb = new StringBuffer();
        String str = "0123456789";
        try {
            Random r = new Random();
            for(int i=0;i<count;i++){
                int num = r.nextInt(str.length());
                sb.append(str.charAt(num));
                str = str.replace((str.charAt(num)+""), "");
            }
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static boolean checkEmail(String email){
        boolean flag = false;
        try{
            String check = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            flag = matcher.matches();
        }catch(Exception e){
            flag = false;
        }
        return flag;
    }

    /**
     * 验证手机号是否合法
     * @return
     */
    public static boolean isMobileNO(String mobile){
        return ValidatorUtil.validateMobile(mobile);
//        if (mobile.length() != 11)
//        {
//            return false;
//        }else{
//            /**
//             * 移动号段正则表达式
//             */
//            String pat1 = "^((13[4-9])|(147)|(15[0-2,7-9])|(178)|(18[2-4,7-8]))\\d{8}|(1705)\\d{7}$";
//            /**
//             * 联通号段正则表达式
//             */
//            String pat2  = "^((13[0-2])|(145)|(15[5-6])|(176)|(18[5,6]))\\d{8}|(1709)\\d{7}$";
//            /**
//             * 电信号段正则表达式
//             */
//            String pat3  = "^((133)|(153)|(177)|(18[0,1,9])|(149))\\d{8}$";
//            /**
//             * 虚拟运营商正则表达式
//             */
//            String pat4 = "^((170))\\d{8}|(1718)|(1719)\\d{7}$";
//
//            Pattern pattern1 = Pattern.compile(pat1);
//            Matcher match1 = pattern1.matcher(mobile);
//            boolean isMatch1 = match1.matches();
//            if(isMatch1){
//                return true;
//            }
//            Pattern pattern2 = Pattern.compile(pat2);
//            Matcher match2 = pattern2.matcher(mobile);
//            boolean isMatch2 = match2.matches();
//            if(isMatch2){
//                return true;
//            }
//            Pattern pattern3 = Pattern.compile(pat3);
//            Matcher match3 = pattern3.matcher(mobile);
//            boolean isMatch3 = match3.matches();
//            if(isMatch3){
//                return true;
//            }
//            Pattern pattern4 = Pattern.compile(pat4);
//            Matcher match4 = pattern4.matcher(mobile);
//            boolean isMatch4 = match4.matches();
//            if(isMatch4){
//                return true;
//            }
//            return false;
//        }
    }



    public static String getType(String email){
        if(isMobileNO(email)){
            return   Constant.USER_TYPE_MOBILE;
        }else  if(checkEmail(email)){
            return   Constant.USER_TYPE_EMAIL;
        }else {
            return  Constant.USER_TYPE_NAME;
        }
    }

    public static void main(String[] args) {
        System.out.println(getUserNum(6));
//        String  json ="{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1494307726824\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"{\\\"barCode\\\":\\\"9041K009838136\\\",\\\"fromPartnerId\\\":\\\"PAEGISNBU001\\\",\\\"realFromPartnerId\\\":\\\"PCXM001\\\",\\\"receiptNo\\\":\\\"30000070075779085\\\",\\\"responseMsg\\\":\\\"AMESB接口InsuredAMESBService调用成功！\\\",\\\"returnFlag\\\":\\\"1\\\",\\\"totalPremium\\\":\\\"510\\\"}\"}";
//
//
//
//        log.info(MathUtil.getUserNum(6));
    }
}
