package com.bcxin.ins.util;

import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtil {
	private static Logger log = LoggerFactory.getLogger(DateUtil.class);
	public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
	public static final String FORMAT1_1 = "yyyy-MM-dd HH:mm";
	public static final String FORMAT1_2 = "yyyyMMddHHmmss";
	public static final String FORMAT2 = "yyyy-MM-dd";
	public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
	public static final String FORMAT4 = "MM/dd/yyyy";
	public static final String FORMAT5 = "HH:mm:ss";
	public static final String FORMAT6 = "yyyyMMdd";
	public static final String FORMAT7 = "HH";

	/**
	 * 年
	 */
	public static final int DATATYPE_YEAR = 1;
	
	/**
	 * 月
	 */
	public static final int DATATYPE_MONTH = 2;
	
	/**
	 * 日
	 */
	public static final int DATATYPE_DAY = 3;
	
	/**
	 * 小时
	 */
	public static final int DATATYPE_HOUR = 4;
	
	/**
	 * 分钟
	 */
	public static final int DATATYPE_MINUTE = 5;
	
	/**
	 * 秒
	 */
	public static final int DATATYPE_SECOND = 6;
	
	private DateUtil(){
	}
	
	/**
	 * 根据string日期获取其格式
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static String getFormat(String date) throws Exception {
		String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
		String reg3 = "\\d{4}-\\d{1,2}-\\d{1,2}";
		String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg5 = "\\d{1,2}/\\d{1,2}/\\d{4}";
		if(date.matches(reg1)) {
			return FORMAT1;
		} else if(date.matches(reg2)) {
			return FORMAT1_1;
		} else if(date.matches(reg3)) {
			return FORMAT2;
		} else if(date.matches(reg4)) {
			return FORMAT3;
		} else if(date.matches(reg5)) {
			return FORMAT4;
		} else {
			throw new Exception("不支持的日期格式：" + date);
		}
	}

	/**
	 * 得到日期字符串 默认格式（yyyy-MM-dd） pattern可以为："yyyy-MM-dd" "HH:mm:ss" "E"
	 */
	public static String formatDate(Date date, Object... pattern) {
		String formatDate = null;
		if (pattern != null && pattern.length > 0) {
			formatDate = DateFormatUtils.format(date, pattern[0].toString());
		} else {
			formatDate = DateFormatUtils.format(date, "yyyy-MM-dd");
		}
		return formatDate;
	}
	
	/**
	 * 获取当前日期
	 * @return
	 */
	public static String getCurrentDate() {
		return getCurrentDateTime(FORMAT2);
	}

	public static String getCurrentDate_1() {
		return getCurrentDateTime(FORMAT1_1);
	}

	/**
	 * 获取当前时间
	 * 
	 * @return 时分秒
	 */
	public static String getCurrentTime() {
		return getCurrentDateTime(FORMAT5);
	}
	
	/**
	 * 获取当前日期时间
	 * @return
	 */
	public static String getCurrentDateTime() {
		return getCurrentDateTime(FORMAT1);
	}
	
	/**
	 * 根据特定格式获取当前时间
	 * @param format
	 * @return
	 */
	public static String getCurrentDateTime(String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(new Date());
	}
	
	/**
	 * 获取昨天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getYesterday() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, -1);
		return df.format(c.getTime());
	}
	
	/**
	 * 获取明天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getTomorrow() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, 1);
		return df.format(c.getTime());
	}

	/**
	 * +23.59.59
	 * @param value
	 * @return
	 */
	public static String dateFormatLast(String value) {
		try {
			Date date = convertStringToDate(value);
			String dateStr= convertDateToString(date, FORMAT2);
			return dateStr+" 24:00:00";
		} catch (Exception e) {
			log.error("+23.59.59",e);
			return "";
		}
	}
	
	/**
	 * String转换date
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static Date convertStringToDate(String date)  {
		SimpleDateFormat df;
		try {
			df = new SimpleDateFormat(getFormat(date));
			return df.parse(date);
		} catch (Exception e) {
			log.error("String转换date",e);
		}
		return new Date();
		
	}
	
	public static String convertDateToString(Date date, String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(date);
	}
	
	public static String dateFormat(String value, String format) {
		try {
			Date date = convertStringToDate(value);
			return convertDateToString(date, format);
		} catch (Exception e) {
			log.error("dateFormat",e);
			return "";
		}
	}
	
	public static int dateDiff(int type, String sdate1, String sdate2) throws Exception {
		Date date1 = new SimpleDateFormat(getFormat(sdate1)).parse(sdate1);
		Date date2 = new SimpleDateFormat(getFormat(sdate2)).parse(sdate2);
		Calendar cal1 = Calendar.getInstance();
		Calendar cal2 = Calendar.getInstance();
		cal1.setTime(date1);
		cal2.setTime(date2);
		int yearDiff = cal2.get(Calendar.YEAR) - cal1.get(Calendar.YEAR);
		if(type == DATATYPE_YEAR){
			return yearDiff;
		}else if(type == DATATYPE_MONTH){
			int monthDiff = yearDiff * 12 + cal2.get(Calendar.MONTH) - cal1.get(Calendar.MONTH);
			return monthDiff;
		}else {
			long ldate1 = date1.getTime() + cal1.get(Calendar.ZONE_OFFSET) + cal1.get(Calendar.DST_OFFSET);
			long ldate2 = date2.getTime() + cal2.get(Calendar.ZONE_OFFSET) + cal2.get(Calendar.DST_OFFSET);
			if(type == DATATYPE_HOUR) {
				return (int)((ldate2 - ldate1) / (3600000));
			}else if(type == DATATYPE_MINUTE) {
				return (int)((ldate2 - ldate1) / (60000));
			}else if(type == DATATYPE_SECOND) {
				return (int)((ldate2 - ldate1) / (1000));
			}else {
				return (int)((ldate2 - ldate1) / (3600000 * 24));
			}
		}
	}
	
	public static String dateAdd(int type, String sdate, int num) throws Exception{
		SimpleDateFormat df = new SimpleDateFormat(getFormat(sdate));
		Date date = df.parse(sdate);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		if(type == DATATYPE_YEAR){
			cal.add(Calendar.YEAR, num);
		}else if(type == DATATYPE_MONTH){
			cal.add(Calendar.MONTH, num);
		}else if(type == DATATYPE_HOUR){
			cal.add(Calendar.HOUR, num);
		}else if(type == DATATYPE_MINUTE){
			cal.add(Calendar.MINUTE, num);
		}else if(type == DATATYPE_SECOND){
			cal.add(Calendar.SECOND, num);
		}else {
			cal.add(Calendar.DATE, num);
		}
		return df.format(cal.getTime());
	}
	
	public static int calAge(String birthday, String type) throws Exception {
		String currDate = getCurrentDate();
		if ("D".equalsIgnoreCase(type)) {
			return dateDiff(DATATYPE_DAY, birthday, currDate);
		} else if ("M".equalsIgnoreCase(type)) {
			int result = dateDiff(DATATYPE_MONTH, birthday, currDate);
			String temp = dateAdd(DATATYPE_MONTH, birthday, result);
			if (dateDiff(DATATYPE_DAY, temp, currDate) <= 0) {
				result--;
			}
			return result;
		} else {
			int result = dateDiff(DATATYPE_YEAR, birthday, currDate);
			String temp = dateAdd(DATATYPE_YEAR, birthday, result);
			if (dateDiff(DATATYPE_DAY, temp, currDate) <= 0) {
				result--;
			}
			return result;
		}
	}
	
	public static int getYearOfDate(Date date) {
		Calendar gc = prepare(date);
		return gc.get(Calendar.YEAR);
	}

	public static int getMonthOfDate(Date date) {
		Calendar gc = prepare(date);
		return gc.get(Calendar.MONTH);
	}

	public static int getDayOfDate(Date date) {
		Calendar gc = prepare(date);
		return gc.get(Calendar.DAY_OF_MONTH);
	}

	public static Date addYear(Date date, int year) {
		Calendar gc = prepare(date);
		gc.add(Calendar.YEAR, year);
		return gc.getTime();
	}

	public static Date addMonth(Date date, int month) {
		Calendar gc = prepare(date);
		gc.add(Calendar.MONTH, month);
		return gc.getTime();
	}

	public static Date addDay(Date date, int day) {
		Calendar gc = prepare(date);
		gc.add(Calendar.DAY_OF_MONTH, day);
		return gc.getTime();
	}

//	public static Date addPeriod(Date date, BenefitPeriodType type, int period) {
//
//		Calendar gc = prepare(date);
//		switch (type) {
//		case ANNUAL:
//			gc.add(Calendar.YEAR, period);
//			break;
//		case MONTHLY:
//			gc.add(Calendar.MONTH, period);
//			break;
//		default:
//			gc.add(Calendar.DAY_OF_MONTH, period);
//			break;
//		}
//
//		return addDay(gc.getTime(), -1);
//	}
	
	private static Calendar prepare(Date date) {
		Calendar gc = Calendar.getInstance();
		gc.setTime(date);
		return gc;
	}

	public static Date rollingDate(Date date, int field, int amount) {
		Calendar gc = prepare(date);
		gc.roll(field, amount);
		return gc.getTime();
	}

	/**
	 * 25-二月-1987转成1987-02-25
	 * @param excTime
	 * @return
	 */
	public static String dateExcel(String excTime){
		excTime = excTime.split("-")[2]+"年"+monthChange(excTime.split("-")[1])+"月"+excTime.split("-")[1]+"日";
		return marsalDate(excTime);
	}
	private static String monthChange(String month){
		String result=null;
		switch (month) {
			case "十二月":
				result="12";
				break;
			case "十一月":
				result="11";
				break;
			case "十月":
				result="10";
				break;
			case "九月":
				result="09";
				break;
			case "八月":
				result="08";
				break;
			case "七月":
				result="07";
				break;
			case "六月":
				result="06";
				break;
			case "五月":
				result="05";
				break;
			case "四月":
				result="04";
				break;
			case "三月":
				result="03";
				break;
			case "二月":
				result="02";
				break;
			case "一月":
				result="01";
				break;
			default:
				break;
		}
		return result;
	}
	
	public static void main(String[] args) throws Exception {
//		boolean day = DateUtil.compareDates(convertStringToDate("2019-05-12 10:00:00"),convertStringToDate("2019-05-12 10:00:00"));
		System.out.println(getHours());
//		String a = DateUtil.dateAdd(DateUtil.DATATYPE_DAY,DateUtil.getCurrentDate(),-3);
//		String a = DateUtil.convertDateToString(getWeekStart(),DateUtil.FORMAT2);
//		String b = DateUtil.dateAdd(DateUtil.DATATYPE_DAY,a,1);
//		System.out.println(b);
		/*String a = "2014年07月12日";
		String b = marsalDate(a);*/
		/*Calendar c = Calendar.getInstance();
		c.setTime(new Date());
		String nextYear = (c.get(Calendar.YEAR)+1)+"-01-01";
		System.out.println(dateAdd(3,nextYear,-1));*/
		/*String a = "2018-09-01 10:23:16";
		Date a1 = convertStringToDate(a);
		Date b1 = getDayEnd(a1);
		String c1 = convertDateToString(b1,FORMAT1);*/
		/*System.out.println(convertDateToString(getFirstDayOfThisQuarter(),FORMAT2));
		System.out.println(convertDateToString(getLastDayOfThisQuarter(),FORMAT2));*/
	}

	public static boolean timestampIntervalIntersection(Date firstStart,Date firstEnd,Date twoStart,Date twoEnd) {
		if (firstStart.after(twoStart) && firstStart.before(twoEnd)){
			return true;
		}
		if (firstEnd.after(twoStart) && firstEnd.before(twoEnd)){
			return true;
		}
		if (firstStart.equals(twoStart) || firstStart.equals(twoEnd)){
			return true;
		}
		if (firstEnd.equals(twoStart) || firstEnd.equals(twoEnd)){
			return true;
		}
		if (firstStart.before(twoStart) && firstEnd.after(twoEnd)){
			return true;
		}
		return false;
	}
	/**
	 * Limited version of Calendar.set.
	 * <p>
	 * Set the specified field to min(actual maximum value of this field,
	 * specified new value).
	 * </p>
	 * 
	 * @param date
	 *            base date.
	 * @param field
	 *            field want to modify.
	 * @param value
	 *            the new value of specified field.
	 * @return a new Date instance holding the new value.
	 */
	public static Date setFieldInLimit(Date date, int field, int value) {
		Calendar gc = prepare(date);
		gc.set(field, Math.min(gc.getActualMaximum(field), value));
		return gc.getTime();
	}

	public static Date parseDate(String value) {
		Date date = java.sql.Date.valueOf(value);
		return date;
	}

	public static Date getDayStart(Date currentDate) {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(currentDate);
		current.set(Calendar.HOUR_OF_DAY, 0);
		current.clear(Calendar.MILLISECOND);
		current.clear(Calendar.MINUTE);
		current.clear(Calendar.SECOND);
		result = current.getTime();

		return result;
	}

	public static Date getDayEnd(Date day) {
		Date result = null;

		Calendar date = Calendar.getInstance();
		date.setTime(day);
		date.set(Calendar.HOUR_OF_DAY, 24);
		date.clear(Calendar.MINUTE);
		date.clear(Calendar.SECOND);
		date.set(Calendar.MILLISECOND, -1);
		result = date.getTime();

		return result;
	}

	public static Date getTodayStart() {
		return getDayStart(new Date());
	}

	public static Date getTodayEnd() {
		return getDayEnd(new Date());
	}

	/**
	 * <b> 获取当前周周一的日期，年月日 </b>
	 * @author ZXF
	 * @create 2019/08/29 0029 17:18
	 * @version
	 * @注意事项 </b>
	 */
	public static String thisMonday() {
		try {
			return DateUtil.dateAdd(
                    DateUtil.DATATYPE_DAY
                    ,DateUtil.convertDateToString(getWeekStart(),DateUtil.FORMAT2)
                    ,1);
		} catch (Exception e) {
			return "";
		}
	}

	public static Date getWeekStart() {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.set(Calendar.HOUR_OF_DAY, 0);
		current.clear(Calendar.MILLISECOND);
		current.clear(Calendar.MINUTE);
		current.clear(Calendar.SECOND);
		current.set(Calendar.DAY_OF_WEEK, current.getFirstDayOfWeek());
		result = current.getTime();

		return result;
	}

	public static Date getWeekEnd() {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(getWeekStart());
		current.add(Calendar.WEEK_OF_YEAR, 1);
		current.set(Calendar.MILLISECOND, -1);
		result = current.getTime();

		return result;
	}

	public static Date getMonthStart(Date currentDate) {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(getDayStart(currentDate));
		current.set(Calendar.DAY_OF_MONTH, 1);
		result = current.getTime();

		return result;
	}

	public static Date getYearStart(Date date) {
		int year = getYearOfDate(date);
		Calendar result = Calendar.getInstance();
		result.set(year, 0, 1);
		return result.getTime();
	}

	/**
	 * Return a Date representing the start of the specified month.
	 * 
	 * @param year
	 *            Year value.
	 * @param month
	 *            Month value. Starts from 0.
	 * @return
	 */
	public static Date getMonthStart(int year, int month) {
		Calendar sampleDate = Calendar.getInstance();
		sampleDate.set(Calendar.YEAR, year);
		sampleDate.set(Calendar.MONTH, month);
		return getMonthStart(sampleDate.getTime());
	}

	public static Date getMonthEnd(Date currentDate) {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(getMonthStart(currentDate));
		current.add(Calendar.MONTH, 1);
		current.add(Calendar.MILLISECOND, -1);
		result = current.getTime();

		return result;
	}

	/**
	 * Return a Date representing the end of the specified month.
	 * 
	 * @param year
	 *            Year value.
	 * @param month
	 *            Month value. Starts from 0.
	 * @return
	 */
	public static Date getMonthEnd(int year, int month) {
		Calendar sampleDate = Calendar.getInstance();
		sampleDate.set(Calendar.YEAR, year);
		sampleDate.set(Calendar.MONTH, month);
		return getMonthEnd(sampleDate.getTime());
	}

	public static int calculateDisparity(Date beforeDate, Date afterDate, int calendar_time_type, int roundingMode) {
		int result = 0;

		if (beforeDate == null || afterDate == null) {
			throw new IllegalArgumentException("beforeDate and afterDate can not be null.");
		}
		if (calendar_time_type == Calendar.DATE){
			throw new IllegalArgumentException("Calendar.Date is not supported now.");
		}

		Calendar after = prepare(afterDate);
		Calendar before = prepare(beforeDate);

		// int yearDisparity = after.get(Calendar.YEAR) -
		// before.get(Calendar.YEAR);
		// int monthDisparity = after.get(Calendar.MONTH) -
		// before.get(Calendar.MONTH);
		// switch (calendar_time_type) {
		// case Calendar.YEAR:
		// result = yearDisparity + monthDisparity / 12;
		// break;
		// case Calendar.MONTH:
		// result = yearDisparity * 12 + monthDisparity;
		// break;
		// default:
		// // throw exception
		// }

		if (calendar_time_type == Calendar.DATE) {
			result -= before.get(Calendar.DAY_OF_YEAR);
			while (before.before(after)) {
				result += before.getActualMaximum(Calendar.DAY_OF_YEAR);
				before.add(Calendar.YEAR, 1);
			}
			result += before.get(Calendar.DAY_OF_YEAR);
		} else {
			if (roundingMode == BigDecimal.ROUND_DOWN) {
				result = -1;
				while (!before.after(after)) {
					result++;
					before.add(calendar_time_type, 1);
				}
			} else if (roundingMode == BigDecimal.ROUND_UP) {
				result = 0;
				while (before.before(after)) {
					result++;
					before.add(calendar_time_type, 1);
				}
			}
		}

		return result;
	}

	public static Date mergeDate(Date day, Date time) {
		Calendar result = Calendar.getInstance();

		result.setTime(time);
		Calendar dayHelper = Calendar.getInstance();
		dayHelper.setTime(day);
		result.set(dayHelper.get(Calendar.YEAR), dayHelper.get(Calendar.MONTH), dayHelper.get(Calendar.DATE));

		return result.getTime();
	}

	/**
	 * Get a Iterator of a Date collection which is [start, end].
	 * 
	 * @param start
	 * @param end
	 * @return a Date Iterator.
	 */
	public static Iterator dateIterator(Date start, Date end) {
		return new DateIterator(start, end);
	}

	/**
	 * Get a Iterator of a Calendar collection which is [start, end].
	 * 
	 * @param start
	 * @param end
	 * @return a Calendar Iterator.
	 */
	public static Iterator calendarIterator(Calendar start, Calendar end) {
		return new CalendarIterator(start, end);
	}

	/**
	 * from org.apache.commons.lang.time.DateUtils.DateIterator. Renamed.
	 * 
	 * @author �ų�
	 * @version 1.0 created on 2007-6-30
	 */
	static class CalendarIterator implements Iterator {
		private final Calendar endFinal;

		private final Calendar spot;

		/**
		 * Constructs a DateIterator that ranges from one date to another.
		 * 
		 * @param startFinal
		 *            start date (inclusive)
		 * @param endFinal
		 *            end date (not inclusive)
		 */
		CalendarIterator(Calendar startFinal, Calendar endFinal) {
			super();
			this.endFinal = endFinal;
			spot = startFinal;
			spot.add(Calendar.DATE, -1);
		}

		/**
		 * Has the iterator not reached the end date yet?
		 * 
		 * @return <code>true</code> if the iterator has yet to reach the end
		 *         date
		 */
		@Override
		public boolean hasNext() {
			return spot.before(endFinal);
		}

		/**
		 * Return the next calendar in the iteration
		 * 
		 * @return Object calendar for the next date
		 */
		@Override
		public Object next() {
			if (spot.equals(endFinal)) {
				throw new NoSuchElementException();
			}
			spot.add(Calendar.DATE, 1);
			return spot.clone();
		}

		/**
		 * Always throws UnsupportedOperationException.
		 * 
		 * @throws UnsupportedOperationException
		 * @see Iterator#remove()
		 */
		@Override
		public void remove() {
			throw new UnsupportedOperationException();
		}
	}

	/**
	 * Date version.
	 * 
	 * @author �ų�
	 * @version 1.0 created on 2007-6-30
	 */
	static class DateIterator extends CalendarIterator implements Iterator {

		/**
		 * Constructs a DateIterator that ranges from one date to another.
		 * 
		 * @param startFinal
		 *            start date (inclusive)
		 * @param endFinal
		 *            end date (not inclusive)
		 */
		DateIterator(Date startFinal, Date endFinal) {
			super(prepare(startFinal), prepare(endFinal));
		}

		/**
		 * Return the next calendar in the iteration
		 * 
		 * @return Object calendar for the next date
		 */
		@Override
		public Object next() {
			return ((Calendar) super.next()).getTime();
		}

	}

	public static boolean isInThePeriod(Date asOfDate, Date start, Date end) {
		if (!asOfDate.before(start) && !asOfDate.after(end)){
			return true;
		}
		return false;
	}


	/**
	 * 获得上个月第一天
	 * @param
	 * @return 2005-10-1
	 * @throws ParseException
	 */
	public static Date getFirstDayOfLastMonth() throws ParseException {
		Calendar calendar1 = Calendar.getInstance();
		calendar1.add(Calendar.MONTH, -1);
		calendar1.set(Calendar.DAY_OF_MONTH,1);
		Date day = calendar1.getTime();
		return day;
	}
	/**
	 *
	 * 获得上个月最后一天
	 * @param
	 * @return 2005-10-30
	 * @throws ParseException
	 */
	public static Date getLastDayOfLastMonth() throws ParseException {
		Calendar calendar2 = Calendar.getInstance();
		calendar2.add(Calendar.MONTH, -1);
		calendar2.set(Calendar.DAY_OF_MONTH, 0);
		Date day = calendar2.getTime();
		return day;
	}
	/**
	 * 获得本月第一天
	 * @param
	 * @return 2005-10-1
	 * @throws ParseException
	 */
	public static Date getFirstDayOfThisMonth() throws ParseException {
		Calendar calendar1 = Calendar.getInstance();
		calendar1.add(Calendar.MONTH, 0);
		calendar1.set(Calendar.DAY_OF_MONTH,1);
		Date day = calendar1.getTime();
		return day;
	}
	/**
	 *
	 * 获得本月最后一天
	 * @param
	 * @return 2005-10-30
	 * @throws ParseException
	 */
	public static Date getLastDayOfThisMonth() throws ParseException {
		Calendar calendar2 = Calendar.getInstance();
		calendar2.add(Calendar.MONTH, 1);
		calendar2.set(Calendar.DAY_OF_MONTH, 0);
		Date day = calendar2.getTime();
		return day;
	}

	/**
	 *
	 * 获得本个季度第一天
	 * @param
	 * @return 2005-7-1
	 * @throws ParseException
	 */
	public static Date getFirstDayOfThisQuarter() throws ParseException {
		Calendar calendar = new GregorianCalendar();
		calendar.setTime(new Date());
		int month = getQuarterInMonth(calendar.get(Calendar.MONTH), true);
		calendar.set(Calendar.MONTH, month);
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		Date day = calendar.getTime();
		return day;
	}
	/**
	 *
	 * 获得上个季度最后一天
	 * @param
	 * @return 2005-10-30
	 * @throws ParseException
	 */
	public static Date getLastDayOfThisQuarter() throws ParseException {
		Calendar endCalendar = new GregorianCalendar();
		endCalendar.setTime(new Date());
		int month = getQuarterInMonth(endCalendar.get(Calendar.MONTH), false);
		endCalendar.set(Calendar.MONTH, month + 1);
		endCalendar.set(Calendar.DAY_OF_MONTH, 0);

		Date day = endCalendar.getTime();
		return day;
	}
	private static int getQuarterInMonth(int month, boolean isQuarterStart) {
		int months[] = { 1, 4, 7, 10 };
		if (!isQuarterStart) {
			months = new int[] { 3, 6, 9, 12 };
		}if (month >= 1 && month <= 3) {
			return months[0];
		}else if (month >= 4 && month <= 6) {
			return months[1];
		}else if (month >= 7 && month <= 9) {
			return months[2];
		}else {
			return months[3];
		}
	}
	/**
	 * 获取本年第一天日期
	 * @return Date
	 */
	public static Date getCurrentYearStartTime() {
		Calendar cal = Calendar.getInstance();
		cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY), cal.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
		cal.set(Calendar.DAY_OF_MONTH, cal.getActualMinimum(Calendar.YEAR));
		return cal.getTime();
	}
	/**
	 * 获取本年最后一天日期
	 * @return Date
	 */
	public static Date getCurrentYearEndTime() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(getCurrentYearStartTime());
		cal.add(Calendar.YEAR, 1);
		return cal.getTime();
	}

	/**
	 * 获取本年最后一天日期
	 * @return Date
	 */
	public static String getThisYearLastDay() {
		Calendar c = Calendar.getInstance();
		c.setTime(new Date());
		String nextYear = (c.get(Calendar.YEAR)+1)+"-01-01";
		String ld = "";
		try {
			ld = dateAdd(3,nextYear,-1);
		} catch (Exception e) {
			ld = c.get(Calendar.YEAR)+"-12-31";
		}
		return ld;
	}

	/**
	 * 获取本年第一天日期
	 * @return Date
	 */
	public static String getThisYearThisDay() {
		Calendar c = Calendar.getInstance();
		c.setTime(new Date());
		return (c.get(Calendar.YEAR))+"-01-01";
	}

	public static boolean isSameDay(Date one, Date two) {
		if (getYearOfDate(one) == getYearOfDate(two) && getMonthOfDate(one) == getMonthOfDate(two) && getDayOfDate(one) == getDayOfDate(two)) {
			return true;
		}
		return false;
	}

	public static boolean isFirstDateOfMonth(Date date) {
		int day = date.getDate();
		if (day == 1)
			return true;
		return false;
	}

	public static boolean isFirstDayFromThisMonth(Date date) {
		Date today = new Date();

		if ((today.before(date) || today.equals(date)) && isFirstDateOfMonth(date))
			return true;

		return false;
	}

	public static boolean isFirstDayFromNextMonth(Date date) {
		Date today = new Date();

		if (today.before(date) && isFirstDateOfMonth(date)) {
			if (today.getMonth() == date.getMonth()) {
				return false;
			}else {
				return true;
			}
		}

		return false;
	}

	public static boolean laterThanToday(Date effectiveDate) {
		Date today = DateUtil.getTodayStart();
		if (today.before(effectiveDate) || today.equals(effectiveDate))
			return true;
		return false;
	}

	public static boolean laterThanFirstDayOfThisMonth(Date effectiveDate) {
		Date firstDayOfThisMonth = getMonthStart(new Date());
		if (firstDayOfThisMonth.before(effectiveDate) || firstDayOfThisMonth.equals(effectiveDate))
			return true;
		return false;
	}

	/**
	 * �ж������ַ��Ƿ�Ϸ�,�ƶ���ʽΪ��yyyyMM��,��Ҫ���ڵ���������ڸ�ʽУ�顣
	 * 
	 * @param externalReference
	 * @return
	 */
	public static boolean isValidFormat(String externalReference) {
		boolean isValid = true;

		Integer year = Integer.valueOf(0);
		Integer month = Integer.valueOf(0);
		if (externalReference.length() == 6) {
			try {
				year = Integer.valueOf(externalReference.substring(0, 4));
				month = Integer.valueOf(externalReference.substring(4));
			} catch (Exception e) {
				log.error("externalReference",e);
				isValid = false;
			}
		} else {
			isValid = false;
		}
		if (year.intValue() < 1970 || year.intValue() > 2099 || month.intValue() > 12 || month.intValue() < 1) {
			isValid = false;
		}

		return isValid;
	}
	
	/**   
	* @param date1 ��Ҫ�Ƚϵ�ʱ�� ����Ϊ��(null),��Ҫ��ȷ�����ڸ�ʽ   
	* @param date2 ���Ƚϵ�ʱ��   
	* @param stype ����ֵ����   0Ϊ�����죬1Ϊ���ٸ��£�2Ϊ������   
	* @return   
	*/  
	public static int compareDate(Date date1, Date date2, int stype) {
		int n = 0;

		String[] u = { "��", "��", "��" };
		Calendar c1 = Calendar.getInstance();
		Calendar c2 = Calendar.getInstance();
		try {
			c1.setTime(date1);
			c2.setTime(date2);
		} catch (Exception e3) {
			log.error("wrong occured",e3);
//			System.out.println("wrong occured");
		}
		while (!c1.after(c2)) { // ѭ���Աȣ�ֱ����ȣ�n ������Ҫ�Ľ��
			n++;
			if (stype == 1) {
				c1.add(Calendar.MONTH, 1); // �Ƚ��·ݣ��·�+1
			} else {
				c1.add(Calendar.DATE, 1); // �Ƚ���������+1
			}
		}
		n = n - 1;
		if (stype == 2) {
			n = (int) n / 365;
		}
		System.out.println(date1 + " -- " + date2 + " ������" + u[stype] + ":" + n);
		return n;
	}   
	
	
	/**
	 * 将日期格式字符串（yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）转换成Date
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date getDate(String date) throws ParseException {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		String dateValue = marsalDate(date);
		if ( StringUtils.isNotEmpty(dateValue) ) {
			return dateFormat.parse(dateValue);
		}else {
			return null;
		}
	}
	
	public static Date StingToDate(String dateValue) throws ParseException {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		if ( StringUtils.isNotEmpty(dateValue) ) {
			return dateFormat.parse(dateValue);
		}else {
			return null;
		}
	}
	/**
	 * 将字符串（格式:yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）转换成日期格式（yyyy-MM-dd）字符串
	 * @param date
	 * @return
	 */
	public static String marsalDate(String date) {
		date = date.replace("年","-").replace("月", "-").replace("日", "");
		String split = "./-\t\\s";
		String dateTemp;
		String year;
		String month;
		String day;
		if (date.length() <= 10) {
			StringTokenizer tokenizer = new StringTokenizer(date, split);
			int tokenCount = tokenizer.countTokens();
			if (tokenCount == 3) {
				year = tokenizer.nextToken();
				month = tokenizer.nextToken();
				day = tokenizer.nextToken();
			} else if (tokenCount == 1) {
				dateTemp = tokenizer.nextToken();
				if (dateTemp.length() == 8) {
					year = dateTemp.substring(0,4);
					month = dateTemp.substring(4,6);
					day = dateTemp.substring(6,8);
				} else if (dateTemp.length() == 6) {
					year = dateTemp.substring(0,4);
					month = dateTemp.substring(4,5);
					day = dateTemp.substring(5,6);
				} else {
					return null;
				}
			} else {
				return null;
			}
			return marsalDate(year, month, day);
		} else {
			return null;
		}
	}
	
	/**
	 * 将year, month, day 组成日期格式（yyyy-MM-dd）字符串
	 * @param year
	 * @param month
	 * @param day
	 * @return date
	 */
	public static String marsalDate(String year,String month,String day) {
		String date;
		String yearTemp;
		String monthTemp;
		String dayTemp;
		
		if (year.length() != 4 || month.length() > 2 || day.length() > 2) {
			return null;
		}
		
		yearTemp = year;
		
		if (month.length() == 1) {
			monthTemp = "0" + month;
		} else {
			monthTemp = month;
		}
		
		if (day.length() == 1) {
			dayTemp = "0" + day;
		} else {
			dayTemp = day;
		}
		date = yearTemp + "-" + monthTemp + "-" + dayTemp;
		return date;
	}
	
	/**
	 * 校验日期格式yyyy-MM-dd
	 * @param date
	 * @return
	 */
	public static boolean checkIsValidDateFormat(String date){
		if (date == null){
			return false;
		}else if (date.length() != 10){
			return false;
		}else {
			String regex = "((\\d{2}(([02468][048])|([13579][26]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
			Pattern pattern = Pattern.compile(regex);
			Matcher mather = pattern.matcher(date);
			return mather.matches();
		}
	} 
	
	/**
	 *24小时制时间格式校验（HH:mm:ss）
	 * @param dateTime
	 * @return
	 */
	public static boolean checkIsValidDateTimeFormat(String dateTime) {
		if (dateTime == null){
			return false;
		}else if (dateTime.length() != 8){
			return false;
		}else {
			String regex = "^(([0|1][0-9])|(2[0-3])):[0-5][0-9]:[0-5][0-9]$";
			Pattern pattern = Pattern.compile(regex);
			Matcher mather = pattern.matcher(dateTime);
			return mather.matches();
		} 
	}
	/**
	 * 校验日期格式（yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）
	 * @param date
	 * @return
	 */
	public static boolean checkDate(String date) {
		String dateValue = marsalDate(date);
		return checkIsValidDateFormat(dateValue);
	}
	
	public synchronized static String generatorRadomNumber() {
		Date today = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
		String serialNumber = "";
		try {
			serialNumber = format.format(today) +  new DecimalFormat("0000").format(new Random().nextInt(10000));
		} catch (Exception e) {
			e.printStackTrace();
		}

		return serialNumber;
	}
	
	public synchronized static String generatorRadomNumberForDate() {
		Date today = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
		String serialNumber = format.format(today) ;
		return serialNumber;
	}
	
	/**
	 * 获取两日期相减的天数
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	public static int getDistDates(Date startDate, Date endDate) {
		if (null == startDate || null == endDate) {
			return -1;
		}
		long intervalMilli = endDate.getTime() - startDate.getTime();
		return (int) (intervalMilli / (24 * 60 * 60 * 1000));
    }

    /**
     * <b> 日期比较 </b>
     * @author ZXF
     * @create 2019/12/11 0011 16:08
     * @version
     * @注意事项 </b>
     */
	public static boolean compareDates(Date startDate, Date endDate) {
		if (null == startDate || null == endDate) {
			return false;
		}
		long intervalMilli = endDate.getTime() - startDate.getTime();
		return intervalMilli>=0?true:false;
    }

	public static boolean contains(Date startDate, Date endDate, Date date){
		if (startDate == null || endDate == null || date == null){
			return false;
		}

		Interval interval = new Interval(new DateTime(startDate), new DateTime(endDate).plusDays(1));

		return interval.contains(new DateTime(date));
	}
	
	//String转Date
	public static Date convertString2Date(String time) {
		Date date = new Date();
		// 注意format的格式要与日期String的格式相匹配
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			date = sdf.parse(time);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return date;
	}
	//获取当前小时
	public static int getHours() {
		Date date = new Date();
		// 注意format的格式要与日期String的格式相匹配
		SimpleDateFormat sdf = new SimpleDateFormat(FORMAT7);
		try {
			return Integer.parseInt(sdf.format(date));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return 0;
	}
	//计算两个Date数据的大小
	public static long calculateTwoDateDvalue(Date date1, Date date2) {
		Calendar cal = Calendar.getInstance();// 定义日历类型的变量
		// 将日期型的日期设置成日历型日期
		cal.setTime(date1);// 应归还日期
		long date1value = cal.getTimeInMillis();// 定义日历类型的变量
		cal.setTime(date2);// 应归还日期
		long date2value = cal.getTimeInMillis();// 定义日历类型的变量
		return date1value - date2value;
	}
	
	 /**
	  * <b>获取时间戳格式,返回格式为YYYY-MM-DD HH:MM:SS:SSS</b> 
	  * @return
	  * @author liumd 
	  * @date 2016年12月23日 下午1:24:49
	  * @注意事项 </b>
	  * <b>
	  */
    public static Timestamp getTimestamp(){
    	Date date = new Date();       
    	Timestamp nousedate = new Timestamp(date.getTime());
    	return nousedate;
    }

	/**
	 * 将yyyy-MM-dd转换成yyyy年MM月dd日
	 * @param data 2017-05-05
	 * @return date
	 */
	public static String fomData(String data) {

		String year = data.split("-")[0];
		String month = data.split("-")[1];
		String day = data.split("-")[2];
		return year+"年"+month+"月"+day+"日";
	}

	//由出生日期获得年龄 yyyy-MM-dd
	public static int getAge(String date) throws Exception {
		Date birthDay = convertStringToDate(date);
		Calendar cal = Calendar.getInstance();

		if (cal.before(birthDay)) {
			throw new IllegalArgumentException(
					"The birthDay is before Now.It's unbelievable!");
		}
		int yearNow = cal.get(Calendar.YEAR);
		int monthNow = cal.get(Calendar.MONTH);
		int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH);
		cal.setTime(birthDay);

		int yearBirth = cal.get(Calendar.YEAR);
		int monthBirth = cal.get(Calendar.MONTH);
		int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);

		int age = yearNow - yearBirth;

		if (monthNow <= monthBirth) {
			if (monthNow == monthBirth) {
				if (dayOfMonthNow < dayOfMonthBirth) age--;
			}else{
				age--;
			}
		}
		return age;
	}

	public static Long getTime() throws Exception {
		return System.currentTimeMillis();
	}
}
