package com.bcxin.ins.enums;

/**
 * 缴费状态枚举
 * @author hzp
 * @date 2018/06/12
 */
public enum PayStatusEnum {
    //待处理
    PENDING("0","待处理"),
    //待审核
    CHECKING("2","待审核"),
    //已支付
    PAYED("3","已支付"),
    //暂存单
    SAVED("4","暂存单");

    private String key;
    private String alias;

    private PayStatusEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(PayStatusEnum e : PayStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
