package com.bcxin.ins.entity.policy_special;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <b>企业短期信用险特殊字段表-营业额 </b>
 *
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@TableName("st_turnover")
public class StTurnover implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long st_turnover_id;

    @TableField(value = "idx")
    private Long idx;

    @TableField(value = "code")
    private String code;

    @TableField(value = "codex")
    private String codex;

    @TableField(value = "remarks")
    private String remarks;	// 备注

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//

    @TableField(value = "company_id",el="sysCompany.company_id")
    protected SysCompany sysCompany;

    @TableField(value = "breakdowns_cash")
    private BigDecimal breakdowns_cash;

    @TableField(value = "breakdowns_lc")
    private BigDecimal breakdowns_lc;

    @TableField(value = "breakdowns_associated")
    private BigDecimal breakdowns_associated;

    @TableField(value = "breakdowns_oa")
    private BigDecimal breakdowns_oa;

    @TableField(value = "breakdowns_dpda")
    private BigDecimal breakdowns_dpda;

    @TableField(value = "breakdowns_sum")
    private BigDecimal breakdowns_sum;

    /**
     * 预计未来一年内所须投保的信用销售总额（按国别分类）
     ins_forecasted_detail
     */
    @TableField(exist = false)
    private List<StForecastedDetail> forecastedDetailList;

    /**
     * 最近三年销售记录表
     */
    @TableField(exist = false)
    private List<StRecentYearsSell> recentYearsSellList;

    public Long getSt_turnover_id() {
        return st_turnover_id;
    }

    public void setSt_turnover_id(Long st_turnover_id) {
        this.st_turnover_id = st_turnover_id;
    }

    public Long getIdx() {
        return idx;
    }

    public void setIdx(Long idx) {
        this.idx = idx;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodex() {
        return codex;
    }

    public void setCodex(String codex) {
        this.codex = codex;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }

    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SysCompany getSysCompany() {
        return sysCompany;
    }

    public void setSysCompany(SysCompany sysCompany) {
        this.sysCompany = sysCompany;
    }

    public BigDecimal getBreakdowns_cash() {
        return breakdowns_cash;
    }

    public void setBreakdowns_cash(BigDecimal breakdowns_cash) {
        this.breakdowns_cash = breakdowns_cash;
    }

    public BigDecimal getBreakdowns_lc() {
        return breakdowns_lc;
    }

    public void setBreakdowns_lc(BigDecimal breakdowns_lc) {
        this.breakdowns_lc = breakdowns_lc;
    }

    public BigDecimal getBreakdowns_associated() {
        return breakdowns_associated;
    }

    public void setBreakdowns_associated(BigDecimal breakdowns_associated) {
        this.breakdowns_associated = breakdowns_associated;
    }

    public BigDecimal getBreakdowns_oa() {
        return breakdowns_oa;
    }

    public void setBreakdowns_oa(BigDecimal breakdowns_oa) {
        this.breakdowns_oa = breakdowns_oa;
    }

    public BigDecimal getBreakdowns_dpda() {
        return breakdowns_dpda;
    }

    public void setBreakdowns_dpda(BigDecimal breakdowns_dpda) {
        this.breakdowns_dpda = breakdowns_dpda;
    }

    public BigDecimal getBreakdowns_sum() {
        return breakdowns_sum;
    }

    public void setBreakdowns_sum(BigDecimal breakdowns_sum) {
        this.breakdowns_sum = breakdowns_sum;
    }

    public List<StForecastedDetail> getForecastedDetailList() {
        return forecastedDetailList;
    }

    public void setForecastedDetailList(List<StForecastedDetail> forecastedDetailList) {
        this.forecastedDetailList = forecastedDetailList;
    }

    public List<StRecentYearsSell> getRecentYearsSellList() {
        return recentYearsSellList;
    }

    public void setRecentYearsSellList(List<StRecentYearsSell> recentYearsSellList) {
        this.recentYearsSellList = recentYearsSellList;
    }
}