package com.bcxin.ins.entity.policy_special;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <b>企业短期信用险特殊字段表-坏账 </b>
 *
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@TableName("st_bad_debt")
public class StBadDebt implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long st_bad_debt_id;

    @TableField(value = "idx")
    private Long idx;

    @TableField(value = "code")
    private String code;

    @TableField(value = "codex")
    private String codex;

    @TableField(value = "remarks")
    private String remarks;	// 备注

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//

    @TableField(value = "company_id",el="sysCompany.company_id")
    protected SysCompany sysCompany;

    @TableField(value = "as_of")
    private String as_of;

    @TableField(value = "domestics")
    private String domestics;

    @TableField(value = "exports")
    private String exports;

    @TableField(value = "is_overdue_buyers")
    private int is_overdue_buyers;

    @TableField(value = "domestic_amount_sum")
    private BigDecimal domestic_amount_sum;

    @TableField(value = "domestic_percentage_sum")
    private BigDecimal domestic_percentage_sum;

    @TableField(value = "export_amount_sum")
    private BigDecimal export_amount_sum;

    @TableField(value = "export_percentage_sum")
    private BigDecimal export_percentage_sum;

    /**
     * 账龄及坏账分析周期表
     */
    @TableField(exist = false)
    private List<StDebtAges> insDebtAges;
    /**
     * 逾期详细信息表
     */
    @TableField(exist = false)
    private List<StOverdueDetail> insOverdueDetail;
    /**
     * 坏账分析表
     */
    @TableField(exist = false)
    private List<StBadAnalysis> insBadAnalysis;
    /**
     * 过去三年中三笔最大的呆坏账详情表
     */
    @TableField(exist = false)
    private List<StPastBadDetail> insPastBadDetail;

    public Long getSt_bad_debt_id() {
        return st_bad_debt_id;
    }

    public void setSt_bad_debt_id(Long st_bad_debt_id) {
        this.st_bad_debt_id = st_bad_debt_id;
    }

    public Long getIdx() {
        return idx;
    }

    public void setIdx(Long idx) {
        this.idx = idx;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodex() {
        return codex;
    }

    public void setCodex(String codex) {
        this.codex = codex;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }

    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SysCompany getSysCompany() {
        return sysCompany;
    }

    public void setSysCompany(SysCompany sysCompany) {
        this.sysCompany = sysCompany;
    }

    public String getAs_of() {
        return as_of;
    }

    public void setAs_of(String as_of) {
        this.as_of = as_of;
    }

    public String getDomestics() {
        return domestics;
    }

    public void setDomestics(String domestics) {
        this.domestics = domestics;
    }

    public String getExports() {
        return exports;
    }

    public void setExports(String exports) {
        this.exports = exports;
    }

    public int getIs_overdue_buyers() {
        return is_overdue_buyers;
    }

    public void setIs_overdue_buyers(int is_overdue_buyers) {
        this.is_overdue_buyers = is_overdue_buyers;
    }

    public BigDecimal getDomestic_amount_sum() {
        return domestic_amount_sum;
    }

    public void setDomestic_amount_sum(BigDecimal domestic_amount_sum) {
        this.domestic_amount_sum = domestic_amount_sum;
    }

    public BigDecimal getDomestic_percentage_sum() {
        return domestic_percentage_sum;
    }

    public void setDomestic_percentage_sum(BigDecimal domestic_percentage_sum) {
        this.domestic_percentage_sum = domestic_percentage_sum;
    }

    public BigDecimal getExport_amount_sum() {
        return export_amount_sum;
    }

    public void setExport_amount_sum(BigDecimal export_amount_sum) {
        this.export_amount_sum = export_amount_sum;
    }

    public BigDecimal getExport_percentage_sum() {
        return export_percentage_sum;
    }

    public void setExport_percentage_sum(BigDecimal export_percentage_sum) {
        this.export_percentage_sum = export_percentage_sum;
    }

    public List<StDebtAges> getInsDebtAges() {
        return insDebtAges;
    }

    public void setInsDebtAges(List<StDebtAges> insDebtAges) {
        this.insDebtAges = insDebtAges;
    }

    public List<StOverdueDetail> getInsOverdueDetail() {
        return insOverdueDetail;
    }

    public void setInsOverdueDetail(List<StOverdueDetail> insOverdueDetail) {
        this.insOverdueDetail = insOverdueDetail;
    }

    public List<StBadAnalysis> getInsBadAnalysis() {
        return insBadAnalysis;
    }

    public void setInsBadAnalysis(List<StBadAnalysis> insBadAnalysis) {
        this.insBadAnalysis = insBadAnalysis;
    }

    public List<StPastBadDetail> getInsPastBadDetail() {
        return insPastBadDetail;
    }

    public void setInsPastBadDetail(List<StPastBadDetail> insPastBadDetail) {
        this.insPastBadDetail = insPastBadDetail;
    }
}