package com.bcxin.ins.entity.policy_report;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <b> 报案银行支付信息表 </b>
 * @author ZXF
 * @create 2019/11/11 0011 11:06
 * @version
 * @注意事项 </b>
 */
@TableName("ins_payment_info")
public class InsPaymentInfo implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long ins_payment_info_id;

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//

    @TableField(value = "client_name")
    private String client_name;//开户姓名

    @TableField(value = "client_type")
    private String client_type;//客户类型,传数字编码(01=被保险人,02=受益人,03=受害人,04=法院,05=被委托人,99=其他)

    @TableField(value = "client_bank_account")
    private String client_bank_account;//开户行账号

    @TableField(value = "client_bank_code")
    private String client_bank_code;//开户行代码(实时支付时为银行大类的Code。详细见附录2.2)

    @TableField(value = "client_bank_name")
    private String client_bank_name;//开户行名称(实时支付时为银行大类的名称。详细见附录2.2)

    @TableField(value = "collect_pay_approach")
    private String collect_pay_approach;// 收付途径【01=柜面,02=实时,03=批量】

    @TableField(value = "bank_account_attribute")
    private String bank_account_attribute;//银行账户类型(1=个人账号,0=公司账号)

    @TableField(value = "client_certificate_type")
    private String client_certificate_type;//证件类型(01-身份证,02-护照,03-军官证,04-港澳通行证,05-驾驶证,06-港澳回乡证或台胞证,07-临时身份证,99-其他)

    @TableField(value = "client_certificate_no")
    private String client_certificate_no;//证件号码，账户类型为个人时非空

    @TableField(value = "remark")
    private String remark;//备注信息/银行预留信息

    @TableField(value = "province_name")
    private String province_name;//省名称，收付途径为批量时非空

    @TableField(value = "province_code")
    private String province_code;//省代码

    @TableField(value = "city_name")
    private String city_name;//市名称，收付途径为批量时非空

    @TableField(value = "region_code")
    private String region_code;//市代码，收付途径为批量时非空,为非批量时可以不传

    /*   报案结果字段    */
    @TableField(value = "pay_date")
    private Date pay_date;//赔款到账时间

    public Long getIns_payment_info_id() {
        return ins_payment_info_id;
    }

    public void setIns_payment_info_id(Long ins_payment_info_id) {
        this.ins_payment_info_id = ins_payment_info_id;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }

    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getClient_name() {
        return client_name;
    }

    public void setClient_name(String client_name) {
        this.client_name = client_name;
    }

    public String getClient_type() {
        return client_type;
    }

    public void setClient_type(String client_type) {
        this.client_type = client_type;
    }

    public String getClient_bank_account() {
        return client_bank_account;
    }

    public void setClient_bank_account(String client_bank_account) {
        this.client_bank_account = client_bank_account;
    }

    public String getClient_bank_code() {
        return client_bank_code;
    }

    public void setClient_bank_code(String client_bank_code) {
        this.client_bank_code = client_bank_code;
    }

    public String getClient_bank_name() {
        return client_bank_name;
    }

    public void setClient_bank_name(String client_bank_name) {
        this.client_bank_name = client_bank_name;
    }

    public String getCollect_pay_approach() {
        return collect_pay_approach;
    }

    public void setCollect_pay_approach(String collect_pay_approach) {
        this.collect_pay_approach = collect_pay_approach;
    }

    public String getBank_account_attribute() {
        return bank_account_attribute;
    }

    public void setBank_account_attribute(String bank_account_attribute) {
        this.bank_account_attribute = bank_account_attribute;
    }

    public String getClient_certificate_type() {
        return client_certificate_type;
    }

    public void setClient_certificate_type(String client_certificate_type) {
        this.client_certificate_type = client_certificate_type;
    }

    public String getClient_certificate_no() {
        return client_certificate_no;
    }

    public void setClient_certificate_no(String client_certificate_no) {
        this.client_certificate_no = client_certificate_no;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getProvince_name() {
        return province_name;
    }

    public void setProvince_name(String province_name) {
        this.province_name = province_name;
    }

    public String getCity_name() {
        return city_name;
    }

    public void setCity_name(String city_name) {
        this.city_name = city_name;
    }

    public String getRegion_code() {
        return region_code;
    }

    public void setRegion_code(String region_code) {
        this.region_code = region_code;
    }

    public Date getPay_date() {
        return pay_date;
    }

    public void setPay_date(Date pay_date) {
        this.pay_date = pay_date;
    }

    public String getProvince_code() {
        return province_code;
    }

    public void setProvince_code(String province_code) {
        this.province_code = province_code;
    }
}