package com.bcxin.ins.entity.policy_report;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <b> 基础报案信息表 </b>
 * @author ZXF
 * @create 2019/11/11 0011 11:06
 * @version
 * @注意事项 </b>
 */
@TableName("ins_common_report")
public class InsCommonReport implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long ins_common_report_id;

    @TableField(value = "idx")
    private Long idx;

    @TableField(value = "code")
    private String code;

    @TableField(value = "codex")
    private String codex;

    @TableField(value = "remarks")
    private String remarks;	// 备注

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//0.暂存、待提交；1.审核中；2.已结案；9.删除。

    @TableField(value = "company_id",el="sysCompany.company_id")
    protected SysCompany sysCompany;

    @TableField(value = "register_user_id")
    private Long register_user_id;//归属账号Id

    @TableField(value = "ins_insurance_slip_id")
    private Long ins_insurance_slip_id;

    @TableField(value = "report_no")
    private String report_no;//报案号

    @TableField(value = "channel_code")
    private String channel_code;//通道号

    @TableField(value = "policy_no")
    private String policy_no;//保单号【数字且长度不能大于21位】

    @TableField(value = "reporter_name")
    private String reporter_name;//报案人姓名【不能超过21字符】

    @TableField(value = "reporter_tel")
    private String reporter_tel;//报案人手机【数字且不能大于11位】

    @TableField(value = "report_date")
    private Date report_date;//报案时间【格式yyyy-mm-dd hh24:mi:ss】

    @TableField(value = "accident_date")
    private Date accident_date;//出险时间【格式yyyy-mm-dd hh24:mi:ss】

    @TableField(value = "end_case_date")
    private Date end_case_date;//结案时间【格式yyyy-mm-dd hh24:mi:ss】

    @TableField(value = "is_overseas_accident")
    private String is_overseas_accident = "N";	//是否境外出险【Y-是 N-否】

    @TableField(value = "accident_province_code")
    private String accident_province_code;// 出险地点省代码

    @TableField(value = "accident_city_code")
    private String accident_city_code;//出险地点城市代码

    @TableField(value = "accident_county_code")
    private String accident_county_code;//出险地点区/县代码

    @TableField(value = "accident_place")
    private String accident_place;//出险地点之详细地址

    @TableField(value = "accident_process")
    private String accident_process;//出险经过

    @TableField(value = "accident_cause_level_1")
    private String accident_cause_level_1;//出险原因一级代码

    @TableField(value = "accident_cause_level_2")
    private String accident_cause_level_2;//出险原因二级代码

    @TableField(value = "is_cargo_loss")
    private String is_cargo_loss = "N";//是否物损【Y——是,N——否】

    @TableField(value = "is_injured")
    private String is_injured = "Y";//是否人伤【Y——是,N——否】

    @TableField(value = "is_carloss")
    private String is_carloss = "N";//是否车损【Y——是,N——否】

    @TableField(value = "loss_type")
    private String loss_type = "1";//损失类型【1人伤,2物损,3车损】

    @TableField(value = "injured_detail")
    private String injured_detail;//人伤类型（01-门诊，02-住院、伤残，03-死亡）多种类型，以”,”号隔开

    @TableField(value = "outpatient_list")
    private String outpatient_list;//门诊人员姓名列表，以“,”隔开

    @TableField(value = "maim_list")
    private String maim_list;//住院、任务残人员姓名列表，以“,”隔开

    @TableField(value = "demise_list")
    private String demise_list;//死亡人员姓名列表，以“,”隔开

    @TableField(value = "cargo_loss_detail")
    private String cargo_loss_detail;//物损详情，多个以“,”隔开，有物损时有值,默认传” ZRBDSP0001, ZRBDSP008”

    @TableField(value = "report_loss_sum")
    private String report_loss_sum = "1";//损失金额【非负数且最长16位】

    @TableField(value = "is_self_claim")
    private String is_self_claim = "Y";//客户意愿【Y--用户自助理赔,N--非用户自助理赔，默认传Y】

    @TableField(value = "loss_currency_code")
    private String loss_currency_code = "01";//损失币种【01 人民币02 港元  03 美元,默认传01】

    @TableField(exist = false)
    private List<InsClaimInformation> claimInformationList;//索赔资料附件

    @TableField(value = "ins_payment_info_id")
    private Long ins_payment_info_id;//银行支付信息

    /*   报案结果字段    */
    @TableField(value = "check_loss_sum")
    private BigDecimal check_loss_sum = BigDecimal.ZERO;//核损金额

    @TableField(value = "audit_status")
    private String audit_status;//案件状态【1报案成功，0报案失败】

    @TableField(value = "claim_no")
    private String claim_no;//运单号

    @TableField(value = "suggestion_text")
    private String suggestion_text;//备注【报案失败原因,返回如下对应中文描述,若报案成功此字段空】

    @TableField(value = "is_sync")
    private String is_sync;//是否线下同步（0否，1是）

    @TableField(value = "signature_path")
    private String signature_path;//签名图片地址

    @TableField(value = "saas_idcardno")
    private String saas_idcardno;//saas的用户自提交报案时记录提交人saas身份证

    @TableField(exist = false)
    private List<InsCaseInfo> caseInfoList;//报案成功案件信息

    @TableField(exist = false)
    private List<InsCaseSchedule> caseScheduleList;//案件进展与计划信息

    public String getReport_no() {
        return report_no;
    }

    public void setReport_no(String report_no) {
        this.report_no = report_no;
    }

    public String getChannel_code() {
        return channel_code;
    }

    public void setChannel_code(String channel_code) {
        this.channel_code = channel_code;
    }

    public Long getIns_common_report_id() {
        return ins_common_report_id;
    }

    public void setIns_common_report_id(Long ins_common_report_id) {
        this.ins_common_report_id = ins_common_report_id;
    }

    public Long getIdx() {
        return idx;
    }

    public void setIdx(Long idx) {
        this.idx = idx;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodex() {
        return codex;
    }

    public void setCodex(String codex) {
        this.codex = codex;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }

    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SysCompany getSysCompany() {
        return sysCompany;
    }

    public void setSysCompany(SysCompany sysCompany) {
        this.sysCompany = sysCompany;
    }

    public String getPolicy_no() {
        return policy_no;
    }

    public void setPolicy_no(String policy_no) {
        this.policy_no = policy_no;
    }

    public String getReporter_name() {
        return reporter_name;
    }

    public void setReporter_name(String reporter_name) {
        this.reporter_name = reporter_name;
    }

    public String getReporter_tel() {
        return reporter_tel;
    }

    public void setReporter_tel(String reporter_tel) {
        this.reporter_tel = reporter_tel;
    }

    public Date getReport_date() {
        return report_date;
    }

    public void setReport_date(Date report_date) {
        this.report_date = report_date;
    }

    public Date getAccident_date() {
        return accident_date;
    }

    public void setAccident_date(Date accident_date) {
        this.accident_date = accident_date;
    }

    public String getIs_overseas_accident() {
        return is_overseas_accident;
    }

    public void setIs_overseas_accident(String is_overseas_accident) {
        this.is_overseas_accident = is_overseas_accident;
    }

    public String getAccident_province_code() {
        return accident_province_code;
    }

    public void setAccident_province_code(String accident_province_code) {
        this.accident_province_code = accident_province_code;
    }

    public String getAccident_city_code() {
        return accident_city_code;
    }

    public void setAccident_city_code(String accident_city_code) {
        this.accident_city_code = accident_city_code;
    }

    public String getAccident_county_code() {
        return accident_county_code;
    }

    public void setAccident_county_code(String accident_county_code) {
        this.accident_county_code = accident_county_code;
    }

    public String getAccident_place() {
        return accident_place;
    }

    public void setAccident_place(String accident_place) {
        this.accident_place = accident_place;
    }

    public String getAccident_process() {
        return accident_process;
    }

    public void setAccident_process(String accident_process) {
        this.accident_process = accident_process;
    }

    public String getAccident_cause_level_1() {
        return accident_cause_level_1;
    }

    public void setAccident_cause_level_1(String accident_cause_level_1) {
        this.accident_cause_level_1 = accident_cause_level_1;
    }

    public String getAccident_cause_level_2() {
        return accident_cause_level_2;
    }

    public void setAccident_cause_level_2(String accident_cause_level_2) {
        this.accident_cause_level_2 = accident_cause_level_2;
    }

    public String getIs_cargo_loss() {
        return is_cargo_loss;
    }

    public void setIs_cargo_loss(String is_cargo_loss) {
        this.is_cargo_loss = is_cargo_loss;
    }

    public String getIs_injured() {
        return is_injured;
    }

    public void setIs_injured(String is_injured) {
        this.is_injured = is_injured;
    }

    public String getIs_carloss() {
        return is_carloss;
    }

    public void setIs_carloss(String is_carloss) {
        this.is_carloss = is_carloss;
    }

    public String getLoss_type() {
        return loss_type;
    }

    public void setLoss_type(String loss_type) {
        this.loss_type = loss_type;
    }

    public String getInjured_detail() {
        return injured_detail;
    }

    public void setInjured_detail(String injured_detail) {
        this.injured_detail = injured_detail;
    }

    public String getOutpatient_list() {
        return outpatient_list;
    }

    public void setOutpatient_list(String outpatient_list) {
        this.outpatient_list = outpatient_list;
    }

    public String getMaim_list() {
        return maim_list;
    }

    public void setMaim_list(String maim_list) {
        this.maim_list = maim_list;
    }

    public String getDemise_list() {
        return demise_list;
    }

    public void setDemise_list(String demise_list) {
        this.demise_list = demise_list;
    }

    public String getCargo_loss_detail() {
        return cargo_loss_detail;
    }

    public void setCargo_loss_detail(String cargo_loss_detail) {
        this.cargo_loss_detail = cargo_loss_detail;
    }

    public String getReport_loss_sum() {
        return report_loss_sum;
    }

    public void setReport_loss_sum(String report_loss_sum) {
        this.report_loss_sum = report_loss_sum;
    }

    public String getIs_self_claim() {
        return is_self_claim;
    }

    public void setIs_self_claim(String is_self_claim) {
        this.is_self_claim = is_self_claim;
    }

    public String getLoss_currency_code() {
        return loss_currency_code;
    }

    public void setLoss_currency_code(String loss_currency_code) {
        this.loss_currency_code = loss_currency_code;
    }

    public List<InsClaimInformation> getClaimInformationList() {
        return claimInformationList;
    }

    public void setClaimInformationList(List<InsClaimInformation> claimInformationList) {
        this.claimInformationList = claimInformationList;
    }

    public BigDecimal getCheck_loss_sum() {
        return check_loss_sum;
    }

    public void setCheck_loss_sum(BigDecimal check_loss_sum) {
        this.check_loss_sum = check_loss_sum;
    }

    public String getAudit_status() {
        return audit_status;
    }

    public void setAudit_status(String audit_status) {
        this.audit_status = audit_status;
    }

    public String getClaim_no() {
        return claim_no;
    }

    public void setClaim_no(String claim_no) {
        this.claim_no = claim_no;
    }

    public String getSuggestion_text() {
        return suggestion_text;
    }

    public void setSuggestion_text(String suggestion_text) {
        this.suggestion_text = suggestion_text;
    }

    public List<InsCaseInfo> getCaseInfoList() {
        return caseInfoList;
    }

    public void setCaseInfoList(List<InsCaseInfo> caseInfoList) {
        this.caseInfoList = caseInfoList;
    }

    public List<InsCaseSchedule> getCaseScheduleList() {
        return caseScheduleList;
    }

    public void setCaseScheduleList(List<InsCaseSchedule> caseScheduleList) {
        this.caseScheduleList = caseScheduleList;
    }

    public Long getRegister_user_id() {
        return register_user_id;
    }

    public void setRegister_user_id(Long register_user_id) {
        this.register_user_id = register_user_id;
    }

    public Long getIns_insurance_slip_id() {
        return ins_insurance_slip_id;
    }

    public void setIns_insurance_slip_id(Long ins_insurance_slip_id) {
        this.ins_insurance_slip_id = ins_insurance_slip_id;
    }

    public Long getIns_payment_info_id() {
        return ins_payment_info_id;
    }

    public void setIns_payment_info_id(Long ins_payment_info_id) {
        this.ins_payment_info_id = ins_payment_info_id;
    }

    public Date getEnd_case_date() {
        return end_case_date;
    }

    public void setEnd_case_date(Date end_case_date) {
        this.end_case_date = end_case_date;
    }

    public String getIs_sync() {
        return is_sync;
    }

    public void setIs_sync(String is_sync) {
        this.is_sync = is_sync;
    }

    public String getSignature_path() {
        return signature_path;
    }

    public void setSignature_path(String signature_path) {
        this.signature_path = signature_path;
    }

    public String getSaas_idcardno() {
        return saas_idcardno;
    }

    public void setSaas_idcardno(String saas_idcardno) {
        this.saas_idcardno = saas_idcardno;
    }
}