package com.bcxin.ins.entity.policy_core;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <b>企业短期信用险特殊字段表-投保人/被保险人 </b>
 *
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@TableName("ins_role_inpolicy")
public class InsRoleInpolicy implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long ins_role_inpolicy_id;

    @TableField(value = "idx")
    private Long idx;

    @TableField(value = "code")
    private String code;

    @TableField(value = "codex")
    private String codex;

    /**
     * 对应用户id
     */
    @TableField(value = "client_user_id")
    private Long client_user_id;

    @TableField(value = "remarks")
    private String remarks;	// 备注

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//

    @TableField(value = "company_id",el="sysCompany.company_id")
    protected SysCompany sysCompany;

    @TableField(value = "kind")
    private String kind;  //1投保人，2被保险人

    @TableField(value = "role_type")
    private String role_type;//展责险1：参展商；2：搭建商

    @TableField(value = "related_to_insured")
    private String related_to_insured;

    @TableField(value = "insurance_slip_id",el="insurance_slip.ins_insurance_slip_id")
    private InsInsuranceSlip insurance_slip = new InsInsuranceSlip();

    @TableField(value = "name_cn")
    private String name_cn;

    @TableField(value = "name_en")
    private String name_en;

    /*@TableField(value = "role_detail_id")
    private Long role_detail_id;*/

    /**
     * 企业信息/个人信息
     */
    @TableField(exist = false)
    private Map<String,Object> mapDetail = new HashMap<String,Object>();
    /**
     * 受益人信息
     */
    @TableField(exist = false)
    private List<InsRoleFavoree> insRoleFavoreeList;

    @TableField(value = "app_idcard_path")
    private String app_idcard_path;

    /**
     * 身份证复印件（反面）
     */
    @TableField(value = "app_idcard_versa_path")
    private  String app_idcard_versa_path;

    @TableField(value = "app_address_path")
    private String app_address_path;

    @TableField(value = "app_spouse_card_path")
    private String app_spouse_card_path;

    @TableField(value = "app_trauschein_path")
    private String app_trauschein_path;

    @TableField(value = "app_business_path")
    private String app_business_path;

    @TableField(value = "app_organizing_path")
    private String app_organizing_path;

    @TableField(value = "app_tax_path")
    private String app_tax_path;

    @TableField(value = "id_type")
    private String id_type;

    @TableField(value = "address")
    private String address;

    @TableField(value = "phone")
    private String phone;

    @TableField(value = "tel")
    private String tel;

    @TableField(value = "email")
    private String email;

    @TableField(value = "reg_address")
    private String reg_address;

    @TableField(value = "do_business_address")
    private String do_business_address;

    /**
     * 联系人手机
     */
    @TableField(value = "link_tel")
    private String link_tel;

    @TableField(value = "region")
    private String region;

    @TableField(value = "organization_code")
    private String organization_code;

    @TableField(value = "tax_code")
    private String tax_code;

    @TableField(value = "aaum_code")
    private String aaum_code;

    @TableField(value = "customs_code")
    private String customs_code;

    @TableField(value = "com_type")
    private String com_type;

    @TableField(value = "business_nature")
    private String business_nature;

    @TableField(value = "sectors_sold")
    private String sectors_sold;

    @TableField(value = "companies_detail")
    private String companies_detail;

    @TableField(value = "id_insurance")
    private String id_insurance;

    @TableField(value = "insurance_name")
    private String insurance_name;

    @TableField(value = "turnover_domestic")
    private String turnover_domestic;

    @TableField(value = "turnover_export")
    private String turnover_export;

    @TableField(value = "currency_required")
    private String currency_required;

    @TableField(value = "com_nature")
    private String com_nature;

    /**
     * 经营性质(营业性质2级)
     */
    @TableField(value = "nature_two")
    private String nature_two;

    /**
     * 经营区域
     */
    @TableField(value = "business_area")
    private String business_area;
    /**
     * 证件有效期起始
     */
    @TableField(value = "id_option")
    private String id_option;
    /**
     * 证件有效期起期
     */
    @TableField(value = "id_star_date")
    private String id_star_date;
    /**
     * 证件有效期止期
     */
    @TableField(value = "id_end_date")
    private String id_end_date;
    /**
     * 联系部门
     */
    @TableField(value = "link_section")
    private String link_section;

    @TableField(value = "industry")
    private String industry;

    @TableField(value = "other_industry")
    private String other_industry;

    @TableField(value = "legal_name")
    private String legal_name;

    @TableField(value = "legal_duty")
    private String legal_duty;

    @TableField(value = "legal_phone")
    private String legal_phone;

    @TableField(value = "agent_name")
    private String agent_name;

    @TableField(value = "agent_duty")
    private String agent_duty;

    @TableField(value = "agent_phone")
    private String agent_phone;

    @TableField(value = "agent_email")
    private String agent_email;

    @TableField(value = "link_name")
    private String link_name;

    @TableField(value = "link_duty")
    private String link_duty;

    @TableField(value = "link_fax")
    private String link_fax;

    @TableField(value = "link_phone")
    private String link_phone;

    @TableField(value = "link_email")
    private String link_email;

    @TableField(value = "zip_code")
    private String zip_code;

    @TableField(value = "right_as_principal")
    private String right_as_principal;

    @TableField(value = "nationality")
    private String nationality;

    /**********************退保账户信息*************************/

    /**
     * 开户名
     */
    @TableField(value = "account_name")
    private String account_name;

    /**
     * 账户开户行
     */
    @TableField(value = "bank_name")
    private String bank_name;

    /**
     * 银行账号
     */
    @TableField(value = "bank_account")
    private String bank_account;

    /**
     * 账户开户类型
     */
    @TableField(value = "bank_pub_pri")
    private String bank_pub_pri;

    /**
     * 开户省
     */
    @TableField(value = "bank_province")
    private String bank_province;
    /**
     * 开户市
     */
    @TableField(value = "bank_city")
    private String bank_city;
    /**
     * 账户银行类型
     */
    @TableField(value = "bank_type")
    private String bank_type;
    /**
     * 开户地址
     */
    @TableField(value = "bank_addr")
    private String bank_addr;

    @TableField(value = "id_no")
    private String id_no;

    @TableField(value = "sex")
    private String sex;

    /**
     * 职业类别"内勤人员-1", "保安人员-2","武装押运人员-3","保洁人员-4（平安雇主用）"
     */
    @TableField(value = "major_group")
    private String major_group;

    @TableField(value = "province")
    private String province;

    @TableField(value = "city")
    private String city;

    @TableField(value = "area_code")
    private String area_code;

    @TableField(value = "register_date")
    private String register_date;

    @TableField(value = "validity_end")
    private String validity_end;

    @TableField(value = "birth_date")
    private String birth_date;

    @TableField(value = "stature")
    private String stature;

    @TableField(value = "weight")
    private String weight;

    //健康状况
    @TableField(value = "health")
    private String health;

    //是否参加医疗 0：否 1：是
    @TableField(value = "health_flag")
    private String health_flag;

    @TableField(value = "annual_income")
    private String annual_income;

    @TableField(value = "coverage_sum")
    private String coverage_sum;

    @TableField(value = "mobile")
    private String mobile;

    @TableField(value = "reg_province")
    private String reg_province;

    @TableField(value = "reg_city")
    private String reg_city;

    @TableField(value = "reg_district")
    private String reg_district;

    @TableField(value = "total_emp")
    private String total_emp;

    public Long getIns_role_inpolicy_id() {
        return ins_role_inpolicy_id;
    }

    public void setIns_role_inpolicy_id(Long ins_role_inpolicy_id) {
        this.ins_role_inpolicy_id = ins_role_inpolicy_id;
    }

    public Long getIdx() {
        return idx;
    }

    public void setIdx(Long idx) {
        this.idx = idx;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodex() {
        return codex;
    }

    public void setCodex(String codex) {
        this.codex = codex;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }

    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SysCompany getSysCompany() {
        return sysCompany;
    }

    public void setSysCompany(SysCompany sysCompany) {
        this.sysCompany = sysCompany;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getRole_type() {
        return role_type;
    }

    public void setRole_type(String role_type) {
        this.role_type = role_type;
    }

    public String getRelated_to_insured() {
        return related_to_insured;
    }

    public void setRelated_to_insured(String related_to_insured) {
        this.related_to_insured = related_to_insured;
    }

    public InsInsuranceSlip getInsurance_slip() {
        return insurance_slip;
    }

    public void setInsurance_slip(InsInsuranceSlip insurance_slip) {
        this.insurance_slip = insurance_slip;
    }

    public String getName_cn() {
        return name_cn;
    }

    public void setName_cn(String name_cn) {
        this.name_cn = name_cn;
    }

    public String getName_en() {
        return name_en;
    }

    public void setName_en(String name_en) {
        this.name_en = name_en;
    }

    public Map<String, Object> getMapDetail() {
        return mapDetail;
    }

    public void setMapDetail(Map<String, Object> mapDetail) {
        this.mapDetail = mapDetail;
    }

    public List<InsRoleFavoree> getInsRoleFavoreeList() {
        return insRoleFavoreeList;
    }

    public void setInsRoleFavoreeList(List<InsRoleFavoree> insRoleFavoreeList) {
        this.insRoleFavoreeList = insRoleFavoreeList;
    }

    public String getApp_idcard_path() {
        return app_idcard_path;
    }

    public void setApp_idcard_path(String app_idcard_path) {
        this.app_idcard_path = app_idcard_path;
    }

    public String getApp_address_path() {
        return app_address_path;
    }

    public void setApp_address_path(String app_address_path) {
        this.app_address_path = app_address_path;
    }

    public String getApp_spouse_card_path() {
        return app_spouse_card_path;
    }

    public void setApp_spouse_card_path(String app_spouse_card_path) {
        this.app_spouse_card_path = app_spouse_card_path;
    }

    public String getApp_trauschein_path() {
        return app_trauschein_path;
    }

    public void setApp_trauschein_path(String app_trauschein_path) {
        this.app_trauschein_path = app_trauschein_path;
    }

    public String getApp_business_path() {
        return app_business_path;
    }

    public void setApp_business_path(String app_business_path) {
        this.app_business_path = app_business_path;
    }

    public String getApp_organizing_path() {
        return app_organizing_path;
    }

    public void setApp_organizing_path(String app_organizing_path) {
        this.app_organizing_path = app_organizing_path;
    }

    public String getApp_tax_path() {
        return app_tax_path;
    }

    public void setApp_tax_path(String app_tax_path) {
        this.app_tax_path = app_tax_path;
    }

    public String getId_type() {
        return id_type;
    }

    public void setId_type(String id_type) {
        this.id_type = id_type;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getReg_address() {
        return reg_address;
    }

    public void setReg_address(String reg_address) {
        this.reg_address = reg_address;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getOrganization_code() {
        return organization_code;
    }

    public void setOrganization_code(String organization_code) {
        this.organization_code = organization_code;
    }

    public String getTax_code() {
        return tax_code;
    }

    public void setTax_code(String tax_code) {
        this.tax_code = tax_code;
    }

    public String getAaum_code() {
        return aaum_code;
    }

    public void setAaum_code(String aaum_code) {
        this.aaum_code = aaum_code;
    }

    public String getCustoms_code() {
        return customs_code;
    }

    public void setCustoms_code(String customs_code) {
        this.customs_code = customs_code;
    }

    public String getCom_type() {
        return com_type;
    }

    public void setCom_type(String com_type) {
        this.com_type = com_type;
    }

    public String getBusiness_nature() {
        return business_nature;
    }

    public void setBusiness_nature(String business_nature) {
        this.business_nature = business_nature;
    }

    public String getSectors_sold() {
        return sectors_sold;
    }

    public void setSectors_sold(String sectors_sold) {
        this.sectors_sold = sectors_sold;
    }

    public String getCompanies_detail() {
        return companies_detail;
    }

    public void setCompanies_detail(String companies_detail) {
        this.companies_detail = companies_detail;
    }

    public String getId_insurance() {
        return id_insurance;
    }

    public void setId_insurance(String id_insurance) {
        this.id_insurance = id_insurance;
    }

    public String getInsurance_name() {
        return insurance_name;
    }

    public void setInsurance_name(String insurance_name) {
        this.insurance_name = insurance_name;
    }

    public String getTurnover_domestic() {
        return turnover_domestic;
    }

    public void setTurnover_domestic(String turnover_domestic) {
        this.turnover_domestic = turnover_domestic;
    }

    public String getTurnover_export() {
        return turnover_export;
    }

    public void setTurnover_export(String turnover_export) {
        this.turnover_export = turnover_export;
    }

    public String getCurrency_required() {
        return currency_required;
    }

    public void setCurrency_required(String currency_required) {
        this.currency_required = currency_required;
    }

    public String getCom_nature() {
        return com_nature;
    }

    public void setCom_nature(String com_nature) {
        this.com_nature = com_nature;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getOther_industry() {
        return other_industry;
    }

    public void setOther_industry(String other_industry) {
        this.other_industry = other_industry;
    }

    public String getLegal_name() {
        return legal_name;
    }

    public void setLegal_name(String legal_name) {
        this.legal_name = legal_name;
    }

    public String getLegal_duty() {
        return legal_duty;
    }

    public void setLegal_duty(String legal_duty) {
        this.legal_duty = legal_duty;
    }

    public String getLegal_phone() {
        return legal_phone;
    }

    public void setLegal_phone(String legal_phone) {
        this.legal_phone = legal_phone;
    }

    public String getAgent_name() {
        return agent_name;
    }

    public void setAgent_name(String agent_name) {
        this.agent_name = agent_name;
    }

    public String getAgent_duty() {
        return agent_duty;
    }

    public void setAgent_duty(String agent_duty) {
        this.agent_duty = agent_duty;
    }

    public String getAgent_phone() {
        return agent_phone;
    }

    public void setAgent_phone(String agent_phone) {
        this.agent_phone = agent_phone;
    }

    public String getAgent_email() {
        return agent_email;
    }

    public void setAgent_email(String agent_email) {
        this.agent_email = agent_email;
    }

    public String getLink_name() {
        return link_name;
    }

    public void setLink_name(String link_name) {
        this.link_name = link_name;
    }

    public String getLink_duty() {
        return link_duty;
    }

    public void setLink_duty(String link_duty) {
        this.link_duty = link_duty;
    }

    public String getLink_fax() {
        return link_fax;
    }

    public void setLink_fax(String link_fax) {
        this.link_fax = link_fax;
    }

    public String getLink_phone() {
        return link_phone;
    }

    public void setLink_phone(String link_phone) {
        this.link_phone = link_phone;
    }

    public String getLink_email() {
        return link_email;
    }

    public void setLink_email(String link_email) {
        this.link_email = link_email;
    }

    public String getZip_code() {
        return zip_code;
    }

    public void setZip_code(String zip_code) {
        this.zip_code = zip_code;
    }

    public String getRight_as_principal() {
        return right_as_principal;
    }

    public void setRight_as_principal(String right_as_principal) {
        this.right_as_principal = right_as_principal;
    }

    public String getNationality() {
        return nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public String getId_no() {
        return id_no;
    }

    public void setId_no(String id_no) {
        this.id_no = id_no;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getMajor_group() {
        return major_group;
    }

    public void setMajor_group(String major_group) {
        this.major_group = major_group;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea_code() {
        return area_code;
    }

    public void setArea_code(String area_code) {
        this.area_code = area_code;
    }

    public String getRegister_date() {
        return register_date;
    }

    public void setRegister_date(String register_date) {
        this.register_date = register_date;
    }

    public String getValidity_end() {
        return validity_end;
    }

    public void setValidity_end(String validity_end) {
        this.validity_end = validity_end;
    }

    public String getBirth_date() {
        return birth_date;
    }

    public void setBirth_date(String birth_date) {
        this.birth_date = birth_date;
    }

    public String getStature() {
        return stature;
    }

    public void setStature(String stature) {
        this.stature = stature;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getAnnual_income() {
        return annual_income;
    }

    public void setAnnual_income(String annual_income) {
        this.annual_income = annual_income;
    }

    public String getCoverage_sum() {
        return coverage_sum;
    }

    public void setCoverage_sum(String coverage_sum) {
        this.coverage_sum = coverage_sum;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getReg_province() {
        return reg_province;
    }

    public void setReg_province(String reg_province) {
        this.reg_province = reg_province;
    }

    public String getReg_city() {
        return reg_city;
    }

    public void setReg_city(String reg_city) {
        this.reg_city = reg_city;
    }

    public String getReg_district() {
        return reg_district;
    }

    public void setReg_district(String reg_district) {
        this.reg_district = reg_district;
    }

    public String getNature_two() {
        return nature_two;
    }

    public void setNature_two(String nature_two) {
        this.nature_two = nature_two;
    }

    public String getBusiness_area() {
        return business_area;
    }

    public void setBusiness_area(String business_area) {
        this.business_area = business_area;
    }

    public String getId_option() {
        return id_option;
    }

    public void setId_option(String id_option) {
        this.id_option = id_option;
    }

    public String getId_star_date() {
        return id_star_date;
    }

    public void setId_star_date(String id_star_date) {
        this.id_star_date = id_star_date;
    }

    public String getId_end_date() {
        return id_end_date;
    }

    public void setId_end_date(String id_end_date) {
        this.id_end_date = id_end_date;
    }

    public String getLink_section() {
        return link_section;
    }

    public void setLink_section(String link_section) {
        this.link_section = link_section;
    }

    public Long getClient_user_id() {
        return client_user_id;
    }

    public void setClient_user_id(Long client_user_id) {
        this.client_user_id = client_user_id;
    }

    public String getDo_business_address() {
        return do_business_address;
    }

    public void setDo_business_address(String do_business_address) {
        this.do_business_address = do_business_address;
    }

    public String getLink_tel() {
        return link_tel;
    }

    public void setLink_tel(String link_tel) {
        this.link_tel = link_tel;
    }

    public String getTotal_emp() {
        return total_emp;
    }

    public void setTotal_emp(String total_emp) {
        this.total_emp = total_emp;
    }

    public String getApp_idcard_versa_path() {
        return app_idcard_versa_path;
    }

    public void setApp_idcard_versa_path(String app_idcard_versa_path) {
        this.app_idcard_versa_path = app_idcard_versa_path;
    }

    public String getAccount_name() {
        return account_name;
    }

    public void setAccount_name(String account_name) {
        this.account_name = account_name;
    }

    public String getBank_name() {
        return bank_name;
    }

    public void setBank_name(String bank_name) {
        this.bank_name = bank_name;
    }

    public String getBank_account() {
        return bank_account;
    }

    public void setBank_account(String bank_account) {
        this.bank_account = bank_account;
    }

    public String getBank_pub_pri() {
        return bank_pub_pri;
    }

    public void setBank_pub_pri(String bank_pub_pri) {
        this.bank_pub_pri = bank_pub_pri;
    }

    public String getBank_province() {
        return bank_province;
    }

    public void setBank_province(String bank_province) {
        this.bank_province = bank_province;
    }

    public String getBank_city() {
        return bank_city;
    }

    public void setBank_city(String bank_city) {
        this.bank_city = bank_city;
    }

    public String getBank_type() {
        return bank_type;
    }

    public void setBank_type(String bank_type) {
        this.bank_type = bank_type;
    }

    public String getBank_addr() {
        return bank_addr;
    }

    public void setBank_addr(String bank_addr) {
        this.bank_addr = bank_addr;
    }

    public String getHealth() {
        return health;
    }

    public void setHealth(String health) {
        this.health = health;
    }

    public String getHealth_flag() {
        return health_flag;
    }

    public void setHealth_flag(String health_flag) {
        this.health_flag = health_flag;
    }
}