package com.bcxin.ins.entity.policy_core;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.bcxin.mybatisplus.toolkit.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 保全详情
 */
@TableName("ins_preservation_detail")
public class InsPreservationDetail implements Serializable {

    /**
     * id
     */
    @TableId(type = IdType.ID_WORKER)
    private Long ins_preservation_detail_id;

    /**
     * 保全记录表id
     */
    @TableField(value = "ins_preservation_record_id")
    private Long ins_preservation_record_id;

    /**
     * 批改时间
     */
    @TableField(value = "revise_time")
    private Date revise_time;

    /**
     * 批改类型
     */
    @TableField(value = "revise_type")
    private String revise_type;

    /**
     * 姓名
     */
    @TableField(value = "name")
    private String name;

    /**
     * 身份证号
     */
    @TableField(value = "id_card")
    private String id_card;

    /**
     * 出生年月
     */
    @TableField(value = "birthday")
    private String birthday;

    /**
     * 证件类型
     */
    @TableField(value = "id_type")
    private String id_type;

    /**
     * 职业类别
     */
    @TableField(value = "career")
    private String career;

    /**
     * 方案
     */
    @TableField(value = "scheme")
    private String scheme;


    /**
     * 性别
     */
    @TableField(value = "sex")
    private String sex;

    /**
     * 手机号码
     */
    @TableField(value = "tel")
    private String tel;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 标记状态
     */
    @TableField(value = "status")
    private int status;

    /**
     * 来源id
     */
    @TableField(value = "business_id")
    private Long business_id;

    /**
     * 来源标识
     */
    @TableField(value = "business_type")
    private String business_type;

    /**
     * 相对当前最新结果集所关联的保全单id
     */
    @TableField(value = "prev_record_id")
    private Long prev_record_id;

    /**
     * 相对当前最新结果集对应替换或减员的对象的身份证号
     */
    @TableField(value = "prev_card")
    private String prev_card;

    public Long getIns_preservation_detail_id() {
        return ins_preservation_detail_id;
    }


    public void setIns_preservation_detail_id(Long ins_preservation_detail_id) {
        this.ins_preservation_detail_id = ins_preservation_detail_id;
    }

    public Long getIns_preservation_record_id() {
        return ins_preservation_record_id;
    }

    public void setIns_preservation_record_id(Long ins_preservation_record_id) {
        this.ins_preservation_record_id = ins_preservation_record_id;
    }

    public Date getRevise_time() {
        return revise_time;
    }

    public void setRevise_time(Date revise_time) {
        this.revise_time = revise_time;
    }

    public String getRevise_type() {
        return revise_type;
    }

    public void setRevise_type(String revise_type) {
        this.revise_type = revise_type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId_card() {
        return id_card;
    }

    public void setId_card(String id_card) {
        this.id_card = id_card;
    }

    public String getBirthday() {
        if(StringUtils.isNotEmpty(birthday)){
            if(birthday.length()>10){
                return birthday.substring(0,10);
            }
        }
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getId_type() {
        return id_type;
    }

    public void setId_type(String id_type) {
        this.id_type = id_type;
    }

    public String getCareer() {
        return career;
    }

    public void setCareer(String career) {
        this.career = career;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Long getBusiness_id() {
        return business_id;
    }

    public void setBusiness_id(Long business_id) {
        this.business_id = business_id;
    }

    public String getBusiness_type() {
        return business_type;
    }

    public void setBusiness_type(String business_type) {
        this.business_type = business_type;
    }

    public String getScheme() {
        return scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public Long getPrev_record_id() {
        return prev_record_id;
    }

    public void setPrev_record_id(Long prev_record_id) {
        this.prev_record_id = prev_record_id;
    }

    public String getPrev_card() {
        return prev_card;
    }

    public void setPrev_card(String prev_card) {
        this.prev_card = prev_card;
    }
}