package com.bcxin.ins.entity.common;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <b>未见费核保记录表（用于补承保） </b>
 * 例：中华雇主险有用户投10万保费，需要线下转账线上做未见费出单，这个时候需要在核保返回报文截取以下对象相关字段数据做保存，用于补承保业务
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@TableName("com_task_un_see_fee_record")
public class ComTaskUnSeeFeeRecord implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long com_task_un_see_fee_record_id;
    /**    投保单号     */
    @TableField(value = "appno")
    private String appno;
    /**    保单号     */
    @TableField(value = "polno")
    private String polno;
    /**    电子保单地址     */
    @TableField(value = "eurl")
    private String eurl;
    /**    创建时间     */
    @TableField(value = "create_time")
    private Date create_time;

    public ComTaskUnSeeFeeRecord(){}

    public ComTaskUnSeeFeeRecord(String appno, String polno, String eurl){
        this.appno = appno;
        this.polno = polno;
        this.eurl = eurl;
        this.create_time = new Date();
    }

    public Long getCom_task_un_see_fee_record_id() {
        return com_task_un_see_fee_record_id;
    }

    public void setCom_task_un_see_fee_record_id(Long com_task_un_see_fee_record_id) {
        this.com_task_un_see_fee_record_id = com_task_un_see_fee_record_id;
    }

    public String getAppno() {
        return appno;
    }

    public void setAppno(String appno) {
        this.appno = appno;
    }

    public String getPolno() {
        return polno;
    }

    public void setPolno(String polno) {
        this.polno = polno;
    }

    public String getEurl() {
        return eurl;
    }

    public void setEurl(String eurl) {
        this.eurl = eurl;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }
}