package com.bcxin.ins.entity.common;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 定时任务配置类 </b>
 * @author ZXF
 * @create 2018/10/16 0016 13:54
 * @version
 * @注意事项 </b>
 */
@TableName("com_task_cron")
public class ComTaskCron implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long com_task_cron_id;
    /**
     * 任务名称
     */
    @TableField("name")
    private String name;

    /**
     * 执行对象
     */
    @TableField("target_object")
    private String target_object;

    /**
     * 执行方法名称
     */
    @TableField("task_method")
    private String task_method;

    /**
     * 执行率
     */
    @TableField("cron_expression")
    private String cron_expression;

    @TableField(value = "create_time")
    protected Date create_time;	// 创建日期

    @TableField(value = "update_time")
    protected Date update_time;	// 更新日期

    /**
     * 是否启动
     */
    private transient boolean isStart;

    /**
     * 查询用实体
     */
    private transient ComTaskCron taskCron;

    @TableField(value = "status")
    protected Integer status; 	// 	/** 状态：0.冻结；1.正常 2删除 */

    @TableField(exist = false)
    public static final Integer DEL_FLAG_NORMAL = 1;
    @TableField(exist = false)
    public static final Integer DEL_FLAG_DELETE = 0;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getCom_task_cron_id() {
        return com_task_cron_id;
    }

    public void setCom_task_cron_id(Long com_task_cron_id) {
        this.com_task_cron_id = com_task_cron_id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTarget_object() {
        return target_object;
    }

    public void setTarget_object(String target_object) {
        this.target_object = target_object;
    }

    public String getTask_method() {
        return task_method;
    }

    public void setTask_method(String task_method) {
        this.task_method = task_method;
    }

    public String getCron_expression() {
        return cron_expression;
    }

    public void setCron_expression(String cron_expression) {
        this.cron_expression = cron_expression;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public boolean getIsStart() {
        return isStart;
    }

    public void setIsStart(boolean isStart) {
        this.isStart = isStart;
    }

    public ComTaskCron getTaskCron() {
        return taskCron;
    }

    public void setTaskCron(ComTaskCron taskCron) {
        this.taskCron = taskCron;
    }

    public Integer getStatus() {
        if(status==null){
            status=DEL_FLAG_NORMAL;
            //-1表示全部
        }else if(status==-1){
            status=null;
        }
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
