package com.bcxin.ins.dto;

import javax.servlet.http.HttpServletRequest;

/**
* 类名称：AjaxResult   
* 类描述：全局配置类  
* 创建人：liujinju
* @version    
*
*/
public class Result {

	private String api;// 接口名称
	private String v;// 版本号
	private String retType = "0";// 状态码
	private Object data;// 返回数据对象
	private String msg = SUCCESS_MSG;// 返回信息
	/**
	 * 成功
	 */
	public static final String SUCCESS = "0";

	/**
	 * 服务端内部错误
	 */
	public static final String ERROR = "-1";

	/**
	 * 请求token过期
	 */
	public static final String TOKEN_EXPIRED = "1";

	/**
	 * 成功消息
	 */
	public static final String SUCCESS_MSG = "操作成功！";
	/**
	 * 失败消息
	 */
	public static final String ERROR_MSG = "操作失败:";

	public Result() {
		super();
	}

	/**
	 * @param retType    结果状态码
	 * @param message 响应结果描述
	 * @param data    成功时返回的数据结果
	 */
	private Result(String v, String api, String retType, String message, Object data) {
		super();
		this.v = v;
		this.api = api;
		this.retType = retType;
		this.msg = message;
		this.data = data;
	}

	/**
	 * 成功信息返回
	 *
	 * @param request
	 * @param successMsg
	 * @param data
	 * @return
	 */
	public static Result success(HttpServletRequest request, String successMsg, Object data) {
		return new Result(request.getParameter("v"), request.getParameter("api"), Result.SUCCESS,
				(successMsg == null || successMsg.equals("")) ? Result.SUCCESS_MSG : successMsg, data);
	}

	/**
	 * 错误信息返回
	 *
	 * @param request
	 * @param errorMsg
	 * @param data
	 * @return
	 */
	public static Result fail(HttpServletRequest request, String errorMsg, Object data) {
		return new Result(request.getParameter("v"), request.getParameter("api"), Result.ERROR,
				(errorMsg == null || errorMsg.equals("")) ? Result.ERROR_MSG : errorMsg, data);
	}

	/**
	 * 成功信息返回
	 *
	 * @param successMsg
	 * @param data
	 * @return
	 */
	public static Result success(String successMsg, Object data) {
		return new Result("", "", Result.SUCCESS,
				(successMsg == null || successMsg.equals("")) ? Result.SUCCESS_MSG : successMsg, data);
	}

	/**
	 * 错误信息返回
	 *
	 * @param errorMsg
	 * @param data
	 * @return
	 */
	public static Result fail(String errorMsg, Object data) {
		return new Result("", "", Result.ERROR,
				(errorMsg == null || errorMsg.equals("")) ? Result.ERROR_MSG : errorMsg, data);
	}

	/**
	 * 成功信息返回
	 *
	 * @param successMsg
	 * @return
	 */
	public static Result success(String successMsg) {
		return new Result("", "", Result.SUCCESS,
				(successMsg == null || successMsg.equals("")) ? Result.SUCCESS_MSG : successMsg, null);
	}

	/**
	 * 错误信息返回
	 *
	 * @param errorMsg
	 * @return
	 */
	public static Result fail(String errorMsg) {
		return new Result("", "", Result.ERROR,
				(errorMsg == null || errorMsg.equals("")) ? Result.ERROR_MSG : errorMsg, null);
	}

	/**
	 * 请求token过期
	 *
	 * @param errorMsg
	 * @return
	 */
	public static Result tokenExpired(String errorMsg) {
		return new Result("", "", Result.TOKEN_EXPIRED,
				(errorMsg == null || errorMsg.equals("")) ? Result.ERROR_MSG : errorMsg, null);
	}

	public Result setBack(HttpServletRequest request) {
		this.setApi(request.getParameter("api"));
		this.setV(request.getParameter("v"));
		return this;
	}

	public String getRetType() {
		return retType;
	}

	public void setRetType(String retType) {
		this.retType = retType;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public String getApi() {
		return api;
	}

	public void setApi(String api) {
		this.api = api;
	}

	public String getV() {
		return v;
	}

	public void setV(String v) {
		this.v = v;
	}
}
