<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <title>订单详情</title>
</head>
<body id="container">
<%--过度动画--%>
<div id="mask">
    <div class="main">
        <div class="loading">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <div class="black-mask-my"></div>
</div>
<div class="arment-head">
    <div class="arment-left" >
        <a href="/weixin/order/order_list">
            <img src="/static/weChat/images/arment-left.png"/>
        </a>
    </div>
    <p>订单详情</p>
</div>
<div class="order-particulars">
    <div class="order">
        <h2>
            <p>订单号：${row.trade_serial_number}</p>
            <span>${fns:getDictLabel (row.order_status,"order_status","")}</span>
        </h2>
        <div class="list-wed">
            <div class="list-cont">
                <p>${row.insurance_name}</p>
                <span>起保日期：${row.inception_date}</span>
                <span id="ins_period">保险期限：最多15天</span>
            </div>
        </div>
    </div>
    <div id="afterPayDiv" class="particul">
        <ul class="particul-cont">
            <li>
                <p>保单号</p>
                <span>${row.ins_agreement.external_reference}</span>
            </li>
            <li id="down_dzbd">
                <p>保单下载</p>
                <c:if test="${row.ins_agreement.insure_path!=null}">
                    <a style="position: relative; top: 28px;font-size: 28px;" href="${row.ins_agreement.insure_path}">点击下载</a>
                </c:if>
            </li>
            <li>
                <p>投保时间</p>
                <span>${fn:split(row.signed_date, '.')[0]}</span>
            </li>
            <li>
                <p>支付方式</p>
                <span>${fns:getDictLabel (row.pay_type,"pay_type","")}</span>
            </li>
            <li>
                <p>支付流水号</p>
                <span id="order-liu">
                    <c:forEach items="${row.transactionList}" var="list">
                        ${list.trade_serial_number} &nbsp;
                    </c:forEach>
                </span>
            </li>
        </ul>
    </div>
    <div class="particul">
        <h2>投保人信息</h2>
        <ul class="particul-cont">
            <li>
                <p>投保人类型</p>
                <span id="applicant_role_type"></span>
            </li>
            <li>
                <p>企业名称</p>
                <span>${row.applicant.name_cn}</span>
            </li>
            <li>
                <p>地址</p>
                <span class="show_all_text">${row.area} ${row.applicant.address}</span>
            </li>
            <li>
                <p>证件类型</p>
                <span id="id_type_show"></span>
            </li>
            <li>
                <p>证件号</p>
                <span>${row.applicant.organization_code}</span>
            </li>
            <li>
                <p>联系人</p>
                <span>${row.applicant.link_name}</span>
            </li>
            <li>
                <p>手机号</p>
                <span>${row.applicant.link_tel}</span>
            </li>
            <li>
                <p>邮箱</p>
                <span>${row.applicant.link_email}</span>
            </li>
        </ul>
    </div>
    <div class="particul">
        <h2>被保险人信息</h2>
        <ul class="particul-cont">
            <li>
                <p id="p_p_1">名称</p>
                <span>${row.insurant.name_cn}</span>
            </li>
            <li>
                <p id="p_p_2">证件类型</p>
                <span id="id_type_show2"></span>
            </li>
            <li>
                <p id="p_p_3">证件号</p>
                <span>${row.insurant.organization_code}</span>
            </li>
        </ul>
    </div>
    <div class="particul particul-bott" style="padding-bottom:120px;">
        <h2>投保基本信息</h2>
        <ul class="particul-cont">
            <li>
                <p>展会名称</p>
                <span>${row.special.name}</span>
            </li>
            <li>
                <p>是否包含拆搭建</p>
                <span>${row.special.contains eq '0'? '否' : '是'}</span>
            </li>
            <li>
                <p>保障开始时间</p>
                <span>${row.special.star_time}</span>
            </li>
            <li>
                <p>保障结束时间</p>
                <span>${row.special.end_time}</span>
            </li>
            <li>
                <p>举办地址</p>
                <span  class="show_all_text">${row.ex_area}  ${row.special.ex_address}</span>
            </li>
            <li style="${row.special.contains eq '0' ? 'display: none;' : ''}">
                <p>搭建公司</p>
                <span  class="show_all_text">${row.special.build_com_name}</span>
            </li>
            <li style="${row.special.contains eq '0' ? 'display: none;' : ''}">
                <p>转包单位</p>
                <span  class="show_all_text">${row.special.subcontracting_units}</span>
            </li>
            <li id="special_exhibitor_name" style="display: none;">
                <p>参展商名称</p>
                <span>${row.special.exhibitor_name}</span>
            </li>
            <li>
                <p>展位号</p>
                <span>${row.special.ex_no}</span>
            </li>
            <li>
                <p>展位总面积</p>
                <span>${row.special.ex_acreage} 平方米</span>
            </li>
            <li>
                <p>司法管辖</p>
                <span class="xia">中华人民共和国司法管辖</span>
            </li>
            <%--<li>--%>
            <%--<p>争议处理</p>--%>
            <%--<div class="dispute-processing">--%>
            <%--<img src="/static/weChat/images/instruction.png" />--%>
            <%--<span>诉讼</span>--%>
            <%--<div class="litigation">--%>
            <%--<i>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式.</i>--%>
            <%--</div>--%>
            <%--</div>--%>
            <%--</li>--%>
            <li>
                <p>争议处理</p>
                <div class="dispute-processing">
                    <img src="/static/weChat/images/instruction.png" />
                    <span id="dispute"><%--${row.special.dispute}--%></span>
                    <div class="litigation">
                        <i>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式.</i>
                    </div>
                </div>
            </li>
            <li id="arbitral_institution_div">
                <p>仲裁机构</p>
                <span>${row.special.arbitral_institution}</span>
            </li>
        </ul>
    </div>

    <div class="pay">
        <a id="goPay" href="javascript:;">去支付</a>
    </div>
</div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>
<script src="/static/weChat/js/flexible.js"></script>
<script src="/static/weChat/js/basic.js"></script>
<script src="/static/weChat/js/jquery.formHelper.js"></script>
<script src="/static/weChat/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weChat/common/layer_mobile/need/right.css"/>
<script src="/static/weChat/js/weixin_g.js"></script>
<script>
    $(function () {
        $('.dispute-processing').click(function () {
            if($('.litigation').hasClass('none')){
                $('.litigation').removeClass('none');
            }else{
                $('.litigation').addClass('none');
            }
        })

        if('${row.ins_agreement.insure_path}' == ''&&"${row.product_code}".indexOf("ZZX-PAC")!=-1){
            g_ajax("/weixin/order/queryDZBD",{ins_insurance_slip_id:'${p.ins_insurance_slip_id}'},function(json){
                if(json.ret == "200"){
                    $('#down_dzbd').append('<a style="position: relative; top: 28px;font-size: 28px;" href="'+json.path+'">点击下载</a>');
                }
            },true);
        }
    });

    //投保人类型
    var role_type={"1":"参展商","2":"搭建商"}, show="";
    if('${row.applicant.role_type}'!='') show=role_type['${row.applicant.role_type}'];
    $("#applicant_role_type").html(show);
    //证件类型翻译
    var id_type={"7":"营业执照","6":"税务登记证","1":"组织机构代码证","2":"统一社会信用代码"}, show="",show2="";
    if('${row.applicant.id_type}'!='') show=id_type['${row.applicant.id_type}'];
    $("#id_type_show").text(show);

    if('${row.insurant.id_type}'!='') show2=id_type['${row.insurant.id_type}'];
    $("#id_type_show2").text(show2);


    //仲裁翻译
    var dispute={"1":"仲裁","0":"诉讼"}, show3="";
    if('${row.special.dispute}'!='') show3=dispute['${row.special.dispute}'];
    $("#dispute").html(show3);
    if('${row.special.dispute}'=='1'){
        $("#arbitral_institution_div").show();
    } else{
        $("#arbitral_institution_div").hide();
    }

    //保险期限
    /*if("${row.product_code}".indexOf("ZZX-ZA")!=-1){
        if("${row.ins_period}"!=""){
            $("#ins_period").html("保险期限：${row.ins_period}天");
        }else{
            $("#ins_period").html("保险期限：最多15天");
        }
    }*/

    //订单支付，如果订单是待支付状态，提供支付按钮
    if("${row.order_status}"=="4"){ //4待支付
        $(".pay").show();
    }else{
        $(".pay").hide();
    }

    $("#goPay").click(function () {
        if("${row.product_code}".indexOf("ZZX-ZA")!=-1){
            location.href="/ZA-API/zaCheckstand?oid=${p.ins_insurance_slip_id}&webType=app";
        }else if("${row.product_code}".indexOf("ZZX-PAC")!=-1){
            location.href="/weixin/order/zzx/payment_pac/${p.ins_insurance_slip_id}";
        }else if("${row.product_code}".indexOf("ZZX-YA")!=-1){
            location.href="/weixin/order/zzx/payment_ya/${p.ins_insurance_slip_id}";
        }
    })

    $(".show_all_text").click(function(){
        layer.open({content:$(this).text(),btn: '我知道了'})
    });


    $(document).ready(function () {
        g_ajax("/weixin/order/detail/debug/",{ins_insurance_slip_id:'${p.ins_insurance_slip_id}'},function(json){
            console.log(json);
            $("#mask").hide();
        },true);
        var bDay = Number('${row.ins_period}');
        if(bDay>0){
            $("#ins_period").html("保险期限："+bDay+"天");
        }else{
            $("#ins_period").html("保险期限：最多15天");
        }

        //投保人为搭建商时，设置
        if('${row.applicant.role_type}'=='2'){
            //判断是否是平安产品，如果是，显示参展商
            if('${row.product_code}'.indexOf('ZZX-PAC')>-1||'${row.product_code}'.indexOf('ZZX-YA')>-1){
                if('${row.special.exhibitor_name.trim()}'!=''){
                    $('#special_exhibitor_name').show();
                }
            }else if('${row.product_code}'.indexOf('ZZX-ZA')>-1) {
                $('#p_p_1').html('参展商名称');
                $('#p_p_2').html('参展商证件类型');
                $('#p_p_3').html('参展商证件号码');
            }
        }
    })
    //计算天数差的函数，通用
    function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
        var  aDate,  oDate1,  oDate2,  iDays
        aDate  =  sDate1.split("-")
        oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
        aDate  =  sDate2.split("-")
        oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
        iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
        return  iDays
    }
</script>
</html>