<%@ page language="java" contentType="text/html; charset=utf-8"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <title>找回密码</title>
</head>
<body>
<div class="ert-head">
    <div class="ert-left">
        <a href="/weixin/login/resetTwo">
            <img src="/static/weChat/images/head-left.png" />
        </a>
    </div>
    <p>找回密码</p>
</div>
<div class="search-pawd">
    <p>您已通过身份验证，请重置密码</p>
    <div class="s-pwd pwd">
        <input type="password" placeholder="请输入6-20位密码（含字母和数字）" onblur="checkPwd('pwd')" id="pwd">
        <p></p>
        <div class="error"></div>
    </div>
    <div class="reset-pwd pwd">
        <input type="password"  placeholder="请再次输入密码" onblur="checkPwdMore('pwd_more','pwd')" id="pwd_more">
        <p></p>
        <div class="error"></div>
    </div>
    <a href="javascript:;" id="sure">确认修改</a>
</div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>

<script src="/static/weChat/js/basic.js"></script>
<script src="/static/weChat/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weChat/common/layer_mobile/need/right.css">
<script>
    pwd_reg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;
    //验证密码
    function checkPwd(obj) {
        if ($('#'+obj).val() == "") {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("密码不能为空").css({"display":"block"});
            return pwd_ok = false;
        } else if (!$('#'+obj).val().match(pwd_reg)) {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("密码格式错误").css({"display":"block"});
            return pwd_ok = false;
        } else {
            $('#'+obj).css({"border-bottom":"1px solid #e6e6e6"}).siblings('p').html("").css({"display":"none"});
            return pwd_ok = true;
        }
    }

    //    再次输入密码验证
    function checkPwdMore(obj,id) {
        if ($('#'+obj).val() == "") {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("再次输入密码不能为空").css({"display":"block"});
            return pwd_more_ok = false;
        } else if ($('#'+obj).val() != $('#'+id).val()) {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("密码两次输入不一样").css({"display":"block"});
            return pwd_more_ok = false;
        } else {
            $('#'+obj).css({"border-bottom":"1px solid #e6e6e6"}).siblings('p').html("").css({"display":"none"});
            return pwd_more_ok = true;
        }
    }

    $('#sure').click(function () {
        pwd_ok = checkPwd('pwd');
        pwd_more_ok = checkPwdMore('pwd_more','pwd');
        if (pwd_ok && pwd_more_ok) {
            var  pwd= $("#pwd").val();
            $.ajax({
                type : 'POST',
                url : "/weixin/login/resetPassword",
                async: false,
                data : {
                    'pwd' : pwd
                },
                dataType : "json",
                cache : false,
                success : function(json) {
                    if (json.status == '200') {
                        layer.open({
                            content: '重置成功！'
                            ,btn: ['刷新']
                            ,yes: function(index){
                                window.location = "/weixin/login/init";
                            }
                        });
                    }else{
                        layer.open({
                            content: '重置失败'
                            ,btn: '我知道了'
                        });
                    }
                },
            });
        }
    })

</script>
</html>