<%@ page language="java" contentType="text/html; charset=utf-8"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <script src="/static/weChat/common/layer_mobile/layer.js"></script>
    <link rel="stylesheet" href="/static/weChat/common/layer_mobile/need/right.css">
    <title>注册</title>
</head>
<body>
<%--过度动画--%>
<div id="mask">
    <div class="main">
        <div class="loading">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <div class="black-mask-my"></div>
</div>
<div class="ert-head">
    <div class="ert-left">
        <a href="/weixin/login/init">
            <img src="/static/weChat/images/head-left.png" />
        </a>
    </div>
    <p>注册</p>
</div>
<div class="register-content">
    <div class="regis-tab">
        <div class="tab active">
            <p>个人用户</p>
        </div>
        <div class="tab">
            <p>企业用户</p>
        </div>
    </div>
    <div class="regis-write">
        <div class="write ert" id="sss">
            <form id="phoneForm" method="post" >
                <div class="write-phone wed">
                    <input type="hidden" name="code" value="1">
                    <input  name="email" onblur="checkBlurPhone()" placeholder="请输入手机号" id="s1"/>
                    <div class="bai-error"></div>
                    <p></p>
                </div>
                <div class="write-pwd wed">
                    <input type="password"  name="password" placeholder="请输入6-20位密码（含字母和数字）" onblur="checkPwd('s2')" minlength="6" maxlength="20" id="s2"/>
                    <div class="bai-error"></div>
                    <p></p>
                </div>
                <div class="write-pwd-more wed">
                    <input type="password"  name="again_password" placeholder="请再次输入密码" onblur="checkPwdMore('s3','s2')" minlength="6" maxlength="20" id="s3"/>
                    <div class="bai-error"></div>
                    <p></p>
                </div>
                <div class="write-code">
                    <input type="text" placeholder="请输入手机验证码" name="phone_code" id="s4">
                    <div class="bai-error"></div>
                    <div class="code" id="phone-code">
                        <p>获取手机验证码</p>
                    </div>
                </div>
                <p class="qws"></p>
                <div class="login-rules">
                    <p>
                        <input type="checkbox"  id="phoneCheckBox" name="checkbox" >
                        <label class="fl-l"></label>
                        <b class="fl-l">我已阅读并同意</b>
                        <a href="/resources/files/百联保会员协议（注册协议）.pdf" target="_blank">《百联保用户服务协议》</a>
                    </p>
                </div>
                <div class="login-commit">
                    <a href="javascript:;" id="register_one">立即注册</a>
                </div>
                <a href="/weixin/login/init" class="login-ert">已有账号，去登录</a>
            </form>
        </div>
        <div class="write ert none" id="sdd">
            <form id="emailForm" method="post" >
                <div class="write-phone wed">
                    <input type="hidden" name="code" value="2">
                    <input type="text" placeholder="请输入邮箱"  onblur="checkBlurEmail()" name="email" id="a1"/>
                    <div class="bai-error"></div>
                    <p></p>
                </div>
                <div class="write-pwd wed">
                    <input type="password"  name="password" placeholder="请输入6-20位密码（含字母和数字）" onblur="checkPwd('a2')" minlength="6" maxlength="20" id="a2"/>
                    <div class="bai-error"></div>
                    <p>奥术大师大</p>
                </div>
                <div class="write-pwd-more wed">
                    <input type="password" name="again_password" placeholder="请再次输入密码" onblur="checkPwdMore('a3','a2')" minlength="6" maxlength="20" id="a3"/>
                    <div class="bai-error"></div>
                    <p></p>
                </div>
                <div class="write-code">
                    <input type="text" placeholder="请输入邮箱验证码" name="email_code" id="a4">
                    <div class="code" id="email-code">
                        <p>获取邮箱验证码</p>
                    </div>
                </div>
                <p class="qws"></p>
                <div class="login-rules">
                    <p>
                        <input type="checkbox" id="emailCheckBox" name="checkbox">
                        <label class="fl-l"></label>
                        <b class="fl-l">我已阅读并同意</b>
                        <a href="/resources/files/百联保会员协议（注册协议）.pdf" target="_blank">《百联保用户服务协议》</a>
                    </p>
                </div>
                <div class="login-commit">
                    <a href="javascript:;" id="register_two">立即注册</a>
                </div>
                <a href="/weixin/login/init" class="login-ert">已有账号，去登录</a>
            </form>
        </div>
    </div>
</div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>

<script src="/static/weChat/js/basic.js"></script>
<script src="/static/weChat/common/jquery.formHelper.js"></script>
<script>
    phone_reg = /^1[2|3|4|5|6|7|8|9]\d{9}$/;
    email_reg = /^[A-Za-z0-9\u4e00-\u9fa5]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/;
    pwd_reg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;

    // 注册页面的验证码倒计时
    var count=60;
    var s_tit = true;
    var e_tit = true;
    var f_tit = true;

    //手机获取验证码
    $('#phone-code').click(function () {
        var obj  = $("#phoneForm").serializeJson();
        console.log(obj);
        if($('#s1').val() == ""){
            layer.open({ content: '手机号不能为空'  ,btn: '我知道了'   }); return;
        }
        if (!$('#s1').val().match(phone_reg)){
            layer.open({ content: '手机号格式错误'  ,btn: '我知道了'   }); return;
        }
        if(obj.password=="") {
            layer.open({content:"密码不可以为空",btn: '我知道了'}); return;
        }
        if(obj.password != obj.again_password ){
            layer.open({content:"两次密码不一致，请重新输入",btn: '我知道了'}); return;
        }
        if(pwd_ok==false || pwd_more_ok == false){
            layer.open({content:"密码不符合规定，请重新输入",btn: '我知道了'}); return;
        }


        if(s_tit){
            var  s1=$("#s1").val();
            if(!checkPhoneExist(s1)){
                sendPhone(this);
                sendTruePhone();
            }else{
                layer.open({
                    content: '手机已经被注册过，不能再发送验证码'
                    ,btn: '我知道了'
                });
            }
        }

    });

    function sendTruePhone(){
        var email =$("#s1").val();

        $.ajax({
            type : 'POST',
            url : "/weixin/login/sendTelPhoneCode",
            async: false,
            data : {
                'email' : email
            },
            dataType : "json",
            cache : false,
            success : function(json) {
                if (json.status == '200') {
                    layer.open({
                        content: '发送手机短信成功,请注意查收'
                        ,btn: '我知道了'
                    });
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {

            }
        });
    }

    $('#email-code').click(function () {
        var obj  = $("#emailForm").serializeJson();
        console.log(obj);
        if ($('#a1').val() == "") {
            layer.open({ content: '邮箱不能为空'  ,btn: '我知道了'   }); return;
        }
        if (!$('#a1').val().match(email_reg)){
            layer.open({ content: '邮箱格式错误'  ,btn: '我知道了'   }); return;
        }
        if(obj.password=="") {
            layer.open({content:"密码不可以为空",btn: '我知道了'}); return;
        }
        if(obj.password != obj.again_password ){
            layer.open({content:"两次密码不一致，请重新输入",btn: '我知道了'}); return;
        }
        if(pwd_ok==false || pwd_more_ok == false){
            layer.open({content:"密码不符合规定，请重新输入",btn: '我知道了'}); return;
        }


        if(e_tit){

            var  a1=$("#a1").val();
            if(!checkEmailExist(a1)){
                sendTrueEmail();
                sendEmail(this);
            }else{
                layer.open({
                    content: '邮箱已经被注册过，不能再发送验证码'
                    ,btn: '我知道了'
                });
            }
        }
    });

    function sendTrueEmail(){
        $("#mask").show();
        var email =$("#a1").val();
        $.ajax({
            type : 'POST',
            url : "/weixin/login/sendEmailCode",
            async: true,
            data : {
                'email' : email
            },
            dataType : "json",
            cache : false,
            success : function(json) {
                if (json.status == '200') {
                    layer.open({  content: '发送邮件成功,请注意查收'  ,btn: '我知道了' });
                }else{
                    layer.open({  content: '发送邮件失败'  ,btn: '我知道了' });
                }
                $("#mask").hide();
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {

            }
        });
    }



    function sendPhone(obj) {
        if (count == 0) {
            $(obj).css({"background": "-o-linear-gradient(90deg, #ff8b00, #ff6600)","background":"-moz-linear-gradient(90deg, #ff8b00, #ff6600)","background":"-webkit-linear-gradient(90deg, #ff8b00, #ff6600)","background":"linear-gradient(90deg, #ff8b00, #ff6600)"});
            $(obj).find('p').text("获取手机验证码").css({"color":"#fff","pointer-events":"auto"});
            count = 60;
            s_tit = true;
            f_tit = true;
            return;
        } else {
            $(obj).css({"background":"#ededed"});
            $(obj).find('p').text("再次发送(" + count + ")").css({"color":"#c7c7c7","pointer-events":"none"});
            count--;
            s_tit = false;
            f_tit = false;
        }
        setTimeout(function() { sendPhone(obj) }  ,1000)
    };
    function sendEmail(obj) {
        if (count == 0) {
            $(obj).css({"background": "-o-linear-gradient(90deg, #ff8b00, #ff6600)","background":"-moz-linear-gradient(90deg, #ff8b00, #ff6600)","background":"-webkit-linear-gradient(90deg, #ff8b00, #ff6600)","background":"linear-gradient(90deg, #ff8b00, #ff6600)"});
            $(obj).find('p').text("获取邮箱验证码").css({"color":"#fff","pointer-events":"auto"});
            count = 60;
            e_tit = true;
            f_tit = true;
            return;
        } else {
            $(obj).css({"background":"#ededed"});
            $(obj).find('p').text("再次发送(" + count + ")").css({"color":"#c7c7c7","pointer-events":"none"});
            count--;
            e_tit = false;
            f_tit = false;
        }
        setTimeout(function() { sendEmail(obj) }  ,1000)
    };


    function checkBlurPhone(){
        var  s1=$("#s1").val();
        checkPhone();
        if(s1!=""){
            phone_name_ok=checkPhoneExist(s1);
            if(phone_name_ok){
                layer.open({  content: '手机已经被注册过了'  ,btn: '我知道了'   });
            }
        }
    }

    function checkBlurEmail(){
        var  a1=$("#a1").val();
        checkEmail();
        if(a1!=""){
            emali_name_ok=checkEmailExist();
            if(emali_name_ok){
                layer.open({  content: '邮箱已经被注册过了'  ,btn: '我知道了'   });
            }
        }

    }

    //    验证手机是否注册过
    function checkPhoneExist(s1){
        var phone_name_ok = false;
        $.ajax({
            type: 'POST',
            url: "/weixin/login/register/checkMobile",
            data: {tel:s1},
            dataType:"json",
            async: false,
            success: function(data){
                if(data.status =="200"){
                    phone_name_ok=true;
                }
            }
        });
        return  phone_name_ok;
    }
    //    验证邮箱是否注册过
    function checkEmailExist(a1){
        var emali_name_ok = false;
        $.ajax({
            type: 'POST',
            url: "/weixin/login/register/checkEmail",
            data: {email:a1},
            dataType:"json",
            async: false,
            success: function(data){
                if(data.status =="200"){
                      emali_name_ok=true;
                }
            }
        });
        return  emali_name_ok;
    }

    //    验证手机号码
    function checkPhone() {
        if ($('#s1').val() == "") {
            $('#s1').css({"border-bottom":"1px solid red","border-left":"none"}).siblings('p').html("手机号不能为空").css({"display":"block"});
            return phone_ok = false;
        } else if (!$('#s1').val().match(phone_reg)) {
            $('#s1').css({"border-bottom":"1px solid red"}).siblings('p').html("手机号格式错误").css({"display":"block"});
            return phone_ok = false;
        } else {
            $('#s1').css({"border-bottom":"1px solid #e6e6e6"}).siblings('p').html("").css({"display":"none"});
            return phone_ok = true;
        }
    }

    //    验证邮箱
    function checkEmail() {
        if ($('#a1').val() == "") {
            $('#a1').css({"border-bottom":"1px solid red"}).siblings('p').html("邮箱不能为空").css({"display":"block"});
            return email_ok = false;
        } else if (!$('#a1').val().match(email_reg)) {
            $('#a1').css({"border-bottom":"1px solid red"}).siblings('p').html("邮箱格式错误").css({"display":"block"});
            return email_ok = false;
        } else {
            $('#a1').css({"border-bottom":"1px solid #e6e6e6"}).siblings('p').html("").css({"display":"none"});
            return email_ok = true;
        }
    }

    //验证密码
    function checkPwd(obj) {
        if ($('#'+obj).val() == "") {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("密码不能为空").css({"display":"block"});
            return pwd_ok = false;
        } else if (!$('#'+obj).val().match(pwd_reg)) {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("密码要求6-20位字母数字,必须含字母数字").css({"display":"block"});
            return pwd_ok = false;
        } else {
            $('#'+obj).css({"border-bottom":"1px solid #e6e6e6"}).siblings('p').html("").css({"display":"none"});
            return pwd_ok = true;
        }
    }

    //    再次输入密码验证
    function checkPwdMore(obj,id) {
        if ($('#'+obj).val() == "") {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("再次输入密码不能为空").css({"display":"block"});
            return pwd_more_ok = false;
        } else if ($('#'+obj).val() != $('#'+id).val()) {
            $('#'+obj).css({"border-bottom":"1px solid red"}).siblings('p').html("密码两次输入不一样").css({"display":"block"});
            return pwd_more_ok = false;
        } else {
            $('#'+obj).css({"border-bottom":"1px solid #e6e6e6"}).siblings('p').html("").css({"display":"none"});
            return pwd_more_ok = true;
        }
    }

    //    验证码验证
    function checkCode(obj) {
        var  code_ok=false;
        if ($('#'+obj).val() == "") {
            $('#'+obj).css({"border-bottom":"1px solid red"}).parents('.write-code').siblings('p.qws').html("验证码不能为空").css({"display":"block"});
            return code_ok ;
        }  else {
            $.ajax({
                type: 'POST',
                url: "/weixin/login/register/checkCodeExist",
                data:{'code': $('#'+obj).val()},
                dataType:"json",
                async: false,
                success: function(json){
                    if(json.status == "200") {
                        $('#'+obj).css({"border-bottom":"1px solid #e6e6e6"}).parents('.write-code').siblings('p.qws').html("").css({"display":"none"});
                         code_ok = true;
                    }else{
                        $('#'+obj).css({"border-bottom":"1px solid red"}).parents('.write-code').siblings('p.qws').html("验证码错误").css({"display":"block"});
                         code_ok = false;
                    }
                }
            });

        }
        return code_ok;

    }

    //手机注册
    $('#register_one').click(function () {
        if(!$("#phoneCheckBox").is(':checked')){
            layer.open({ content: '请阅读并同意百联保用户协议'  ,btn: '我知道了'   }); return;
        }
        checkPhone();

        var  s1=$("#s1").val();
        phone_name_ok=checkPhoneExist(s1);
        pwd_ok = checkPwd('s2');
        pwd_more_ok = checkPwdMore('s3','s2');
        code_ok = checkCode('s4');
        if (phone_ok && pwd_ok && pwd_more_ok && code_ok&&!phone_name_ok) {
            $.ajax({
                type: 'POST',
                url: "/weixin/login/register",
                data: $("#phoneForm").serializeJson(),
                dataType:"json",
                async: false,
                success: function(data){
                    if(data.status =="200"){
                        layer.open({
                            content: '注册成功！'
                            ,btn: ['关闭']
                            ,yes: function(index){
                                window.location.href="/weixin/login/init";
                            }
                        });
                    }else{
                        layer.open({
                            content: data.msg
                            ,btn: '我知道了'
                        });
                    }
                }
            });
        }
    });

    $("#mask").hide();

    //邮箱
    $('#register_two').click(function () {
        if(!$("#emailCheckBox").is(':checked')){
            layer.open({ content: '请阅读并同意百联保用户协议'  ,btn: '我知道了'   }); return;
        }

        checkEmail();
        var  a1=$("#a1").val();
        emali_name_ok=checkEmailExist(a1);
        pwd_ok = checkPwd('a2');
        pwd_more_ok = checkPwdMore('a3','a2');
        code_ok = checkCode('a4');
        if (email_ok && pwd_ok && pwd_more_ok && code_ok&&!emali_name_ok) {
            $.ajax({
                type: 'POST',
                url: "/weixin/login/register",
                data: $("#emailForm").serialize(),
                dataType:"json",
                async: false,
                success: function(data){
                    if(data.status =="200"){
                        layer.open({
                            content: '注册成功！'
                            ,btn: ['关闭']
                            ,yes: function(index){
                                window.location.href="/weixin/login/init";
                            }
                        });
                    }else{
                        layer.open({
                            content: data.msg
                            ,btn: '我知道了'
                        });
                    }
                }
            });
        }
    })

</script>
</html>