<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style type="text/css">
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            margin: 0 auto;
            font-family: "Microsoft YaHei";
            font-weight: 400;
            font-style: normal;
            font-size: 28px;
            color: #666;
            background-color: #F4F5F6;
        }
        body {
            width: 550px;
        }

        p {
            line-height: 20px;
            font-family: "Microsoft YaHei";
        }

        .header {
            padding: 30px 0;
            font-family: "Microsoft YaHei";
            font-size: 36px;
            line-height: 30px;
            color: #FFFFFF;
            letter-spacing: 0;
            text-align: center;
            background-color: #FF7F00;
            margin-bottom: 15px;
        }

        .active-info {
            background-color: #fff;
            margin-bottom: 15px;
            font-family: "Microsoft YaHei";
        }

        .active-info .active-header {
            height: 59px;
            text-align: center;
            font-size: 28px;
            letter-spacing: 0;
            text-align: center;
            padding-top: 12px;
            color: #333;
        }

        .active-info .active-header .bg {
            text-align: center;
            font-size: 0px;
            margin: 5px 0 10px 0
        }

        .active-info .active-header .bg img {
            width: 48px;
            height: 7px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-family: "Microsoft YaHei";
        }

        .active-content table td {
            padding: 14px;
            min-height: 50px;
            border-top: 1px solid #E7E7E7;
        }

        .active-content table .key {
            min-width: 112px;
        }

        .product-solution {
            background-color: #fff;
            margin-bottom: 15px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .product-header {
            height: 59px;
            text-align: center;
            font-size: 28px;
            letter-spacing: 0;
            text-align: center;
            padding-top: 12px;
            color: #333;
        }

        .product-solution .product-header .bg {
            text-align: center;
            font-size: 0px;
            margin: 5px 0 10px 0
        }

        .product-solution .product-header .bg img {
            width: 48px;
            height: 7px;
        }

        .product-solution .product-content {
            padding: 15px;
            border-top: 1px solid #E7E7E7;
        }

        .product-solution .product-content .title {
            font-size: 24px;
            letter-spacing: 0;
            line-height: 16px;
            margin-bottom: 8px;
            color: #333;
        }

        .product-solution .product-content .list {
            padding: 5px;
        }

        .product-solution .product-content .module-title {
            margin: 30px -15px 20px;
            text-align: center;
        }
        .product-solution .product-content .module-title img {
            width: 100%;
        }

        .product-solution .module table {
            text-align: center;
            margin-top: 15px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .module table th {
            height: 40px;
            color: #ffffff;
            background-color: #FF7F00;
            min-width: 140px;
        }

        .product-solution .module table .key {
            width: 140px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .module table td {
            background-color: #F4F4F4;
            height: 60px;
            text-align: center;
            min-width: 140px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .module table .light-yellow {
            background-color: #FFF2E5;
        }

        .product-solution .module .tip {
            margin: 10px auto 20px 5px;
        }

        .product-solution .module .extra {
            padding: 15px 20px;
            background-color: #FFF2E5;
            line-height: 24px;
        }

        .product-solution .module .extra .title {
            font-size: 20px;
            color: #333;
            letter-spacing: 0;
            line-height: 14px;
        }

        .makesure {
            background-color: #fff;
            font-family: "Microsoft YaHei";
        }

        .makesure .makesure-header {
            height: 59px;
            text-align: center;
            font-size: 28px;
            letter-spacing: 0;
            text-align: center;
            padding-top: 12px;
            color: #333;
        }

        .makesure .makesure-header .bg {
            text-align: center;
            font-size: 0px;
            margin: 5px 0 10px 0
        }

        .makesure .makesure-header .bg img {
            width: 48px;
            height: 7px;
        }

        .makesure .makesure-content {
            padding: 15px;
            border-top: 1px solid #E7E7E7;
        }

        .makesure .makesure-content .title {
            margin: 15px 0;
            font-size: 24px;
            letter-spacing: 0;
            line-height: 16px;
            color: #333;
        }

        .makesure .makesure-content table td {
            height: 40px;
            font-size: 24px;
            color: #333;
            letter-spacing: 0;
            text-align: center;
            background: url('${proPath}/resources/images/progress.png') no-repeat center;
            background-size: 100% 36px;
            font-family: "Microsoft YaHei";
        }

        .makesure .makesure-content .progress {
            text-align: center;
        }

        .makesure .makesure-content .progress img {
            width: 100%;
        }

        .makesure .makesure-content .extra {
            margin-top: 28px;
            padding: 12px;
            background-color: #FFF2E5;
            color: #333;
        }
        .makesure .makesure-content .extra .descript {
            line-height: 24px;
        }
        .makesure .makesure-content .footer-img {
            text-align: center;
        }
        .makesure .makesure-content .footer-img img {
            width: 115px;
            height: 36px;
            margin: 27px 0 12px 0;
        }
    </style>
</head>

<body style="background-color: #F4F5F6; font-size: 22px">
<div class="header">
    <div class="title">展会综合责任险</div>
    <div class="title">报价方案书</div>
</div>
<div class="active-info" style="background-color: #ffffff">
    <div class="active-header">
        <div class="title">展会信息</div>
        <div class="bg">
            <img src="${proPath}/resources/images/title-border.png" alt="">
        </div>
    </div>
    <div class="active-content">
        <table>
            <tr>
                <td class="key">展会名称</td>
                <td class="value">${name}</td>
            </tr>
            <tr>
                <td class="key">展会时间</td>
                <td class="value">${zh_star}~${zh_end}</td>
            </tr>
            <tr>
                <td class="key">展会总面积</td>
                <td class="value">${ex_acreage}平米</td>
            </tr>
            <tr>
                <td class="key">雇员总人数</td>
                <td class="value">${ex_emp_num} 人</td>
            </tr>
            <tr>
                <td class="key">保障期间</td>
                <td class="value">${bz_star}~${bz_end}</td>
            </tr>
        </table>
        <p style="height: 58px; border-top: 1px solid #E7E7E7; line-height: 58px; color: #fe6b09; padding-left: 15px;padding-top: 10px;padding-bottom: 10px">温馨提示：为了您的利益保障，建议购买保险的总额${be_z}</p>
    </div>
</div>
<div class="product-solution" style="background-color: #ffffff">
    <div class="product-header">
        <div class="title">产品方案</div>
        <div class="bg">
            <img src="${proPath}/resources/images/title-border.png" alt="">
        </div>
    </div>
    <div class="product-content">
        <div class="intro">
            <div class="title">保障责任</div>
            <p class="descript">在保险期间内，被保险人或其雇请人员在保险单载明的展览场所进行展出工作、装卸展品、运转机器以及其他与展览相关的活动中，因疏忽或过失引起的下列各项损失或费用，依照中华人民共和国法律（不包括港澳台地区法律）应由被保险人承担的经济赔偿责任，保险人按照本保险合同约定负责赔偿：</p>
            <div class="list">
                <img src="${proPath}/resources/images/point.png" alt="">
                <span>对于所租用展览场所的建筑物、各类固定设备及地面、地基的损失；</span>
            </div>
            <div class="list">
                <img src="${proPath}/resources/images/point.png" alt="">
                <span>被保险人雇请人员的人身伤亡、医疗、误工费和抚恤金等；</span>
            </div>
            <div class="list">
                <img src="${proPath}/resources/images/point.png" alt="">
                <span>第三者的人身伤亡、医疗、误工费和抚恤金等。</span>
            </div>
        </div>
        <#if (zzya != '')>
        <div class="module">
            <div class="module-title"><img src="${proPath}/resources/images/devide3.png" alt=""></div>
            <div class="title">产品优势</div>
            <p class="descript">展览展会类活动参展商（搭建商）专属保障方案，290万、400万、530万三档赔偿额，展位面积大小通用版，保障可覆盖场馆方财产损失、雇员及第三者人身损害，轻松转移参展商（搭建商）赔偿责任风险。</p>
            <table>
                <#assign yarr = ytype?string ? split(',')><#--z-3-1-2,z-5-1-2,h-7-1-2-->
                <#assign hCount = 1><#--当前第几行-->
                <#assign dohide = ''><#--要隐藏的位置-->
                <#list zzyalist as yao>
                    <#if hCount == 1>
                    <thead>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list ytype?string ? split(",") as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <th ${dosp} <#if lCount == 1> class="key" </#if>>${ya}</th>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </thead>
                    <tbody>
                    <#else>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list ytype?string ? split(",") as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <td ${dosp} <#if lCount < 3> style="background-color: #FFF2E5;" </#if> class="key">${ya}</td>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </#if>
                    <#assign hCount = hCount + 1>
                </#list>
            </tbody>
            </table>
        </div>
        </#if>
        <#if (zzpac != '')>
        <div class="module">
            <div class="module-title"><img src="${proPath}/resources/images/devide4.png" alt=""></div>
            <div class="title">产品优势</div>
            <p class="descript">专为展览展会类活动参展商量身定制，基础档保障，在线轻松投保，风险全面涵盖，保障场馆方财产损失、雇员及第三者人身损害，科学转移参展商赔偿责任风险。</p>
            <table>
                <#assign parr = ptype?string ? split(',')><#--z-3-1-2,z-5-1-2,h-7-1-2-->
                <#assign hCount = 1><#--当前第几行-->
                <#assign dohide = ''><#--要隐藏的位置-->
                <#list zzpaclist as yao>
                    <#if hCount == 1>
                    <thead>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list parr as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <th ${dosp} <#if lCount == 1> class="key" </#if>>${ya}</th>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </thead>
                    <tbody>
                    <#else>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list parr as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <td ${dosp} <#if lCount < 3> style="background-color: #FFF2E5;" </#if> class="key">${ya}</td>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </#if>
                    <#assign hCount = hCount + 1>
                </#list>
            </tbody>
            </table>
        </div>
        </#if>
        <#if (zzza != '')>
        <div class="module">
            <div class="module-title"><img src="${proPath}/resources/images/devide5.png" alt=""></div>
            <div class="title">产品优势</div>
            <p class="descript">专为展览展会类活动参展商量身定制（展位面积≤108平）300万、400万、500万三档赔偿额专享，一站式线上投保，保障可覆盖场馆方财产损失、雇员及第三者人身损害，充分转移参展商赔偿责任风险。</p>
            <table>
                <#assign zarr = ztype?string ? split(',')><#--z-3-1-2,z-5-1-2,h-7-1-2-->
                <#assign hCount = 1><#--当前第几行-->
                <#assign dohide = ''><#--要隐藏的位置-->
                <#list zzzalist as yao>
                    <#if hCount == 1>
                    <thead>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list zarr as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <th ${dosp} <#if lCount == 1> class="key" </#if>>${ya}</th>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </thead>
                    <tbody>
                    <#else>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list zarr as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <td ${dosp} <#if lCount < 3> style="background-color: #FFF2E5;" </#if> class="key">${ya}</td>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </#if>
                    <#assign hCount = hCount + 1>
                </#list>
            </tbody>
            </table>
        </div>
        </#if>
    </div>
</div>
<div class="makesure" style="background-color: #ffffff">
    <div class="makesure-header">
        <div class="title">投保说明</div>
        <div class="bg">
            <img src="${proPath}/resources/images/title-border.png" alt="">
        </div>
    </div>
    <div class="makesure-content">
        <p class="descript">一站式在线投保，方案全、价格优、一对一客服全流程协助理赔，全面保障参与活动公众的人身及财产安全，科学转移展会承办方赔偿责任风险！</p>
        <div class="title">投保流程</div>
        <div class="progress">
            <img src="${proPath}/resources/images/progress-text.png" alt="">
        </div>
        <div class="extra">
            <p class="descript">平台网址：www.bailianbao.cn</p>
            <p class="descript">客服邮箱：blbservice@baichuanxin.com</p>
            <p class="descript">客服热线：400-662-9696  周一至周五9:00-18:00</p>
        </div>
        <div class="footer-img" style="padding-top: 20px">
            <img src="${proPath}/resources/images/footer-logo.png" alt="">
        </div>
    </div>
</div>
</body>

</html>
