<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>重置密码-3</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />

</head>
<body id="login-regis">
<div class="head-more">
    <div class="more-content clearfix">
        <div class="logo fl">
            <a href="<c:url value='/'/>">
                <img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="百联保logo">
                <span>重置密码</span>
            </a>
        </div>
    </div>
</div>
<div class="s-login">
    <form action="<c:url value='/user/pwd/rest/setSuccess'/>"  id="resetForm" method="post">
        <div class="login-content">
            <h2>重置密码</h2>
            <div class="login-step">
                <ul class="clearfix">
                    <li class="on">
                        <span>确认账户</span>
                        <div class="step-number">
                            <label>1</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li class="on">
                        <span>验证身份</span>
                        <div class="step-number">
                            <label>2</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li class="on">
                        <span>重置密码</span>
                        <div class="step-number">
                            <label>3</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li>
                        <span>重置成功</span>
                        <div class="step-number">
                            <label>4</label>
                        </div>
                        <div  class="line"></div>
                    </li>
                </ul>
            </div>
            <div class="select-content">
                <div class="content-describe describe-top">
                    <div class="dec-inp">
                        <input type="password" name="password" placeholder="请输入6-20位密码(含字母和数字)" class="s2" id="password">
                        <p class="error password-error"></p>
                        <input type="password" placeholder="请再次输入密码" class="s6" id="confirm_pwd">
                        <p class="error confirm_pwd-error"></p>
                    </div>
                </div>
            </div>
            <div class="login-foot">
                <div class="login">
                    <a href="javascript:;" onclick="next()" class="ert">下一步</a>
                </div>
                <div class="sign-up">
                    <p>已经有账号？<a href="<c:url value='/user/login' />">立即登录>></a></p>
                </div>
            </div>
        </div>
    </form>
</div>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/gVerify.js' />"></script>
<script src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type='text/javascript' src='https://webchat.7moor.com/javascripts/7moorInit.js?accessId=d7359b20-9dec-11ec-a564-cd73c4e7850a&autoShow=true&language=ZHCN' async='async'>
</script>
</body>
</html>
<script>
    var baseUrl = '${pageContext.request.contextPath }';
    function checkPassword() {

        var pwd_reg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;
        var flag=false;
        var  password =$("#password").val();
        var  password_confirm=$("#confirm_pwd").val();
        if(!pwd_reg.test(password)){
            layer.msg("密码格式不正确,需要同时包含字母和数字(6-20)！");
            return  flag;
        }
        if(password==password_confirm){
            flag=true;
        }else{
            layer.msg("输入的密码不同");
        }
        return  flag;
    }
    function   next(){
        if(checkPassword()){
           $("#resetForm").submit();
//            layer.msg("success");
        }
    }
</script>