<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>重置密码-1</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
</head>
<body id="login-regis">
<div class="head-more">
    <div class="more-content clearfix">
        <div class="logo fl">
            <a href="<c:url value='/'/>">
                <img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="百联保logo">
                <span>重置密码</span>
            </a>
        </div>
    </div>
</div>
<div class="s-login">
    <form action="<c:url value='/user/pwd/rest/setUser' />"  id="resetForm" method="post">
        <div class="login-content">
            <h2>重置密码</h2>
            <div class="login-step">
                <ul class="clearfix">
                    <li class="on">
                        <span>确认账户</span>
                        <div class="step-number">
                            <label>1</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li>
                        <span>验证身份</span>
                        <div class="step-number">
                            <label>2</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li>
                        <span>重置密码</span>
                        <div class="step-number">
                            <label>3</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li>
                        <span>重置成功</span>
                        <div class="step-number">
                            <label>4</label>
                        </div>
                        <div  class="line"></div>
                    </li>
                </ul>
            </div>
            <div class="select-content">
                <div class="content-describe describe-top">
                    <div class="dec-inp">
                        <input type="text"  name="email"  id="email" placeholder="请输入邮箱地址/手机号码" class="s1">
                        <p class="error name-error"></p>
                    </div>
                </div>
            </div>
            <div class="dec-pic clearfix">
                <p class="fl"><input type="text" placeholder="请输入右侧验证码" class="s3" id="right-code"></p>
                <div class="fr" id="v_container"></div>
                <p class="error error-code"></p>
            </div>
            <div class="login-foot">
                <div class="login">
                    <a onclick="next()" class="ert">下一步</a>
                </div>
                <div class="sign-up">
                    <p>已经有账号？<a href="<c:url value='/user/login' />">立即登录>></a></p>
                </div>
            </div>
        </div>
    </form>
</div>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/gVerify.js' />"></script>
<script src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type='text/javascript' src='https://webchat.7moor.com/javascripts/7moorInit.js?accessId=d7359b20-9dec-11ec-a564-cd73c4e7850a&autoShow=true&language=ZHCN' async='async'>
</script>
<script>
    var baseUrl = '${pageContext.request.contextPath }';
    var verifyCode = new GVerify("v_container");

    function checkCodes() {
        if ($('#right-code').val() == "") {
            $('.error-code').html("验证码不能为空").addClass('wed');
            $('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return e_code_ok = false;
        } else if (verifyCode.validate(document.getElementById("right-code").value)) {
            $('.error-code').html("").removeClass('wed');
            $('#right-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return e_code_ok = true;
        } else{
            $('.error-code').html("验证码输入有错").addClass('wed');
            $('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return e_code_ok = false;
        };
    }

    $('#right-code').blur(function () {
        checkCodes();
    })

    function  checkUserExist(){
        var flag=false;
        var email = $("#email").val();
        if(email != $("#email").attr("defaultValue") && email != "") {
            $.ajax({
                type: 'POST',
                url: baseUrl + "/user/register/checkUserExist",
                data:{'email': email},
                dataType:"json",
                async: false,
                success: function(json){
                    if(json.statusCode == '2') {
                        layer.msg("该账号不存在！",{shift: 1});
                        flag = false;
                    }else{
                        flag=true;
                    }

                }
            });
        }else{
            flag = false;
        }
        return flag;
    }
    function   next(){

        var email = $("#email").val();
        var  rightCode= $("#right-code").val();
        if(email==''){
            layer.msg("账号不能为空!!");
            return ;
        }
        if(rightCode==''){
            layer.msg("验证码不能为空!");
            return ;
        }
        if(verifyCode.validate(rightCode)){
            if(checkUserExist()){
                $("#resetForm").submit();
            }else{
                layer.msg("该账号不存在！");
            }
        }else{
            layer.msg("验证码输入错误!!");
        }

    }
</script>
</body>
</html>